/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.I18nManager;
import tim.prune.data.GradientCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.UnitSet;
import tim.prune.gui.profile.ProfileData;

public class GradientData
extends ProfileData {
    public GradientData(Track track) {
        super(track);
    }

    public void init(UnitSet unitSet) {
        this.setUnitSet(unitSet);
        this.initArrays();
        this._hasData = false;
        this._maxValue = 0.0;
        this._minValue = 0.0;
        SpeedValue speedValue = new SpeedValue();
        if (this._track != null) {
            int n = 0;
            while (n < this._track.getNumPoints()) {
                GradientCalculator.calculateGradient(this._track, n, speedValue);
                if (speedValue.isValid()) {
                    double d;
                    this._pointValues[n] = d = speedValue.getValue();
                    if (d < this._minValue || !this._hasData) {
                        this._minValue = d;
                    }
                    if (d > this._maxValue || !this._hasData) {
                        this._maxValue = d;
                    }
                    this._hasData = true;
                }
                this._pointHasData[n] = speedValue.isValid();
                ++n;
            }
        }
    }

    public String getLabel() {
        return I18nManager.getText("fieldname.gradient");
    }

    public String getNoDataKey() {
        return "display.noaltitudes";
    }
}

