/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;

public class ASTDiffBuilder
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final TreeChangeEventImpl myEvent;

    public ASTDiffBuilder(@NotNull PsiFileImpl fileImpl) {
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "<init>"));
        }
        TreeAspect modelAspect = PomManager.getModel(fileImpl.getProject()).getModelAspect(TreeAspect.class);
        this.myEvent = new TreeChangeEventImpl(modelAspect, fileImpl.getTreeElement());
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeReplaced"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeReplaced"));
        }
        if (!(oldNode instanceof FileElement) || !(newNode instanceof FileElement)) {
            ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newNode);
            change.setReplaced(oldNode);
            this.myEvent.addElementaryChange(newNode, change);
        }
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode parent2, @NotNull ASTNode child) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeDeleted"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeDeleted"));
        }
        this.myEvent.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeInserted"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "nodeInserted"));
        }
        this.myEvent.addElementaryChange(newNode, ChangeInfoImpl.create((short)0, newNode));
    }

    @NotNull
    public TreeChangeEventImpl getEvent() {
        TreeChangeEventImpl treeChangeEventImpl = this.myEvent;
        if (treeChangeEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/ASTDiffBuilder", "getEvent"));
        }
        return treeChangeEventImpl;
    }
}

