/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.TimeSource;

class MonotonicClock
implements Clock {
    private static final long SYNC_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private final TimeSource timeSource;
    private long syncMillis;
    private long syncNanos;
    private long max;
    private final Lock lock = new ReentrantLock();
    private long syncIntervalMillis;

    MonotonicClock() {
        this(TimeSource.SYSTEM, SYNC_INTERVAL_MILLIS);
    }

    @VisibleForTesting
    MonotonicClock(TimeSource timeSource, long syncIntervalMillis) {
        this.timeSource = timeSource;
        this.syncMillis = this.max = timeSource.currentTimeMillis();
        this.syncNanos = timeSource.nanoTime();
        this.syncIntervalMillis = syncIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentTime() {
        long currentTime;
        block3: {
            this.lock.lock();
            try {
                long nowNanos = this.timeSource.nanoTime();
                long sinceSyncNanos = nowNanos - this.syncNanos;
                long sinceSyncMillis = TimeUnit.NANOSECONDS.toMillis(sinceSyncNanos);
                currentTime = this.syncMillis + sinceSyncMillis;
                if (sinceSyncMillis < this.syncIntervalMillis) break block3;
                this.syncNanos = nowNanos;
                this.syncMillis = this.max = Math.max(this.timeSource.currentTimeMillis(), this.max);
                long l = this.max;
                Object var12_7 = null;
                this.lock.unlock();
                return l;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        long l = this.max = Math.max(currentTime, this.max);
        Object var12_8 = null;
        this.lock.unlock();
        return l;
    }
}

