/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;

public class DirectoryBuildCacheService
implements LocalBuildCacheService,
BuildCacheService {
    private final PathKeyFileStore fileStore;
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;
    private final String failedFileSuffix;

    public DirectoryBuildCacheService(PathKeyFileStore fileStore, PersistentCache persistentCache, BuildCacheTempFileStore tempFileStore, String failedFileSuffix) {
        this.fileStore = fileStore;
        this.persistentCache = persistentCache;
        this.tempFileStore = tempFileStore;
        this.failedFileSuffix = failedFileSuffix;
    }

    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        LoadAction loadAction = new LoadAction(reader);
        this.load(key, loadAction);
        return loadAction.loaded;
    }

    @Override
    public void load(final BuildCacheKey key, final Action<? super File> reader) {
        this.persistentCache.withFileLock((Factory)new Factory<Void>(){

            public Void create() {
                LocallyAvailableResource resource = DirectoryBuildCacheService.this.fileStore.get(key.getHashCode());
                if (resource != null) {
                    File file = resource.getFile();
                    GFileUtils.touch((File)file);
                    try {
                        reader.execute((Object)file);
                    }
                    catch (Exception e) {
                        File failedFile = new File(file.getAbsolutePath() + DirectoryBuildCacheService.this.failedFileSuffix);
                        GFileUtils.deleteQuietly((File)failedFile);
                        file.renameTo(failedFile);
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void store(final BuildCacheKey key, final BuildCacheEntryWriter result) throws BuildCacheException {
        this.tempFileStore.allocateTempFile(key, (Action<? super File>)new Action<File>(){

            public void execute(File file) {
                try (Closer closer = Closer.create();){
                    result.writeTo((OutputStream)closer.register((Closeable)new FileOutputStream(file)));
                }
                catch (IOException ex) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)ex);
                }
                DirectoryBuildCacheService.this.store(key, file);
            }
        });
    }

    @Override
    public void store(final BuildCacheKey key, final File file) {
        this.persistentCache.useCache(new Runnable(){

            @Override
            public void run() {
                DirectoryBuildCacheService.this.fileStore.move((Object)key.getHashCode(), file);
            }
        });
    }

    @Override
    public void allocateTempFile(BuildCacheKey key, Action<? super File> action) {
        this.tempFileStore.allocateTempFile(key, action);
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }

    private static class LoadAction
    implements Action<File> {
        private final BuildCacheEntryReader reader;
        boolean loaded;

        private LoadAction(BuildCacheEntryReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(File file) {
            try {
                GFileUtils.touch((File)file);
                Closer closer = Closer.create();
                FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
                try {
                    this.reader.readFrom(stream);
                    this.loaded = true;
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException((Throwable)ex);
            }
        }
    }
}

