/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Map;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.id.UniqueId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTaskExecution
extends TaskExecution {
    private ImmutableSortedMap<String, Long> inputFilesSnapshotIds;
    private ImmutableSortedMap<String, Long> outputFilesSnapshotIds;
    private Long discoveredFilesSnapshotId;
    private final FileSnapshotRepository snapshotRepository;
    private ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshot;
    private ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot;
    private FileCollectionSnapshot discoveredFilesSnapshot;

    public LazyTaskExecution(FileSnapshotRepository snapshotRepository, TaskExecutionSnapshot taskExecutionSnapshot) {
        this(snapshotRepository, taskExecutionSnapshot.getBuildInvocationId(), taskExecutionSnapshot.getTaskImplementation(), taskExecutionSnapshot.getTaskActionsImplementations(), taskExecutionSnapshot.getInputProperties(), taskExecutionSnapshot.getCacheableOutputProperties(), taskExecutionSnapshot.getDeclaredOutputFilePaths(), taskExecutionSnapshot.isSuccessful(), null);
        this.inputFilesSnapshotIds = taskExecutionSnapshot.getInputFilesSnapshotIds();
        this.discoveredFilesSnapshotId = taskExecutionSnapshot.getDiscoveredFilesSnapshotId();
        this.outputFilesSnapshotIds = taskExecutionSnapshot.getOutputFilesSnapshotIds();
    }

    public LazyTaskExecution(FileSnapshotRepository snapshotRepository, UniqueId buildInvocationId, ImplementationSnapshot taskImplementation, ImmutableList<ImplementationSnapshot> taskActionsImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedSet<String> outputPropertyNames, ImmutableSet<String> declaredOutputFilePaths, ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshot, FileCollectionSnapshot discoveredFilesSnapshot, ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot, OverlappingOutputs detectedOverlappingOutputs) {
        this(snapshotRepository, buildInvocationId, taskImplementation, taskActionsImplementations, inputProperties, outputPropertyNames, declaredOutputFilePaths, null, detectedOverlappingOutputs);
        this.inputFilesSnapshot = inputFilesSnapshot;
        this.discoveredFilesSnapshot = discoveredFilesSnapshot;
        this.outputFilesSnapshot = outputFilesSnapshot;
    }

    private LazyTaskExecution(FileSnapshotRepository snapshotRepository, UniqueId buildInvocationId, ImplementationSnapshot taskImplementation, ImmutableList<ImplementationSnapshot> taskActionImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedSet<String> outputPropertyNames, ImmutableSet<String> declaredOutputFilePaths, Boolean successful, OverlappingOutputs detectedOverlappingOutputs) {
        super(buildInvocationId, taskImplementation, taskActionImplementations, inputProperties, outputPropertyNames, declaredOutputFilePaths, successful, detectedOverlappingOutputs);
        this.snapshotRepository = snapshotRepository;
    }

    @Override
    public ImmutableSortedMap<String, FileCollectionSnapshot> getInputFilesSnapshot() {
        if (this.inputFilesSnapshot == null) {
            this.inputFilesSnapshot = this.loadSnapshot((Map<String, Long>)this.inputFilesSnapshotIds);
        }
        return this.inputFilesSnapshot;
    }

    @Override
    public FileCollectionSnapshot getDiscoveredInputFilesSnapshot() {
        if (this.discoveredFilesSnapshot == null) {
            this.discoveredFilesSnapshot = this.snapshotRepository.get(this.discoveredFilesSnapshotId);
        }
        return this.discoveredFilesSnapshot;
    }

    @Override
    public void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot discoveredFilesSnapshot) {
        this.discoveredFilesSnapshot = discoveredFilesSnapshot;
        this.discoveredFilesSnapshotId = null;
    }

    @Override
    public ImmutableSortedMap<String, FileCollectionSnapshot> getOutputFilesSnapshot() {
        if (this.outputFilesSnapshot == null) {
            this.outputFilesSnapshot = this.loadSnapshot((Map<String, Long>)this.outputFilesSnapshotIds);
        }
        return this.outputFilesSnapshot;
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> loadSnapshot(Map<String, Long> snapshotIds) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, Long> entry : snapshotIds.entrySet()) {
            String propertyName = entry.getKey();
            Long snapshotId = entry.getValue();
            FileCollectionSnapshot fileCollectionSnapshot = this.snapshotRepository.get(snapshotId);
            builder.put((Object)propertyName, (Object)fileCollectionSnapshot);
        }
        return builder.build();
    }

    @Override
    public void setOutputFilesSnapshot(ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot) {
        this.outputFilesSnapshot = outputFilesSnapshot;
        this.outputFilesSnapshotIds = null;
    }

    public TaskExecutionSnapshot snapshot() {
        return new TaskExecutionSnapshot(this.isSuccessful(), this.getBuildInvocationId(), this.getTaskImplementation(), this.getTaskActionImplementations(), this.getOutputPropertyNamesForCacheKey(), this.getDeclaredOutputFilePaths(), this.getInputProperties(), this.inputFilesSnapshotIds, this.discoveredFilesSnapshotId, this.outputFilesSnapshotIds);
    }

    public void storeSnapshots() {
        if (this.inputFilesSnapshotIds == null && this.inputFilesSnapshot != null) {
            this.inputFilesSnapshotIds = this.storeSnapshot((Map<String, FileCollectionSnapshot>)this.inputFilesSnapshot);
        }
        if (this.outputFilesSnapshotIds == null && this.outputFilesSnapshot != null) {
            this.outputFilesSnapshotIds = this.storeSnapshot((Map<String, FileCollectionSnapshot>)this.outputFilesSnapshot);
        }
        if (this.discoveredFilesSnapshotId == null && this.discoveredFilesSnapshot != null) {
            this.discoveredFilesSnapshotId = this.snapshotRepository.add(this.discoveredFilesSnapshot);
        }
    }

    private ImmutableSortedMap<String, Long> storeSnapshot(Map<String, FileCollectionSnapshot> snapshot) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, FileCollectionSnapshot> entry : snapshot.entrySet()) {
            String propertyName = entry.getKey();
            FileCollectionSnapshot fileCollectionSnapshot = entry.getValue();
            Long snapshotId = this.snapshotRepository.add(fileCollectionSnapshot);
            builder.put((Object)propertyName, (Object)snapshotId);
        }
        return builder.build();
    }

    public void removeUnnecessarySnapshots() {
        if (this.inputFilesSnapshotIds != null) {
            this.removeUnnecessarySnapshot((Map<String, Long>)this.inputFilesSnapshotIds);
            this.inputFilesSnapshotIds = null;
        }
        if (this.outputFilesSnapshotIds != null) {
            this.removeUnnecessarySnapshot((Map<String, Long>)this.outputFilesSnapshotIds);
            this.outputFilesSnapshotIds = null;
        }
        if (this.discoveredFilesSnapshotId != null) {
            this.snapshotRepository.remove(this.discoveredFilesSnapshotId);
            this.discoveredFilesSnapshotId = null;
        }
    }

    private void removeUnnecessarySnapshot(Map<String, Long> snapshot) {
        for (Long id : snapshot.values()) {
            this.snapshotRepository.remove(id);
        }
    }
}

