<!-- Welcome to LiteIDE X -->

LiteIDE X
=========

### Introduction

_LiteIDE is a simple, open source, cross-platform Go IDE._

* Version: X2
* Author: [visualfc](mailto:visualfc@gmail.com)


### Features
* Core features
	* System environment management
	* Configurable build commands
	* Simple and open debug system
	* Kate format for auto-completion and theming
	* Configurable auto-completion with WordApi
	* MIME type based system
	* Plugin support
* Golang support
	* Package browser
	* Class view and outline
	* Document browser
	* [Gocode](https://github.com/nsf/gocode) support
	* GOPATH API index
	* View Expression Info
	* Jump to Declaration
	* Find Usages
	* Code Refactor
	* Go playground
* Markdown support
	* Live preview and synchronized scroll
	* Custom CSS with themes 
	* Export Markdown as HTML or PDF
	* Markdown batch conversion with optional merging
* Golang Present support
	* Present syntax editor
	* Auto verify at save time
	* Export to html

### Supported Systems
* Windows x86 (32-bit or 64-bit) 
* Linux x86 (32-bit or 64-bit)
* MacOS X10.6

### LiteIDE Command Line
	liteide [files|folder] [--select-env id] [--local-setting] [--user-setting] [--reset-setting]
	 
	--select-env [system|win32|cross-linux64|...]     select init environment id
	--local-setting   force use local setting
	--user-setting    force use user setting
	--reset-setting   reset current setting ( clear setting file)

### Website
* Source code
	* <https://github.com/visualfc/liteide>
* Binary downloads 
	* <http://sourceforge.net/projects/liteide/files>
* Google group
	* <https://groups.google.com/group/liteide-dev>	
* FAQ
	* <https://github.com/visualfc/liteide/blob/master/liteidex/deploy/welcome/en/guide.md>	
* Support LiteIDE
	* <http://visualfc.github.com/support>