#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cipher-aes
version: 0.2.11
id: cipher-aes-0.2.11-BiS6vR9PEggJR6jGbCx7bN
key: cipher-aes-0.2.11-BiS6vR9PEggJR6jGbCx7bN
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-cipher-aes
synopsis: Fast AES cipher implementation with advanced mode of operations
description:
    Fast AES cipher implementation with advanced mode of operations.
    .
    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).
    .
    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.
    .
    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.
    .
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Cipher.AES
abi: b4d47a920bbce68c7dcc64173c95c985
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/cipher-aes-0.2.11
library-dirs: /usr/lib/ghc-8.2.1/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/cipher-aes-0.2.11
hs-libraries: HScipher-aes-0.2.11-BiS6vR9PEggJR6jGbCx7bN
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    byteable-0.1.1-3VfNJqauCum9lD10cS8nmH
    securemem-0.1.9-FBW2jhbDv3PKBgqrsNUU9E
    crypto-cipher-types-0.0.9-IqUBudHeHhCAqh9d22Ljzt
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             byteable-0.1.1-3VfNJqauCum9lD10cS8nmH=1033f0009ffea40431f55947ee171f57
             securemem-0.1.9-FBW2jhbDv3PKBgqrsNUU9E=c8f3cdf72b4400b820ed9367c4705556
             crypto-cipher-types-0.0.9-IqUBudHeHhCAqh9d22Ljzt=30e642a122a8b54fc02d6059407a2d32
haddock-interfaces: /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html: /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

