# Visualization Toolkit (VTK) Tcl package configuration.

package ifneeded vtkinit {7.1} {
  namespace eval ::vtk::init {
    proc load_library_package {libName libPath {libPrefix {lib}}} {
      #first try to load a static package, then try the shared package.
      if {[catch "load {} $libName"]} {
        set libExt [info sharedlibextension]
        set currentDirectory [pwd]
        set libFile [file join $libPath "$libPrefix$libName-7.1$libExt"]
        if {[catch "cd {$libPath}; load {$libFile}" errorMessage]} {
          puts $errorMessage
        }
        cd $currentDirectory
      }
    }
    proc require_package {name {version {7.1}}} {
      if {[catch "package require -exact $name $version" errorMessage]} {
        puts $errorMessage
        return 0
      } else {
        return 1
      }
    }
    set version {7.1}
    set kits {}
    foreach kit { base  CommonCore CommonMath CommonMisc CommonSystem CommonTransforms CommonDataModel CommonColor CommonExecutionModel CommonComputationalGeometry FiltersCore FiltersGeneral ImagingCore ImagingFourier FiltersStatistics FiltersExtraction InfovisCore FiltersGeometry FiltersSources RenderingCore RenderingFreeType RenderingContextIID ChartsCore IOCore IOLegacy IOXMLParser IOXML IOInfovis IOImage RenderingOpenGLII RenderingContextOpenGLII TestingRendering ImagingSources FiltersHybrid FiltersModeling ImagingColor ImagingGeneral ImagingHybrid InteractionStyle RenderingAnnotation RenderingVolume InteractionWidgets ViewsCore ViewsContextIID FiltersGeneric IOGeometry DomainsChemistry RenderingChemistryOpenGLII ParallelCore FiltersAMR IOAMR ImagingMath RenderingVolumeOpenGLII IOExodus FiltersFlowPaths FiltersImaging RenderingLabel ImagingStencil FiltersHyperTree FiltersParallel FiltersParallelImaging ParallelMPI FiltersParallelMPI RenderingParallel FiltersParallelDIYII FiltersParallelFlowPaths IONetCDF IOParallel FiltersParallelGeometry IOParallelXML FiltersParallelStatistics FiltersPoints FiltersProgrammable FiltersReebGraph FiltersSMP FiltersSelection FiltersTexture FiltersVerdict IOSQL InfovisLayout ViewsInfovis GeovisCore ViewsGeovis IOEnSight RenderingGLtoPSOpenGLII IOExport IOMovie IOFFMPEG IOGDAL IOGeoJSON InteractionImage IOImport IOLSDyna IOMINC IOMPIImage IOMPIParallel IOMySQL IOODBC IOPLY IOParallelExodus IOParallelLSDyna IOParallelNetCDF IOPostgreSQL IOTecplotTable IOVPIC IOVideo IOXdmfII IOXdmfIII ImagingStatistics RenderingImage ImagingMorphological InfovisBoostGraphAlgorithms RenderingLOD PythonInterpreter RenderingLICOpenGLII RenderingMatplotlib RenderingParallelLIC RenderingQt RenderingSceneGraph RenderingTk RenderingVolumeAMR } {
      lappend kits [string tolower "${kit}"]
    }
  }
  package provide vtkinit {7.1}
}

foreach kit {  CommonCore CommonMath CommonMisc CommonSystem CommonTransforms CommonDataModel CommonColor CommonExecutionModel CommonComputationalGeometry FiltersCore FiltersGeneral ImagingCore ImagingFourier FiltersStatistics FiltersExtraction InfovisCore FiltersGeometry FiltersSources RenderingCore RenderingFreeType RenderingContextIID ChartsCore IOCore IOLegacy IOXMLParser IOXML IOInfovis IOImage RenderingOpenGLII RenderingContextOpenGLII TestingRendering ImagingSources FiltersHybrid FiltersModeling ImagingColor ImagingGeneral ImagingHybrid InteractionStyle RenderingAnnotation RenderingVolume InteractionWidgets ViewsCore ViewsContextIID FiltersGeneric IOGeometry DomainsChemistry RenderingChemistryOpenGLII ParallelCore FiltersAMR IOAMR ImagingMath RenderingVolumeOpenGLII IOExodus FiltersFlowPaths FiltersImaging RenderingLabel ImagingStencil FiltersHyperTree FiltersParallel FiltersParallelImaging ParallelMPI FiltersParallelMPI RenderingParallel FiltersParallelDIYII FiltersParallelFlowPaths IONetCDF IOParallel FiltersParallelGeometry IOParallelXML FiltersParallelStatistics FiltersPoints FiltersProgrammable FiltersReebGraph FiltersSMP FiltersSelection FiltersTexture FiltersVerdict IOSQL InfovisLayout ViewsInfovis GeovisCore ViewsGeovis IOEnSight RenderingGLtoPSOpenGLII IOExport IOMovie IOFFMPEG IOGDAL IOGeoJSON InteractionImage IOImport IOLSDyna IOMINC IOMPIImage IOMPIParallel IOMySQL IOODBC IOPLY IOParallelExodus IOParallelLSDyna IOParallelNetCDF IOPostgreSQL IOTecplotTable IOVPIC IOVideo IOXdmfII IOXdmfIII ImagingStatistics RenderingImage ImagingMorphological InfovisBoostGraphAlgorithms RenderingLOD PythonInterpreter RenderingLICOpenGLII RenderingMatplotlib RenderingParallelLIC RenderingQt RenderingSceneGraph RenderingTk RenderingVolumeAMR } {
  package ifneeded "vtk${kit}TCL" {7.1} "
    package require -exact vtkinit {7.1}
    ::vtk::init::load_library_package {vtk${kit}TCL} {[file dirname [file dirname [file dirname [info script]]]]}
  "
  package ifneeded "vtk[string tolower ${kit}]" {7.1} "
    package require -exact vtkinit {7.1}
    if {\[catch {source \[file join {[file dirname [info script]]} {vtk[string tolower ${kit}]} {vtk[string tolower ${kit}].tcl}\]} errorMessage\]} {
      puts \$errorMessage
    }
  "
}

foreach src {vtk vtkbase vtkinteraction vtktesting} {
  package ifneeded ${src} {7.1} "
    package require -exact vtkinit {7.1}
    if {\[catch {source \[file join {[file dirname [info script]]} {$src} {$src.tcl}\]} errorMessage\]} {
      puts \$errorMessage
    }
  "
}
