/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IcePatch2;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import com.zeroc.IcePatch2.FileInfo;
import java.util.Optional;

public final class FileInfoSeqHelper {
    public static void write(OutputStream ostr, FileInfo[] v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.length);
            for (int i0 = 0; i0 < v.length; ++i0) {
                FileInfo.ice_write(ostr, v[i0]);
            }
        }
    }

    public static FileInfo[] read(InputStream istr) {
        int len0 = istr.readAndCheckSeqSize(7);
        FileInfo[] v = new FileInfo[len0];
        for (int i0 = 0; i0 < len0; ++i0) {
            v[i0] = FileInfo.ice_read(istr);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<FileInfo[]> v) {
        if (v != null && v.isPresent()) {
            FileInfoSeqHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, FileInfo[] v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            FileInfoSeqHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<FileInfo[]> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            FileInfo[] v = FileInfoSeqHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

