/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class FontFamilyResolveHandler
extends ConstantsResolveHandler {
    public FontFamilyResolveHandler() {
        this.addNormalizeValue(FontFamilyValues.CURSIVE);
        this.addNormalizeValue(FontFamilyValues.FANTASY);
        this.addNormalizeValue(FontFamilyValues.MONOSPACE);
        this.addNormalizeValue(FontFamilyValues.SANS_SERIF);
        this.addNormalizeValue(FontFamilyValues.SERIF);
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_WEIGHT, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValueList cSSValueList;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputProcessorMetaData = layoutProcess.getOutputMetaData();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (cSSValue instanceof CSSValueList) {
            cSSValueList = (CSSValueList)cSSValue;
            for (int i = 0; i < cSSValueList.getLength(); ++i) {
                String string;
                CSSValue cSSValue2;
                CSSValue cSSValue3 = cSSValueList.getItem(i);
                if (cSSValue3 instanceof CSSConstant) {
                    cSSValue2 = (CSSConstant)this.lookupValue((CSSConstant)cSSValue3);
                    string = outputProcessorMetaData.getFontFamilyForGenericName((CSSConstant)cSSValue2);
                    fontSpecification.setFontFamily(string.getFamilyName());
                    if (layoutProcess.getOutputMetaData().isValid(fontSpecification)) {
                        return;
                    }
                    DebugLog.log((Object)"Invalid state after setting predefined font family.");
                    continue;
                }
                if (!(cSSValue3 instanceof CSSStringValue)) continue;
                cSSValue2 = (CSSStringValue)cSSValue3;
                string = ((CSSStringValue)cSSValue2).getValue();
                fontSpecification.setFontFamily(string);
                if (!layoutProcess.getOutputMetaData().isValid(fontSpecification)) continue;
                return;
            }
        } else if (cSSValue instanceof CSSConstant && FontFamilyValues.NONE.equals(cSSValue)) {
            fontSpecification.setFontFamily(null);
            return;
        }
        cSSValueList = outputProcessorMetaData.getDefaultFontFamily();
        fontSpecification.setFontFamily(cSSValueList.getFamilyName());
        if (!layoutProcess.getOutputMetaData().isValid(fontSpecification)) {
            throw new IllegalStateException("Invalid state after setting the default font family.");
        }
    }
}

