/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedToken;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableTextBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.page.RenderPageContext;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class UpdateTokensStep
extends IterateStructuralProcessStep {
    private LayoutProcess layoutProcess;
    private RenderPageContext pageContext;
    private DocumentContext documentContext;
    private CodePointBuffer buffer;

    public void compute(LogicalPageBox logicalPageBox, LayoutProcess layoutProcess, RenderPageContext renderPageContext) {
        this.layoutProcess = layoutProcess;
        this.pageContext = renderPageContext;
        this.documentContext = this.layoutProcess.getDocumentContext();
        this.startProcessing(logicalPageBox);
        this.documentContext = null;
        this.pageContext = null;
    }

    protected boolean startInlineBox(InlineRenderBox inlineRenderBox) {
        if (inlineRenderBox instanceof RenderableTextBox) {
            RenderableTextBox renderableTextBox = (RenderableTextBox)inlineRenderBox;
            ResolvedToken resolvedToken = renderableTextBox.getResolvedToken();
            String string = this.resolveToken(resolvedToken);
            if (ObjectUtilities.equal((Object)renderableTextBox.getResolvedText(), (Object)string)) {
                return false;
            }
            renderableTextBox.clear();
            State state = renderableTextBox.getTextFactory();
            try {
                RenderableTextFactory renderableTextFactory = (RenderableTextFactory)state.restore(this.layoutProcess);
                RenderNode[] renderNodeArray = this.createText(string, renderableTextBox.getLayoutContext(), renderableTextFactory);
                for (int i = 0; i < renderNodeArray.length; ++i) {
                    renderableTextBox.addGeneratedChild(renderNodeArray[i]);
                }
                RenderNode[] renderNodeArray2 = renderableTextFactory.finishText();
                for (int i = 0; i < renderNodeArray2.length; ++i) {
                    renderableTextBox.addGeneratedChild(renderNodeArray2[i]);
                }
            }
            catch (StateException stateException) {
                throw new IllegalStateException("Failed to resolve token ");
            }
            return false;
        }
        return true;
    }

    private RenderNode[] createText(String string, LayoutContext layoutContext, RenderableTextFactory renderableTextFactory) {
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(string, this.buffer);
        int[] nArray = this.buffer.getBuffer();
        return renderableTextFactory.createText(nArray, 0, this.buffer.getLength(), layoutContext);
    }

    protected String resolveToken(ResolvedToken resolvedToken) {
        if (resolvedToken instanceof ResolvedStringToken) {
            ResolvedStringToken resolvedStringToken = (ResolvedStringToken)resolvedToken;
            ComputedToken computedToken = resolvedStringToken.getParent();
            if (computedToken instanceof VariableToken) {
                VariableToken variableToken = (VariableToken)computedToken;
                String string = variableToken.getVariable();
                CSSValue cSSValue = this.documentContext.getStringPolicy(string);
                return this.pageContext.getString(string, cSSValue);
            }
        } else if (resolvedToken instanceof ResolvedCounterToken) {
            ResolvedCounterToken resolvedCounterToken = (ResolvedCounterToken)resolvedToken;
            CounterToken counterToken = resolvedCounterToken.getParent();
            String string = counterToken.getName();
            CounterStyle counterStyle = counterToken.getStyle();
            CSSValue cSSValue = this.documentContext.getCounterPolicy(string);
            Integer n = this.pageContext.getCounter(string, cSSValue);
            return counterStyle.getCounterValue(n);
        }
        return resolvedToken.getText();
    }
}

