/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategoriesListener;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisteredSnapshotCategories {
    private static RegisteredSnapshotCategories sharedInstance;
    private final Set<SnapshotCategoriesListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Set<SnapshotCategory> categories = Collections.synchronizedSet(new HashSet());

    public static synchronized RegisteredSnapshotCategories sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new RegisteredSnapshotCategories();
        }
        return sharedInstance;
    }

    public void addCategoriesListener(SnapshotCategoriesListener listener) {
        this.listeners.add(listener);
    }

    public void removeCategoriesListener(SnapshotCategoriesListener listener) {
        this.listeners.remove(listener);
    }

    public void registerCategory(SnapshotCategory category) {
        this.categories.add(category);
        this.fireCategoryRegistered(category);
    }

    public void unregisterCategory(SnapshotCategory category) {
        this.categories.remove(category);
        this.fireCategoryUnregistered(category);
    }

    public List<SnapshotCategory> getVisibleCategories() {
        ArrayList<SnapshotCategory> allCategories = new ArrayList<SnapshotCategory>(this.categories);
        ArrayList<SnapshotCategory> visibleCategories = new ArrayList<SnapshotCategory>();
        for (SnapshotCategory category : allCategories) {
            if (category.getPreferredPosition() == Integer.MIN_VALUE) continue;
            visibleCategories.add(category);
        }
        Collections.sort(visibleCategories, Positionable.COMPARATOR);
        return visibleCategories;
    }

    public List<SnapshotCategory> getOpenSnapshotCategories() {
        ArrayList<SnapshotCategory> allCategories = new ArrayList<SnapshotCategory>(this.categories);
        ArrayList<SnapshotCategory> openSnapshotCategories = new ArrayList<SnapshotCategory>();
        for (SnapshotCategory category : allCategories) {
            if (!category.supportsOpenSnapshot()) continue;
            openSnapshotCategories.add(category);
        }
        Collections.sort(openSnapshotCategories, Positionable.COMPARATOR);
        return openSnapshotCategories;
    }

    public List<SnapshotCategory> getAllCategories() {
        ArrayList<SnapshotCategory> allCategories = new ArrayList<SnapshotCategory>(this.categories);
        Collections.sort(allCategories, Positionable.COMPARATOR);
        return allCategories;
    }

    private void fireCategoryRegistered(SnapshotCategory category) {
        HashSet<SnapshotCategoriesListener> listenersSet = new HashSet<SnapshotCategoriesListener>(this.listeners);
        for (SnapshotCategoriesListener listener : listenersSet) {
            listener.categoryRegistered(category);
        }
    }

    private void fireCategoryUnregistered(SnapshotCategory category) {
        HashSet<SnapshotCategoriesListener> listenersSet = new HashSet<SnapshotCategoriesListener>(this.listeners);
        for (SnapshotCategoriesListener listener : listenersSet) {
            listener.categoryUnregistered(category);
        }
    }

    private RegisteredSnapshotCategories() {
    }
}

