/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.codecs.CodecFormatException;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.midi.MidiOutputStream;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.Performance;
import dguitar.players.sound.midi.MidiFiler;
import dguitar.players.sound.midi.MidiPlayer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import test.songs.MidiSongDefinition;
import test.songs.SongArchive;
import test.suite.MidiTestCase;

public class MidiCodecTest
extends MidiTestCase {
    public void testAguaGPWithLivePlayer() throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        MidiSongDefinition sd = SongArchive.aguaSongDefinition();
        try {
            GPInputStream gpis = new GPInputStream(sd.getGpFileName());
            GPSong gpsong = (GPSong)gpis.readObject();
            gpis.close();
            Song song = GPAdaptor.makeSong(gpsong);
            MasterPlayer player = new MasterPlayer();
            player.setSoundPlayer(new MidiPlayer());
            Performance performance = player.arrange(song, null);
            MidiOutputStream mos = new MidiOutputStream(new FileOutputStream(testFile.getMidiFileName()));
            mos.write(performance);
            mos.close();
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), sd.getChannels(), sd.getEventRemap());
        }
        catch (FileNotFoundException e) {
            MidiCodecTest.fail((String)"file not found exception");
        }
        catch (GPFormatException e) {
            MidiCodecTest.fail((String)"gp format exception");
        }
        catch (IOException e) {
            MidiCodecTest.fail((String)"ioexception");
        }
        catch (CodecFormatException e) {
            MidiCodecTest.fail((String)"codec format exception");
        }
        catch (InvalidMidiDataException e) {
            MidiCodecTest.fail((String)"invalid midi data exception");
        }
    }

    public void testAguaGPWithPlayer() throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        MidiSongDefinition sd = SongArchive.aguaSongDefinition();
        try {
            GPInputStream gpis = new GPInputStream(sd.getGpFileName());
            GPSong gpsong = (GPSong)gpis.readObject();
            gpis.close();
            Song song = GPAdaptor.makeSong(gpsong);
            MasterPlayer player = new MasterPlayer();
            player.setSoundPlayer(new MidiFiler(testFile.getMidiFileName()));
            Performance performance = player.arrange(song, null);
            MidiOutputStream mos = new MidiOutputStream(new FileOutputStream(testFile.getMidiFileName()));
            mos.write(performance);
            mos.close();
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), sd.getChannels(), sd.getEventRemap());
        }
        catch (FileNotFoundException e) {
            MidiCodecTest.fail((String)"file not found exception");
        }
        catch (GPFormatException e) {
            MidiCodecTest.fail((String)"gp format exception");
        }
        catch (IOException e) {
            MidiCodecTest.fail((String)"ioexception");
        }
        catch (CodecFormatException e) {
            MidiCodecTest.fail((String)"codec format exception");
        }
        catch (InvalidMidiDataException e) {
            MidiCodecTest.fail((String)"invalid midi data exception");
        }
    }

    public void testAguaGP() throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        MidiSongDefinition sd = SongArchive.aguaSongDefinition();
        try {
            GPInputStream gpis = new GPInputStream(sd.getGpFileName());
            GPSong gpsong = (GPSong)gpis.readObject();
            gpis.close();
            MidiOutputStream mos = new MidiOutputStream(new FileOutputStream(testFile.getMidiFileName()));
            mos.write(gpsong);
            mos.close();
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), sd.getChannels(), sd.getEventRemap());
        }
        catch (FileNotFoundException e) {
            MidiCodecTest.fail((String)"file not found exception");
        }
        catch (GPFormatException e) {
            MidiCodecTest.fail((String)"gp format exception");
        }
        catch (IOException e) {
            MidiCodecTest.fail((String)"ioexception");
        }
        catch (CodecFormatException e) {
            MidiCodecTest.fail((String)"codec format exception");
        }
        catch (InvalidMidiDataException e) {
            MidiCodecTest.fail((String)"invalid midi data exception");
        }
    }
}

