/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;

public class FreeColProgressBar
extends JPanel {
    private int min = 0;
    private int max = 100;
    private int value = 0;
    private int step = 0;
    private int iconWidth;
    private final int iconHeight;
    private GoodsType goodsType;
    private Image image;

    public FreeColProgressBar(GoodsType goodsType) {
        this(goodsType, 0, 100, 0, 0);
    }

    public FreeColProgressBar(GoodsType goodsType, int min, int max) {
        this(goodsType, min, max, 0, 0);
    }

    public FreeColProgressBar(GoodsType goodsType, int min, int max, int value, int step) {
        this.iconHeight = ImageLibrary.ICON_SIZE.height / 2;
        this.goodsType = null;
        this.goodsType = goodsType;
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.setBorder(Utility.PROGRESS_BORDER);
        if (goodsType != null) {
            this.image = ImageLibrary.getMiscImage("image.icon." + goodsType.getId(), new Dimension(-1, this.iconHeight));
            this.iconWidth = this.image.getWidth(this);
        }
        this.setPreferredSize(new Dimension(200, 20));
    }

    public void update(int value, int step) {
        this.update(this.min, this.max, value, step);
    }

    public void update(int min, int max, int value, int step) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.TINY));
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int height = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        if (this.image != null && this.iconWidth < 0) {
            this.iconWidth = this.image.getWidth(this);
        }
        if (this.isOpaque()) {
            ImageLibrary.drawTiledImage("image.background.FreeColProgressBar", g, this, this.getInsets());
        }
        int dvalue = 0;
        if (this.value >= this.max) {
            dvalue = width;
        } else if (this.max > 0) {
            dvalue = width * this.value / this.max;
        }
        if (dvalue > 0) {
            if (dvalue > width) {
                dvalue = width;
            }
            g2d.setColor(new Color(0, 0, 0, 70));
            g2d.fillRect(this.getInsets().left, this.getInsets().top, dvalue, height);
        }
        int dstep = 0;
        if (this.max > 0 && (dstep = width * this.step / this.max) > 0) {
            if (dstep + dvalue > width) {
                dstep = width - dvalue;
            }
            g2d.setColor(new Color(0, 0, 0, 40));
            g2d.fillRect(this.getInsets().left + dvalue, this.getInsets().top, dstep, height);
        }
        String stepSignal = this.step < 0 ? "-" : "+";
        String progressString = String.valueOf(this.value) + stepSignal + Math.abs(this.step) + "/" + this.max;
        String turnsString = Messages.message("notApplicable");
        if (this.max <= this.value) {
            turnsString = "0";
        } else if (this.step > 0) {
            int turns = (this.max - this.value) / this.step;
            if ((this.max - this.value) % this.step > 0) {
                ++turns;
            }
            turnsString = Integer.toString(turns);
        }
        progressString = progressString + " " + Messages.message(StringTemplate.template("freeColProgressBar.turnsToComplete").addName("%number%", turnsString));
        int stringWidth = g2d.getFontMetrics().stringWidth(progressString);
        int stringHeight = g2d.getFontMetrics().getAscent() + g2d.getFontMetrics().getDescent();
        int restWidth = this.getWidth() - stringWidth;
        if (this.goodsType != null) {
            g2d.drawImage(this.image, (restWidth -= this.iconWidth) / 2, (this.getHeight() - this.iconHeight) / 2, null);
        }
        g2d.setColor(Color.BLACK);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawString(progressString, restWidth / 2 + this.iconWidth, this.getHeight() / 2 + stringHeight / 4);
        g2d.dispose();
    }
}

