/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Operand;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;

public final class Limit
extends FreeColGameObjectType {
    private Operator operator;
    private Operand leftHandSide;
    private Operand rightHandSide;
    private static final String LEFT_HAND_SIDE_TAG = "left-hand-side";
    private static final String OPERATOR_TAG = "operator";
    private static final String RIGHT_HAND_SIDE_TAG = "right-hand-side";
    private static final String OLD_LEFT_HAND_SIDE_TAG = "leftHandSide";
    private static final String OLD_RIGHT_HAND_SIDE_TAG = "rightHandSide";

    public Limit(Specification specification) {
        super(specification);
    }

    public Limit(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public Limit(String id, Operand lhs, Operator op, Operand rhs) {
        this.setId(id);
        this.leftHandSide = lhs;
        this.rightHandSide = rhs;
        this.operator = op;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator newOperator) {
        this.operator = newOperator;
    }

    public Operand getLeftHandSide() {
        return this.leftHandSide;
    }

    public void setLeftHandSide(Operand newLeftHandSide) {
        this.leftHandSide = newLeftHandSide;
    }

    public Operand getRightHandSide() {
        return this.rightHandSide;
    }

    public void setRightHandSide(Operand newRightHandSide) {
        this.rightHandSide = newRightHandSide;
    }

    public boolean appliesTo(FreeColObject object) {
        return this.leftHandSide.appliesTo(object);
    }

    public boolean evaluate(Game game) {
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case GAME: {
                lhs = this.leftHandSide.getValue(game);
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case GAME: {
                rhs = this.rightHandSide.getValue(game);
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean evaluate(Player player) {
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case PLAYER: {
                lhs = this.leftHandSide.getValue(player);
                break;
            }
            case GAME: {
                lhs = this.leftHandSide.getValue(player.getGame());
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case PLAYER: {
                rhs = this.rightHandSide.getValue(player);
                break;
            }
            case GAME: {
                rhs = this.rightHandSide.getValue(player.getGame());
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean evaluate(Settlement settlement) {
        Specification spec = this.getSpecification();
        Integer lhs = null;
        switch (this.leftHandSide.getScopeLevel()) {
            case SETTLEMENT: {
                lhs = this.leftHandSide.getValue(settlement);
                break;
            }
            case PLAYER: {
                lhs = this.leftHandSide.getValue(settlement.getOwner());
                break;
            }
            case GAME: {
                lhs = this.leftHandSide.getValue(settlement.getGame());
                break;
            }
            default: {
                lhs = this.leftHandSide.getValue();
            }
        }
        Integer rhs = null;
        switch (this.rightHandSide.getScopeLevel()) {
            case SETTLEMENT: {
                rhs = this.rightHandSide.getValue(settlement);
                break;
            }
            case PLAYER: {
                rhs = this.rightHandSide.getValue(settlement.getOwner());
                break;
            }
            case GAME: {
                rhs = this.rightHandSide.getValue(settlement.getGame());
                break;
            }
            default: {
                rhs = this.rightHandSide.getValue();
            }
        }
        return this.evaluate(lhs, rhs);
    }

    public boolean hasOperandType(Operand.OperandType type) {
        return this.leftHandSide.getOperandType() == type || this.rightHandSide.getOperandType() == type;
    }

    private boolean evaluate(Integer lhs, Integer rhs) {
        if (lhs == null || rhs == null) {
            return true;
        }
        switch (this.operator) {
            case EQ: {
                return lhs == rhs;
            }
            case LT: {
                return lhs < rhs;
            }
            case GT: {
                return lhs > rhs;
            }
            case LE: {
                return lhs <= rhs;
            }
            case GE: {
                return lhs >= rhs;
            }
        }
        return false;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OPERATOR_TAG, this.operator);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.leftHandSide.toXML(xw, LEFT_HAND_SIDE_TAG);
        this.rightHandSide.toXML(xw, RIGHT_HAND_SIDE_TAG);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.operator = xr.getAttribute(OPERATOR_TAG, Operator.class, null);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (LEFT_HAND_SIDE_TAG.equals(tag) || OLD_LEFT_HAND_SIDE_TAG.equals(tag)) {
            this.leftHandSide = new Operand(xr);
        } else if (RIGHT_HAND_SIDE_TAG.equals(tag) || OLD_RIGHT_HAND_SIDE_TAG.equals(tag)) {
            this.rightHandSide = new Operand(xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.leftHandSide).append(" ").append((Object)this.operator).append(" ").append(this.rightHandSide);
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Limit.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "limit";
    }

    public static enum Operator {
        EQ,
        LT,
        GT,
        LE,
        GE;

    }
}

