/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExporterGEXF
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final String GEXF = "gexf";
    private static final String GEXF_NAMESPACE = "http://www.gexf.net/1.3";
    private static final String GEXF_NAMESPACE_LOCATION = "http://www.gexf.net/1.3 http://www.gexf.net/1.3/gexf.xsd";
    private static final String VIZ = "viz";
    private static final String VIZ_NAMESPACE = "http://www.gexf.net/1.3/viz";
    private static final String GEXF_VERSION = "version";
    private static final String GRAPH = "graph";
    private static final String GRAPH_MODE = "mode";
    private static final String GRAPH_DEFAULT_EDGETYPE = "defaultedgetype";
    private static final String GRAPH_START = "start";
    private static final String GRAPH_END = "end";
    private static final String GRAPH_TIMEFORMAT = "timeformat";
    private static final String GRAPH_TIMEREPRESENTATION = "timerepresentation";
    private static final String GRAPH_IDTYPE = "idtype";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPS = "timestamps";
    private static final String INTERVALS = "intervals";
    private static final String META = "meta";
    private static final String META_LASTMODIFIEDDATE = "lastmodifieddate";
    private static final String META_CREATOR = "creator";
    private static final String META_DESCRIPTION = "description";
    private static final String NODES = "nodes";
    private static final String NODE = "node";
    private static final String NODE_ID = "id";
    private static final String NODE_LABEL = "label";
    private static final String NODE_POSITION = "position";
    private static final String NODE_COLOR = "color";
    private static final String NODE_SIZE = "size";
    private static final String EDGES = "edges";
    private static final String EDGE = "edge";
    private static final String EDGE_ID = "id";
    private static final String EDGE_SOURCE = "source";
    private static final String EDGE_TARGET = "target";
    private static final String EDGE_LABEL = "label";
    private static final String EDGE_TYPE = "type";
    private static final String EDGE_WEIGHT = "weight";
    private static final String EDGE_COLOR = "color";
    private static final String EDGE_KIND = "kind";
    private static final String START = "start";
    private static final String END = "end";
    private static final String SPELLS = "spells";
    private static final String SPELL = "spell";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTES_CLASS = "class";
    private static final String ATTRIBUTES_MODE = "mode";
    private static final String ATTVALUES = "attvalues";
    private static final String ATTVALUE = "attvalue";
    private static final String ATTVALUE_FOR = "for";
    private static final String ATTVALUE_VALUE = "value";
    private boolean cancel = false;
    private ProgressTicket progress;
    private Workspace workspace;
    private boolean exportVisible;
    private Writer writer;
    private boolean normalize = false;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportSize = true;
    private boolean exportAttributes = true;
    private boolean exportDynamic = true;
    private float minSize;
    private float maxSize;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        Progress.start((ProgressTicket)this.progress);
        graph.readLock();
        this.exportDynamic = this.exportDynamic && graphModel.isDynamic();
        this.calculateMinMax(graph);
        Progress.switchToDeterminate((ProgressTicket)this.progress, (int)(graph.getNodeCount() + graph.getEdgeCount()));
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
            XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(this.writer);
            xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.setPrefix("", GEXF_NAMESPACE);
            xmlWriter.writeStartElement(GEXF_NAMESPACE, GEXF);
            xmlWriter.writeNamespace("", GEXF_NAMESPACE);
            xmlWriter.writeAttribute(GEXF_VERSION, "1.3");
            if (this.exportColors || this.exportPosition || this.exportSize) {
                xmlWriter.writeNamespace(VIZ, VIZ_NAMESPACE);
            }
            xmlWriter.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xmlWriter.writeAttribute("xsi:schemaLocation", GEXF_NAMESPACE_LOCATION);
            this.writeMeta(xmlWriter);
            this.writeGraph(xmlWriter, graph);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.close();
        }
        catch (Exception e) {
            Logger.getLogger(ExporterGEXF.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progress);
        }
        return !this.cancel;
    }

    private void writeGraph(XMLStreamWriter xmlWriter, Graph graph) throws Exception {
        Configuration graphConfig;
        xmlWriter.writeStartElement(GRAPH);
        if (!graph.isMixed()) {
            xmlWriter.writeAttribute(GRAPH_DEFAULT_EDGETYPE, graph.isDirected() ? "directed" : "undirected");
        }
        if ((graphConfig = graph.getModel().getConfiguration()).getEdgeIdType().equals(Integer.class) && graphConfig.getNodeIdType().equals(Integer.class)) {
            xmlWriter.writeAttribute(GRAPH_IDTYPE, "integer");
        } else if (graphConfig.getEdgeIdType().equals(Long.class) && graphConfig.getNodeIdType().equals(Long.class)) {
            xmlWriter.writeAttribute(GRAPH_IDTYPE, "long");
        }
        if (this.exportDynamic) {
            TimeFormat timeFormat = graph.getModel().getTimeFormat();
            xmlWriter.writeAttribute(GRAPH_TIMEFORMAT, timeFormat.toString().toLowerCase());
            TimeRepresentation timeRepresentation = graphConfig.getTimeRepresentation();
            xmlWriter.writeAttribute(GRAPH_TIMEREPRESENTATION, timeRepresentation.toString().toLowerCase());
        }
        xmlWriter.writeAttribute("mode", this.exportDynamic ? "dynamic" : "static");
        this.writeAttributes(xmlWriter, graph.getModel().getNodeTable());
        this.writeAttributes(xmlWriter, graph.getModel().getEdgeTable());
        this.writeNodes(xmlWriter, graph);
        this.writeEdges(xmlWriter, graph);
        xmlWriter.writeEndElement();
    }

    private void writeMeta(XMLStreamWriter xmlWriter) throws Exception {
        xmlWriter.writeStartElement(META);
        xmlWriter.writeAttribute(META_LASTMODIFIEDDATE, this.getDateTime());
        xmlWriter.writeStartElement(META_CREATOR);
        xmlWriter.writeCharacters("Gephi 0.9");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(META_DESCRIPTION);
        xmlWriter.writeCharacters("");
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void writeAttributes(XMLStreamWriter xmlWriter, Table table) throws Exception {
        ArrayList<Column> staticCols = new ArrayList<Column>();
        ArrayList<Column> dynamicCols = new ArrayList<Column>();
        String attClass = table.getElementClass().equals(Node.class) ? NODE : EDGE;
        for (Column col : table) {
            if (this.exportAttributes && !col.isProperty()) {
                if (this.exportDynamic && col.isDynamic()) {
                    dynamicCols.add(col);
                    continue;
                }
                staticCols.add(col);
                continue;
            }
            if (!this.exportDynamic || !AttributeUtils.isEdgeColumn((Column)col) || !col.isDynamic() || !col.getId().equals(EDGE_WEIGHT)) continue;
            dynamicCols.add(col);
        }
        if (!staticCols.isEmpty()) {
            this.writeAttributes(xmlWriter, staticCols.toArray(new Column[0]), "static", attClass);
        }
        if (!dynamicCols.isEmpty()) {
            this.writeAttributes(xmlWriter, dynamicCols.toArray(new Column[0]), "dynamic", attClass);
        }
    }

    private void writeAttributes(XMLStreamWriter xmlWriter, Column[] cols, String mode, String attClass) throws Exception {
        xmlWriter.writeStartElement(ATTRIBUTES);
        xmlWriter.writeAttribute(ATTRIBUTES_CLASS, attClass);
        xmlWriter.writeAttribute("mode", mode);
        for (Column col : cols) {
            xmlWriter.writeStartElement(ATTRIBUTE);
            xmlWriter.writeAttribute("id", col.getId());
            xmlWriter.writeAttribute(ATTRIBUTE_TITLE, col.getTitle());
            if (col.isArray()) {
                xmlWriter.writeAttribute("type", "list" + col.getTypeClass().getComponentType().getSimpleName().toLowerCase());
            } else if (col.isDynamic()) {
                xmlWriter.writeAttribute("type", AttributeUtils.getStaticType((Class)col.getTypeClass()).getSimpleName().toLowerCase());
            } else {
                xmlWriter.writeAttribute("type", col.getTypeClass().getSimpleName().toLowerCase());
            }
            if (col.getDefaultValue() != null) {
                xmlWriter.writeStartElement(ATTRIBUTE_DEFAULT);
                String valString = col.isArray() ? AttributeUtils.printArray((Object)col.getDefaultValue()) : col.getDefaultValue().toString();
                xmlWriter.writeCharacters(valString);
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    private void writeNodes(XMLStreamWriter xmlWriter, Graph graph) throws Exception {
        if (this.cancel) {
            return;
        }
        xmlWriter.writeStartElement(NODES);
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            xmlWriter.writeStartElement(NODE);
            String id = node.getId().toString();
            xmlWriter.writeAttribute("id", id);
            if (node.getLabel() != null && !node.getLabel().isEmpty()) {
                xmlWriter.writeAttribute("label", node.getLabel());
            }
            if (this.exportDynamic) {
                this.writeTimeSet(xmlWriter, graph, (Element)node);
            }
            this.writeAttValues(xmlWriter, graph, (Element)node);
            if (this.exportSize) {
                this.writeNodeSize(xmlWriter, node);
            }
            if (this.exportPosition) {
                this.writeNodePosition(xmlWriter, node);
            }
            if (this.exportColors) {
                this.writeNodeColor(xmlWriter, node);
            }
            xmlWriter.writeEndElement();
            Progress.progress((ProgressTicket)this.progress);
            if (!this.cancel) continue;
            nodeIterable.doBreak();
            break;
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttValue(XMLStreamWriter xmlWriter, Graph graph, Column column, Element element) throws Exception {
        if (!column.isDynamic()) {
            Object val = element.getAttribute(column);
            if (val != null) {
                xmlWriter.writeStartElement(ATTVALUE);
                xmlWriter.writeAttribute(ATTVALUE_FOR, column.getId());
                String valString = column.isArray() ? AttributeUtils.printArray((Object)val) : val.toString();
                xmlWriter.writeAttribute(ATTVALUE_VALUE, valString);
                xmlWriter.writeEndElement();
            }
        } else if (this.exportDynamic) {
            Interval visibleInterval = graph.getView().getTimeInterval();
            TimeRepresentation timeRepresentation = graph.getModel().getConfiguration().getTimeRepresentation();
            TimeFormat timeFormat = graph.getModel().getTimeFormat();
            DateTimeZone timeZone = graph.getModel().getTimeZone();
            if (timeRepresentation.equals((Object)TimeRepresentation.INTERVAL)) {
                IntervalMap timeMap = (IntervalMap)element.getAttribute(column);
                if (timeMap != null) {
                    for (Interval interval : timeMap.toKeysArray()) {
                        Object defaultValue;
                        Object value;
                        if (this.exportVisible && interval.compareTo(visibleInterval) != 0 || (value = timeMap.get(interval, defaultValue = null)) == null) continue;
                        xmlWriter.writeStartElement(ATTVALUE);
                        xmlWriter.writeAttribute(ATTVALUE_FOR, column.getId());
                        xmlWriter.writeAttribute(ATTVALUE_VALUE, value.toString());
                        if (!Double.isInfinite(interval.getLow())) {
                            String intervalLow = AttributeUtils.printTimestampInFormat((double)interval.getLow(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                            xmlWriter.writeAttribute("start", intervalLow);
                        }
                        if (!Double.isInfinite(interval.getHigh())) {
                            String intervalHigh = AttributeUtils.printTimestampInFormat((double)interval.getHigh(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                            xmlWriter.writeAttribute("end", intervalHigh);
                        }
                        xmlWriter.writeEndElement();
                    }
                }
            } else {
                TimestampMap timeMap = (TimestampMap)element.getAttribute(column);
                if (timeMap != null) {
                    for (Double timestamp : timeMap.toKeysArray()) {
                        Object defaultValue;
                        Object value;
                        if (this.exportVisible && visibleInterval.compareTo(timestamp) != 0 || (value = timeMap.get(timestamp, defaultValue = null)) == null) continue;
                        xmlWriter.writeStartElement(ATTVALUE);
                        xmlWriter.writeAttribute(ATTVALUE_FOR, column.getId());
                        xmlWriter.writeAttribute(ATTVALUE_VALUE, value.toString());
                        xmlWriter.writeAttribute(TIMESTAMP, AttributeUtils.printTimestampInFormat((double)timestamp, (TimeFormat)timeFormat, (DateTimeZone)timeZone));
                        xmlWriter.writeEndElement();
                    }
                }
            }
        } else {
            Object value = element.getAttribute(column, graph.getView());
            if (value != null) {
                xmlWriter.writeStartElement(ATTVALUE);
                xmlWriter.writeAttribute(ATTVALUE_FOR, column.getId());
                xmlWriter.writeAttribute(ATTVALUE_VALUE, value.toString());
                xmlWriter.writeEndElement();
            }
        }
    }

    private void writeAttValues(XMLStreamWriter xmlWriter, Graph graph, Element element) throws Exception {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : element.getAttributeColumns()) {
            if ((!this.exportAttributes || column.isProperty()) && (!(element instanceof Edge) || !((Edge)element).hasDynamicWeight() || !column.getId().equals(EDGE_WEIGHT))) continue;
            columns.add(column);
        }
        if (!columns.isEmpty()) {
            xmlWriter.writeStartElement(ATTVALUES);
            for (Column column : columns) {
                this.writeAttValue(xmlWriter, graph, column, element);
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeNodePosition(XMLStreamWriter xmlWriter, Node node) throws Exception {
        float x = node.x();
        if (this.normalize && (double)x != 0.0) {
            x = (x - this.minX) / (this.maxX - this.minX);
        }
        float y = node.y();
        if (this.normalize && (double)y != 0.0) {
            y = (y - this.minY) / (this.maxY - this.minY);
        }
        float z = node.z();
        if (this.normalize && (double)z != 0.0) {
            z = (z - this.minZ) / (this.maxZ - this.minZ);
        }
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            xmlWriter.writeStartElement(VIZ, NODE_POSITION, VIZ_NAMESPACE);
            xmlWriter.writeAttribute("x", "" + x);
            xmlWriter.writeAttribute("y", "" + y);
            if (this.minZ != 0.0f || this.maxZ != 0.0f) {
                xmlWriter.writeAttribute("z", "" + z);
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeNodeSize(XMLStreamWriter xmlWriter, Node node) throws Exception {
        xmlWriter.writeStartElement(VIZ, NODE_SIZE, VIZ_NAMESPACE);
        float size = node.size();
        if (this.normalize) {
            size = (size - this.minSize) / (this.maxSize - this.minSize);
        }
        xmlWriter.writeAttribute(ATTVALUE_VALUE, "" + size);
        xmlWriter.writeEndElement();
    }

    private void writeNodeColor(XMLStreamWriter xmlWriter, Node node) throws Exception {
        int r = Math.round(node.r() * 255.0f);
        int g = Math.round(node.g() * 255.0f);
        int b = Math.round(node.b() * 255.0f);
        if (r != 0 || g != 0 || b != 0) {
            xmlWriter.writeStartElement(VIZ, "color", VIZ_NAMESPACE);
            xmlWriter.writeAttribute("r", "" + r);
            xmlWriter.writeAttribute("g", "" + g);
            xmlWriter.writeAttribute("b", "" + b);
            if (node.alpha() != 1.0f) {
                xmlWriter.writeAttribute("a", "" + node.alpha());
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeTimeSet(XMLStreamWriter xmlWriter, Graph graph, Element element) throws Exception {
        Interval visibleInterval = graph.getView().getTimeInterval();
        TimeRepresentation timeRepresentation = graph.getModel().getConfiguration().getTimeRepresentation();
        TimeSet timeSet = (TimeSet)element.getAttribute("timeset");
        TimeFormat timeFormat = graph.getModel().getTimeFormat();
        DateTimeZone timeZone = graph.getModel().getTimeZone();
        if (timeSet != null && !timeSet.isEmpty()) {
            if (timeSet.size() > 1) {
                xmlWriter.writeStartElement(SPELLS);
                if (timeRepresentation.equals((Object)TimeRepresentation.INTERVAL)) {
                    for (Interval interval : ((IntervalSet)timeSet).toArray()) {
                        if (this.exportVisible && interval.compareTo(visibleInterval) != 0) continue;
                        xmlWriter.writeStartElement(SPELL);
                        if (!Double.isInfinite(interval.getLow())) {
                            String intervalLow = AttributeUtils.printTimestampInFormat((double)interval.getLow(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                            xmlWriter.writeAttribute("start", intervalLow);
                        }
                        if (!Double.isInfinite(interval.getHigh())) {
                            String intervalHigh = AttributeUtils.printTimestampInFormat((double)interval.getHigh(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                            xmlWriter.writeAttribute("end", intervalHigh);
                        }
                        xmlWriter.writeEndElement();
                    }
                } else if (timeRepresentation.equals((Object)TimeRepresentation.TIMESTAMP)) {
                    for (Double timestamp : ((TimestampSet)timeSet).toArray()) {
                        if (this.exportVisible && visibleInterval.compareTo(timestamp) != 0) continue;
                        xmlWriter.writeStartElement(SPELL);
                        xmlWriter.writeAttribute(TIMESTAMP, AttributeUtils.printTimestampInFormat((double)timestamp, (TimeFormat)timeFormat, (DateTimeZone)timeZone));
                        xmlWriter.writeEndElement();
                    }
                }
                xmlWriter.writeEndElement();
            } else if (timeRepresentation.equals((Object)TimeRepresentation.INTERVAL)) {
                Interval interval = ((IntervalSet)timeSet).toArray()[0];
                if (!Double.isInfinite(interval.getLow())) {
                    String intervalLow = AttributeUtils.printTimestampInFormat((double)interval.getLow(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                    xmlWriter.writeAttribute("start", intervalLow);
                }
                if (!Double.isInfinite(interval.getHigh())) {
                    String intervalHigh = AttributeUtils.printTimestampInFormat((double)interval.getHigh(), (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                    xmlWriter.writeAttribute("end", intervalHigh);
                }
            } else if (timeRepresentation.equals((Object)TimeRepresentation.TIMESTAMP)) {
                Double timestamp = ((TimestampSet)timeSet).toArray()[0];
                xmlWriter.writeAttribute(TIMESTAMP, AttributeUtils.printTimestampInFormat((double)timestamp, (TimeFormat)timeFormat, (DateTimeZone)timeZone));
            }
        }
    }

    private void writeEdges(XMLStreamWriter xmlWriter, Graph graph) throws Exception {
        if (this.cancel) {
            return;
        }
        xmlWriter.writeStartElement(EDGES);
        EdgeIterable edgeIterable = graph.getEdges();
        for (Edge edge : edgeIterable) {
            double weight;
            String label;
            xmlWriter.writeStartElement(EDGE);
            xmlWriter.writeAttribute("id", edge.getId().toString());
            xmlWriter.writeAttribute(EDGE_SOURCE, edge.getSource().getId().toString());
            xmlWriter.writeAttribute(EDGE_TARGET, edge.getTarget().getId().toString());
            if (graph.isMixed()) {
                if (edge.isDirected()) {
                    xmlWriter.writeAttribute("type", "directed");
                } else {
                    xmlWriter.writeAttribute("type", "undirected");
                }
            }
            if ((label = edge.getLabel()) != null && !label.isEmpty()) {
                xmlWriter.writeAttribute("label", label);
            }
            if (edge.getType() != 0) {
                xmlWriter.writeAttribute(EDGE_KIND, edge.getTypeLabel().toString());
            }
            if (!edge.hasDynamicWeight() && (weight = edge.getWeight()) != 1.0) {
                xmlWriter.writeAttribute(EDGE_WEIGHT, String.valueOf(weight));
            }
            if (this.exportDynamic) {
                this.writeTimeSet(xmlWriter, graph, (Element)edge);
            }
            if (this.exportColors) {
                this.writeEdgeColor(xmlWriter, edge);
            }
            this.writeAttValues(xmlWriter, graph, (Element)edge);
            xmlWriter.writeEndElement();
            Progress.progress((ProgressTicket)this.progress);
            if (!this.cancel) continue;
            edgeIterable.doBreak();
            break;
        }
        xmlWriter.writeEndElement();
    }

    private void writeEdgeColor(XMLStreamWriter xmlWriter, Edge edge) throws Exception {
        if (edge.alpha() != 0.0f) {
            int r = Math.round(edge.r() * 255.0f);
            int g = Math.round(edge.g() * 255.0f);
            int b = Math.round(edge.b() * 255.0f);
            if (r != 0 || g != 0 || b != 0) {
                xmlWriter.writeStartElement(VIZ, "color", VIZ_NAMESPACE);
                xmlWriter.writeAttribute("r", "" + r);
                xmlWriter.writeAttribute("g", "" + g);
                xmlWriter.writeAttribute("b", "" + b);
                if (edge.alpha() != 1.0f) {
                    xmlWriter.writeAttribute("a", "" + edge.alpha());
                }
                xmlWriter.writeEndElement();
            }
        }
    }

    private void calculateMinMax(Graph graph) {
        this.minX = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.minSize = Float.POSITIVE_INFINITY;
        this.maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            this.minX = Math.min(this.minX, node.x());
            this.maxX = Math.max(this.maxX, node.x());
            this.minY = Math.min(this.minY, node.y());
            this.maxY = Math.max(this.maxY, node.y());
            this.minZ = Math.min(this.minZ, node.z());
            this.maxZ = Math.max(this.maxZ, node.z());
            this.minSize = Math.min(this.minSize, node.size());
            this.maxSize = Math.max(this.maxSize, node.size());
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGEXF_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".gexf", NbBundle.getMessage(this.getClass(), (String)"fileType_GEXF_Name"));
        return new FileType[]{ft};
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setExportDynamic(boolean exportDynamic) {
        this.exportDynamic = exportDynamic;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public boolean isExportDynamic() {
        return this.exportDynamic;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

