/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import com.google.common.collect.Lists;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.platform.base.ToolChain;
import org.gradle.util.GUtil;

@Incubating
public class SwiftExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ProviderFactory providers = project.getProviders();
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        SwiftApplication application = (SwiftApplication)project.getExtensions().create(SwiftApplication.class, "executable", DefaultSwiftApplication.class, new Object[]{"main", project.getObjects(), this.fileOperations, providers, configurations});
        project.getComponents().add((Object)application);
        project.getComponents().add((Object)application.getDebugExecutable());
        project.getComponents().add((Object)application.getReleaseExecutable());
        final PropertyState<String> module = application.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        SwiftCompile compile = (SwiftCompile)tasks.getByName("compileDebugSwift");
        compile.setCompilerArgs(Lists.newArrayList((Object[])new String[]{"-g", "-enable-testing"}));
        LinkExecutable link = (LinkExecutable)tasks.getByName("linkDebug");
        final InstallExecutable install = (InstallExecutable)tasks.create("installMain", InstallExecutable.class);
        install.setPlatform(link.getTargetPlatform());
        install.setToolChain((ToolChain)link.getToolChain());
        install.setDestinationDir(buildDirectory.dir(providers.provider((Callable)new Callable<CharSequence>(){

            @Override
            public String call() {
                return "install/" + (String)module.get();
            }
        })));
        install.setExecutable((Provider)link.getBinaryFile());
        install.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return install.getExecutable().exists();
            }
        });
        install.lib((Object)application.getDebugExecutable().getRuntimeLibraries());
        tasks.getByName("assemble").dependsOn(new Object[]{install});
    }
}

