/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.Factory;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SingleMessageLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationLogger.class);
    private static final Set<String> FEATURES = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    public static final String INCUBATION_MESSAGE = "%s is an incubating feature.";
    private static final Lock LOCK = new ReentrantLock();
    private static LoggingDeprecatedFeatureHandler handler = new LoggingDeprecatedFeatureHandler();
    private static String deprecationMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeprecationMessage() {
        LOCK.lock();
        try {
            if (deprecationMessage == null) {
                String messageBase = "has been deprecated and is scheduled to be removed in";
                GradleVersion currentVersion = GradleVersion.current();
                String when = String.format("Gradle %s", currentVersion.getNextMajor().getVersion());
                deprecationMessage = String.format("%s %s", messageBase, when);
            }
            String string = deprecationMessage;
            return string;
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        FEATURES.clear();
        LOCK.lock();
        try {
            handler = new LoggingDeprecatedFeatureHandler();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useLocationReporter(UsageLocationReporter reporter) {
        LOCK.lock();
        try {
            handler.setLocationReporter(reporter);
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin %s. Please use the %s plugin instead.", pluginName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfPluginReplacedWithExternalOne(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin %s. Consider using the %s plugin instead.", pluginName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfToolReplacedWithExternalOne(String toolName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s %s. Consider using %s instead.", toolName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedTask(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task %s. Please use the %s task instead.", taskName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task type %s. Please use the %s instead.", taskName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s. Please use the %s method instead.", methodName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property %s. Please use the %s property instead.", propertyName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s.", methodName, SingleMessageLogger.getDeprecationMessage()));
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method %s. %s", methodName, SingleMessageLogger.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property %s. %s", propertyName, SingleMessageLogger.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfDiscontinuedApi(String api, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s %s. %s", api, SingleMessageLogger.getDeprecationMessage(), advice));
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s named parameter %s. Please use the %s named parameter instead.", parameterName, SingleMessageLogger.getDeprecationMessage(), replacement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nagUserWith(String message) {
        if (SingleMessageLogger.isEnabled()) {
            LOCK.lock();
            try {
                handler.deprecatedFeatureUsed(new DeprecatedFeatureUsage(message, SingleMessageLogger.class));
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static void nagUserOfDeprecated(String thing) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s %s", thing, SingleMessageLogger.getDeprecationMessage()));
        }
    }

    public static void nagUserOfDeprecated(String thing, String explanation) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s %s. %s.", thing, SingleMessageLogger.getDeprecationMessage(), explanation));
        }
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserOfDeprecated(String.format("%s. This behaviour", behaviour));
        }
    }

    public static void nagUserOfDeprecatedThing(String thing, String explanation) {
        if (SingleMessageLogger.isEnabled()) {
            if (StringUtils.isEmpty((String)explanation)) {
                SingleMessageLogger.nagUserWith(String.format("%s. This %s.", thing, SingleMessageLogger.getDeprecationMessage()));
            } else {
                SingleMessageLogger.nagUserWith(String.format("%s. This %s. %s.", thing, SingleMessageLogger.getDeprecationMessage(), explanation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void incubatingFeatureUsed(String incubatingFeature) {
        SingleMessageLogger.incubatingFeatureUsed(incubatingFeature, null);
    }

    public static void incubatingFeatureUsed(String incubatingFeature, String additionalWarning) {
        if (FEATURES.add(incubatingFeature)) {
            String message = String.format(INCUBATION_MESSAGE, incubatingFeature);
            if (additionalWarning != null) {
                message = message + "\n" + additionalWarning;
            }
            LOGGER.warn(message);
        }
    }
}

