/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.model.DefaultObjectFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.DirectInstantiator;

public class JavaLibrary
implements SoftwareComponentInternal {
    private static final ObjectFactory DEPRECATED_OBJECT_FACTORY = new DefaultObjectFactory(DirectInstantiator.INSTANCE, NamedObjectInstantiator.INSTANCE);
    private final LinkedHashSet<PublishArtifact> artifacts = new LinkedHashSet();
    private final UsageContext runtimeUsage;
    private final UsageContext compileUsage;
    private final ConfigurationContainer configurations;

    public JavaLibrary(ObjectFactory objectFactory, ConfigurationContainer configurations, PublishArtifact ... artifacts) {
        Collections.addAll(this.artifacts, artifacts);
        this.configurations = configurations;
        this.runtimeUsage = new RuntimeUsageContext((Usage)objectFactory.named(Usage.class, "java-runtime"));
        this.compileUsage = new CompileUsageContext((Usage)objectFactory.named(Usage.class, "java-api"));
    }

    @Deprecated
    public JavaLibrary(PublishArtifact jarArtifact, DependencySet runtimeDependencies) {
        this.artifacts.add(jarArtifact);
        this.runtimeUsage = new BackwardsCompatibilityUsageContext((Usage)DEPRECATED_OBJECT_FACTORY.named(Usage.class, "java-runtime"), runtimeDependencies);
        this.compileUsage = new BackwardsCompatibilityUsageContext((Usage)DEPRECATED_OBJECT_FACTORY.named(Usage.class, "java-api"), runtimeDependencies);
        this.configurations = null;
    }

    public String getName() {
        return "java";
    }

    public Set<UsageContext> getUsages() {
        return ImmutableSet.of((Object)this.runtimeUsage, (Object)this.compileUsage);
    }

    private class BackwardsCompatibilityUsageContext
    implements UsageContext {
        private final Usage usage;
        private final DependencySet runtimeDependencies;

        private BackwardsCompatibilityUsageContext(Usage usage, DependencySet runtimeDependencies) {
            this.usage = usage;
            this.runtimeDependencies = runtimeDependencies;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<PublishArtifact> getArtifacts() {
            return JavaLibrary.this.artifacts;
        }

        public Set<ModuleDependency> getDependencies() {
            return this.runtimeDependencies.withType(ModuleDependency.class);
        }
    }

    private class CompileUsageContext
    implements UsageContext {
        private final Usage usage;
        private DependencySet dependencies;

        public CompileUsageContext(Usage usage) {
            this.usage = usage;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<PublishArtifact> getArtifacts() {
            return JavaLibrary.this.artifacts;
        }

        public Set<ModuleDependency> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = ((Configuration)JavaLibrary.this.configurations.findByName("apiElements")).getAllDependencies();
            }
            return this.dependencies.withType(ModuleDependency.class);
        }
    }

    private class RuntimeUsageContext
    implements UsageContext {
        private final Usage usage;
        private DependencySet dependencies;

        public RuntimeUsageContext(Usage usage) {
            this.usage = usage;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<PublishArtifact> getArtifacts() {
            return JavaLibrary.this.artifacts;
        }

        public Set<ModuleDependency> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = JavaLibrary.this.configurations.getByName("runtimeElements").getAllDependencies();
            }
            return this.dependencies.withType(ModuleDependency.class);
        }
    }
}

