/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.IsConstantExpressionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final SimpleSmartExtensionPoint<PsiElementFinder> myElementFinders;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project, PsiManager psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker2 = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                @Override
                public void modificationCountChanged() {
                    JavaPsiFacadeImpl.this.myClassCache.clear();
                    long now = modificationTracker2.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache.clear();
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
        this.myElementFinders = new SimpleSmartExtensionPoint<PsiElementFinder>(Collections.emptyList()){

            @Override
            @NotNull
            protected ExtensionPoint<PsiElementFinder> getExtensionPoint() {
                ExtensionPoint<PsiElementFinder> extensionPoint = Extensions.getArea(JavaPsiFacadeImpl.this.myProject).getExtensionPoint(PsiElementFinder.EP_NAME);
                if (extensionPoint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl$2", "getExtensionPoint"));
                }
                return extensionPoint;
            }
        };
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        PsiClass result2;
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        Map<String, PsiClass> map2 = (ConcurrentMap)this.myClassCache.get(scope);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentWeakValueMap();
            map2 = ConcurrencyUtil.cacheOrGet(this.myClassCache, scope, map2);
        }
        if ((result2 = (PsiClass)map2.get(qualifiedName2)) == null && (result2 = this.doFindClass(qualifiedName2, scope)) != null) {
            map2.put(qualifiedName2, result2);
        }
        return result2;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "doFindClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "doFindClass"));
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName2, scope);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass2 = finder.findClass(qualifiedName2, scope);
            if (aClass2 == null || classesFilter != null && !classesFilter.value(aClass2)) continue;
            return aClass2;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName(qualifiedName2);
        PsiPackage pkg = this.findPackage(packageName);
        String className2 = StringUtil.getShortName(qualifiedName2);
        if (pkg == null && packageName.length() < qualifiedName2.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className2, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className2, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] psiClassArray = this.findClassesInDumbMode(qualifiedName2, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
            }
            return psiClassArray;
        }
        List<PsiElementFinder> finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName2, scope);
            if (finderClasses.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result2);
        }
        PsiClass[] psiClassArray = result2 == null || result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        return psiClassArray;
    }

    private static Condition<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull List<PsiElementFinder> finders) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getFilterFromFinders"));
        }
        if (finders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finders", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getFilterFromFinders"));
        }
        Condition<PsiClass> filter2 = null;
        for (PsiElementFinder finder : finders) {
            Condition<PsiClass> finderFilter = finder.getClassesFilter(scope);
            if (finderFilter == null) continue;
            filter2 = filter2 == null ? finderFilter : Conditions.and(filter2, finderFilter);
        }
        return filter2;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    private List<PsiElementFinder> finders() {
        return this.myElementFinders.getExtensions();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getConstantEvaluationHelper"));
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "findPackage"));
        }
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName2);
        if (aPackage != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName2);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName2, aPackage);
        }
        return null;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List<PsiElementFinder> list2 = DumbService.getInstance(this.getProject()).filterByDumbAwareness(this.finders());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "filteredFinders"));
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getParserFacade"));
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getResolveHelper"));
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getNameHelper"));
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        THashSet<String> result2 = new THashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result2.addAll(finder.getClassNames(psiPackage, scope));
        }
        THashSet<String> tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        return tHashSet;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes2 = finder.getClasses(psiPackage, scope);
            if (classes2.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(classes2.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes2, result2);
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Condition<PsiClass> classesFilter, @NotNull PsiClass[] classes2, @NotNull List<PsiClass> result2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "filterClassesAndAppend"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "filterClassesAndAppend"));
        }
        for (PsiClass psiClass : classes2) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.value(psiClass)) continue;
            result2.add(psiClass);
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        Condition<PsiFile> filter2 = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition<PsiFile> finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            if (filter2 == null) {
                filter2 = finderFilter;
                continue;
            }
            filter2 = Conditions.and(filter2, finderFilter);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (filter2 != null && !filter2.value(file)) continue;
                result2.add(file);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            Collections.addAll(result2, finder.getPackageFiles(psiPackage, scope));
        }
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        LinkedHashMap<String, PsiPackage> result2 = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages2;
            for (PsiPackage aPackage : packages2 = finder.getSubPackages(psiPackage, scope)) {
                if (result2.get(aPackage.getName()) != null) continue;
                result2.put(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result2.values().toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "isPartOfPackagePrefix"));
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal(file1, file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getProject"));
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "isConstantExpression"));
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression2.accept(visitor2);
        return visitor2.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance(this.myProject);
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl", "getElementFactory"));
        }
        return psiElementFactory;
    }
}

