/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.Cast;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.JavaForkOptions;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

@Incubating
public class JacocoPluginExtension {
    public static final String TASK_EXTENSION_NAME = "jacoco";
    private static final Logger LOGGER = Logging.getLogger(JacocoPluginExtension.class);
    protected final Project project;
    private final JacocoAgentJar agent;
    private String toolVersion;
    private final PropertyState<File> reportsDir;

    public JacocoPluginExtension(Project project, JacocoAgentJar agent) {
        this.project = project;
        this.agent = agent;
        this.reportsDir = project.property(File.class);
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public File getReportsDir() {
        return (File)this.reportsDir.get();
    }

    public void setReportsDir(Provider<File> reportsDir) {
        this.reportsDir.set(reportsDir);
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir.set((Object)reportsDir);
    }

    public <T extends Task & JavaForkOptions> void applyTo(final T task) {
        final String taskName = task.getName();
        LOGGER.debug("Applying Jacoco to " + taskName);
        final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().create(TASK_EXTENSION_NAME, JacocoTaskExtension.class, new Object[]{this.project, this.agent, task});
        extension.setDestinationFile((Provider<File>)this.project.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return JacocoPluginExtension.this.project.file((Object)(String.valueOf(JacocoPluginExtension.this.project.getBuildDir()) + "/jacoco/" + taskName + ".exec"));
            }
        }));
        task.getInputs().property("jacoco.jvmArg", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return extension.isEnabled() ? extension.getAsJvmArg() : null;
            }
        });
        task.getOutputs().file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.isEnabled() ? extension.getDestinationFile() : null;
            }
        }).optional().withPropertyName("jacoco.destinationFile");
        task.getOutputs().dir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.isEnabled() ? extension.getClassDumpDir() : null;
            }
        }).optional().withPropertyName("jacoco.classDumpDir");
        task.getOutputs().doNotCacheIf("JaCoCo configured to not produce its output as a file", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.getOutput() != JacocoTaskExtension.Output.FILE;
            }
        });
        task.getOutputs().doNotCacheIf("JaCoCo agent configured with `append = true`", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.isAppend();
            }
        });
        TaskInternal taskInternal = (TaskInternal)task;
        taskInternal.prependParallelSafeAction((Action)new Action<Task>(){

            public void execute(Task input) {
                if (extension.isEnabled()) {
                    ((JavaForkOptions)task).jvmArgs(new Object[]{extension.getAsJvmArg()});
                }
            }
        });
    }

    public <T extends Task & JavaForkOptions> void applyTo(TaskCollection tasks) {
        tasks.withType(JavaForkOptions.class, (Action)new Action<JavaForkOptions>(){

            public void execute(JavaForkOptions task) {
                JacocoPluginExtension.this.applyTo((Task)Cast.uncheckedCast((Object)task));
            }
        });
    }
}

