/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Map;
import javajs.img.DCT;
import javajs.img.Huffman;
import javajs.img.ImageEncoder;
import javajs.img.JpegObj;

public class JpgEncoder
extends ImageEncoder {
    private static final int CONTINUE_MAX = 65500;
    private static final int CONTINUE_MAX_BUFFER = 65510;
    private JpegObj jpegObj;
    private Huffman huf;
    private DCT dct;
    protected int defaultQuality = 100;
    private String applicationTag;
    private static byte[] eoi = new byte[]{-1, -39};
    private static byte[] jfif;
    private static byte[] soi;

    static {
        byte[] byArray = new byte[18];
        byArray[0] = -1;
        byArray[1] = -32;
        byArray[3] = 16;
        byArray[4] = 74;
        byArray[5] = 70;
        byArray[6] = 73;
        byArray[7] = 70;
        byArray[9] = 1;
        byArray[13] = 1;
        byArray[15] = 1;
        jfif = byArray;
        soi = new byte[]{-1, -40};
    }

    @Override
    protected void setParams(Map<String, Object> params) {
        if (this.quality <= 0) {
            this.quality = params.containsKey("qualityJPG") ? (Integer)params.get("qualityJPG") : this.defaultQuality;
        }
        this.jpegObj = new JpegObj();
        this.jpegObj.comment = (String)params.get("comment");
        this.applicationTag = (String)params.get("jpgAppTag");
    }

    @Override
    protected void generate() throws IOException {
        this.jpegObj.imageWidth = this.width;
        this.jpegObj.imageHeight = this.height;
        this.dct = new DCT(this.quality);
        this.huf = new Huffman(this.width, this.height);
        if (this.jpegObj == null) {
            return;
        }
        this.jpegObj.getYCCArray(this.pixels);
        String longState = this.writeHeaders(this.jpegObj, this.dct);
        this.writeCompressedData(this.jpegObj, this.dct, this.huf);
        this.writeMarker(eoi);
        if (longState != null) {
            byte[] b = longState.getBytes();
            this.out.write(b, 0, b.length);
        }
    }

    private void writeCompressedData(JpegObj jpegObj, DCT dct, Huffman huf) {
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[jpegObj.numberOfComponents];
        int minBlockWidth = huf.imageWidth % 8 != 0 ? (int)(Math.floor((double)huf.imageWidth / 8.0) + 1.0) * 8 : huf.imageWidth;
        int minBlockHeight = huf.imageHeight % 8 != 0 ? (int)(Math.floor((double)huf.imageHeight / 8.0) + 1.0) * 8 : huf.imageHeight;
        int comp = 0;
        while (comp < jpegObj.numberOfComponents) {
            minBlockWidth = Math.min(minBlockWidth, jpegObj.blockWidth[comp]);
            minBlockHeight = Math.min(minBlockHeight, jpegObj.blockHeight[comp]);
            ++comp;
        }
        int xpos = 0;
        int r = 0;
        while (r < minBlockHeight) {
            int c = 0;
            while (c < minBlockWidth) {
                xpos = c * 8;
                int ypos = r * 8;
                comp = 0;
                while (comp < jpegObj.numberOfComponents) {
                    float[][] inputArray = jpegObj.components[comp];
                    int vsampF = jpegObj.vsampFactor[comp];
                    int hsampF = jpegObj.hsampFactor[comp];
                    int qNumber = jpegObj.qtableNumber[comp];
                    int dcNumber = jpegObj.dctableNumber[comp];
                    int acNumber = jpegObj.actableNumber[comp];
                    int i = 0;
                    while (i < vsampF) {
                        int j = 0;
                        while (j < hsampF) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            int a = 0;
                            while (a < 8) {
                                int b = 0;
                                while (b < 8) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                    ++b;
                                }
                                ++a;
                            }
                            dctArray2 = DCT.forwardDCT(dctArray1);
                            dctArray3 = DCT.quantizeBlock(dctArray2, dct.divisors[qNumber]);
                            huf.HuffmanBlockEncoder(this.out, dctArray3, lastDCvalue[comp], dcNumber, acNumber);
                            lastDCvalue[comp] = dctArray3[0];
                            ++j;
                        }
                        ++i;
                    }
                    ++comp;
                }
                ++c;
            }
            ++r;
        }
        huf.flushBuffer(this.out);
    }

    private String writeHeaders(JpegObj jpegObj, DCT dct) {
        this.writeMarker(soi);
        this.writeArray(jfif);
        String comment = null;
        if (jpegObj.comment.length() > 0) {
            this.writeString(jpegObj.comment, (byte)-31);
        }
        this.writeString("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.\n\n", (byte)-2);
        byte[] dqt = new byte[134];
        dqt[0] = -1;
        dqt[1] = -37;
        dqt[2] = 0;
        dqt[3] = -124;
        int offset = 4;
        int i = 0;
        while (i < 2) {
            dqt[offset++] = (byte)(0 + i);
            int[] tempArray = dct.quantum[i];
            int j = 0;
            while (j < 64) {
                dqt[offset++] = (byte)tempArray[Huffman.jpegNaturalOrder[j]];
                ++j;
            }
            ++i;
        }
        this.writeArray(dqt);
        byte[] sof = new byte[19];
        sof[0] = -1;
        sof[1] = -64;
        sof[2] = 0;
        sof[3] = 17;
        sof[4] = (byte)jpegObj.precision;
        sof[5] = (byte)(jpegObj.imageHeight >> 8 & 0xFF);
        sof[6] = (byte)(jpegObj.imageHeight & 0xFF);
        sof[7] = (byte)(jpegObj.imageWidth >> 8 & 0xFF);
        sof[8] = (byte)(jpegObj.imageWidth & 0xFF);
        sof[9] = (byte)jpegObj.numberOfComponents;
        int index = 10;
        i = 0;
        while (i < sof[9]) {
            sof[index++] = (byte)jpegObj.compID[i];
            sof[index++] = (byte)((jpegObj.hsampFactor[i] << 4) + jpegObj.vsampFactor[i]);
            sof[index++] = (byte)jpegObj.qtableNumber[i];
            ++i;
        }
        this.writeArray(sof);
        this.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance);
        this.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance);
        this.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance);
        this.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance);
        byte[] sos = new byte[14];
        sos[0] = -1;
        sos[1] = -38;
        sos[2] = 0;
        sos[3] = 12;
        sos[4] = (byte)jpegObj.numberOfComponents;
        index = 5;
        i = 0;
        while (i < sos[4]) {
            sos[index++] = (byte)jpegObj.compID[i];
            sos[index++] = (byte)((jpegObj.dctableNumber[i] << 4) + jpegObj.actableNumber[i]);
            ++i;
        }
        sos[index++] = (byte)jpegObj.ss;
        sos[index++] = (byte)jpegObj.se;
        sos[index++] = (byte)((jpegObj.ah << 4) + jpegObj.al);
        this.writeArray(sos);
        return comment;
    }

    private void writeString(String s, byte id) {
        int len = s.length();
        int i0 = 0;
        String suffix = this.applicationTag;
        while (i0 < len) {
            int pt;
            int nBytes = len - i0;
            if (nBytes > 65510 && (pt = s.lastIndexOf(10, i0 + (nBytes = 65500))) > i0 + 1) {
                nBytes = pt - i0;
            }
            if (i0 + nBytes == len) {
                suffix = "";
            }
            this.writeTag(nBytes + suffix.length(), id);
            this.writeArray(s.substring(i0, i0 + nBytes).getBytes());
            if (suffix.length() > 0) {
                this.writeArray(suffix.getBytes());
            }
            i0 += nBytes;
        }
    }

    private void writeTag(int length, byte id) {
        byte[] com = new byte[]{-1, id, (byte)((length += 2) >> 8 & 0xFF), (byte)(length & 0xFF)};
        this.writeArray(com);
    }

    void WriteDHTHeader(int[] bits, int[] val) {
        int bytes = 0;
        int j = 1;
        while (j < 17) {
            bytes += bits[j];
            ++j;
        }
        byte[] dht = new byte[21 + bytes];
        dht[0] = -1;
        dht[1] = -60;
        int index = 4;
        int j2 = 0;
        while (j2 < 17) {
            dht[index++] = (byte)bits[j2];
            ++j2;
        }
        j2 = 0;
        while (j2 < bytes) {
            dht[index++] = (byte)val[j2];
            ++j2;
        }
        dht[2] = (byte)(index - 2 >> 8 & 0xFF);
        dht[3] = (byte)(index - 2 & 0xFF);
        this.writeArray(dht);
    }

    void writeMarker(byte[] data) {
        this.out.write(data, 0, 2);
    }

    void writeArray(byte[] data) {
        this.out.write(data, 0, data.length);
    }
}

