/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

public class IvyContext {
    private static ThreadLocal current = new ThreadLocal();
    private Ivy defaultIvy;
    private WeakReference ivy = new WeakReference<Object>(null);
    private Map contextMap = new HashMap();
    private Thread operatingThread;
    private ResolveData resolveData;
    private DependencyDescriptor dd;

    public IvyContext() {
    }

    public IvyContext(IvyContext ivyContext) {
        this.defaultIvy = ivyContext.defaultIvy;
        this.ivy = ivyContext.ivy;
        this.contextMap = new HashMap(ivyContext.contextMap);
        this.operatingThread = ivyContext.operatingThread;
        this.resolveData = ivyContext.resolveData;
        this.dd = ivyContext.dd;
    }

    public static IvyContext getContext() {
        Stack stack = IvyContext.getCurrentStack();
        if (stack.isEmpty()) {
            stack.push(new IvyContext());
        }
        return (IvyContext)stack.peek();
    }

    private static Stack getCurrentStack() {
        Stack stack = (Stack)current.get();
        if (stack == null) {
            stack = new Stack();
            current.set(stack);
        }
        return stack;
    }

    public static IvyContext pushNewContext() {
        return IvyContext.pushContext(new IvyContext());
    }

    public static IvyContext pushNewCopyContext() {
        return IvyContext.pushContext(new IvyContext(IvyContext.getContext()));
    }

    public static IvyContext pushContext(IvyContext ivyContext) {
        IvyContext.getCurrentStack().push(ivyContext);
        return ivyContext;
    }

    public static IvyContext popContext() {
        return (IvyContext)IvyContext.getCurrentStack().pop();
    }

    public static Object peekInContextStack(String string) {
        Object object = null;
        Stack stack = IvyContext.getCurrentStack();
        for (int i = stack.size() - 1; i >= 0 && object == null; --i) {
            IvyContext ivyContext = (IvyContext)stack.get(i);
            object = ivyContext.peek(string);
        }
        return object;
    }

    public Ivy getIvy() {
        Ivy ivy = this.peekIvy();
        return ivy == null ? this.getDefaultIvy() : ivy;
    }

    public Ivy peekIvy() {
        Ivy ivy = (Ivy)this.ivy.get();
        return ivy;
    }

    private Ivy getDefaultIvy() {
        if (this.defaultIvy == null) {
            this.defaultIvy = Ivy.newInstance();
            try {
                this.defaultIvy.configureDefault();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultIvy;
    }

    public void setIvy(Ivy ivy) {
        this.ivy = new WeakReference<Ivy>(ivy);
        this.operatingThread = Thread.currentThread();
    }

    public IvySettings getSettings() {
        return this.getIvy().getSettings();
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getSettings().getCircularDependencyStrategy();
    }

    public Object get(String string) {
        WeakReference weakReference = (WeakReference)this.contextMap.get(string);
        return weakReference == null ? null : weakReference.get();
    }

    public void set(String string, Object object) {
        this.contextMap.put(string, new WeakReference<Object>(object));
    }

    public Object peek(String string) {
        Map map = this.contextMap;
        synchronized (map) {
            Object v = this.contextMap.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof List) {
                if (((List)v).size() == 0) {
                    return null;
                }
                Object e = ((List)v).get(0);
                return e;
            }
            throw new RuntimeException("Cannot top from non List object " + v);
        }
    }

    public Object pop(String string) {
        Map map = this.contextMap;
        synchronized (map) {
            Object v = this.contextMap.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof List) {
                if (((List)v).size() == 0) {
                    return null;
                }
                Object e = ((List)v).remove(0);
                return e;
            }
            throw new RuntimeException("Cannot pop from non List object " + v);
        }
    }

    public boolean pop(String string, Object object) {
        Map map = this.contextMap;
        synchronized (map) {
            Object v = this.contextMap.get(string);
            if (v == null) {
                return false;
            }
            if (v instanceof List) {
                if (((List)v).size() == 0) {
                    return false;
                }
                Object e = ((List)v).get(0);
                if (!e.equals(object)) {
                    return false;
                }
                ((List)v).remove(0);
                return true;
            }
            throw new RuntimeException("Cannot pop from non List object " + v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String string, Object object) {
        Map map = this.contextMap;
        synchronized (map) {
            Object v;
            if (!this.contextMap.containsKey(string)) {
                this.contextMap.put(string, new LinkedList());
            }
            if (!((v = this.contextMap.get(string)) instanceof List)) {
                throw new RuntimeException("Cannot push to non List object " + v);
            }
            ((List)v).add(0, object);
        }
    }

    public Thread getOperatingThread() {
        return this.operatingThread;
    }

    public MessageLogger getMessageLogger() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            if (this.defaultIvy == null) {
                return Message.getDefaultLogger();
            }
            return this.defaultIvy.getLoggerEngine();
        }
        return ivy.getLoggerEngine();
    }

    public EventManager getEventManager() {
        return this.getIvy().getEventManager();
    }

    public void checkInterrupted() {
        this.getIvy().checkInterrupted();
    }

    public void setResolveData(ResolveData resolveData) {
        this.resolveData = resolveData;
    }

    public ResolveData getResolveData() {
        return this.resolveData;
    }

    public void setDependencyDescriptor(DependencyDescriptor dependencyDescriptor) {
        this.dd = dependencyDescriptor;
    }

    public DependencyDescriptor getDependencyDescriptor() {
        return this.dd;
    }
}

