/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.client.ResourceManager;
import java.io.File;

public abstract class StringUtils {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";

    public static String getPackageName(Class type) {
        String className = type.getName();
        int index = className.lastIndexOf(46);
        return className.substring(0, index);
    }

    public static String getPackageName(Object object) {
        return StringUtils.getPackageName(object.getClass());
    }

    public static String getPureClassName(Class type) {
        String className = type.getName();
        int index = className.lastIndexOf(46);
        return className.substring(index + 1, className.length());
    }

    public static String getPureClassName(Object object) {
        return StringUtils.getPureClassName(object.getClass());
    }

    public static String getString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ResourceManager.getResource(StringUtils.class, "CI_Yes_text");
            }
            return ResourceManager.getResource(StringUtils.class, "CI_No_text");
        }
        return value.toString();
    }

    public static String getStringLimited(String value, int length) {
        if (!StringUtils.isNullOrEmpty(value) && value.length() > length) {
            return value.substring(0, length - 1) + '\u05b5';
        }
        return value;
    }

    public static String getNextWord(String value, int startAt) {
        if (!StringUtils.isNullOrEmpty(value) && value.length() > startAt) {
            String temp = value.substring(startAt, value.length()).trim();
            int index = temp.indexOf(" ");
            if (index > 0) {
                return temp.substring(0, index);
            }
            if (temp.length() > 0) {
                char last = temp.charAt(temp.length() - 1);
                if (last == '.' || last == '!' || last == ',' || last == ';' || last == ':' || last == '?') {
                    temp = temp.substring(0, temp.length() - 1);
                }
                return temp;
            }
        }
        return "";
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String replace(String source, String searchTerm, String replacement) {
        if (source == null) {
            return null;
        }
        return StringUtils.replace(new StringBuffer(source), searchTerm, replacement);
    }

    public static String replace(StringBuffer buffer, String searchTerm, String replacement) {
        if (buffer == null) {
            return null;
        }
        if (!StringUtils.isNullOrEmpty(buffer.toString())) {
            int index = -1;
            while ((index = buffer.indexOf(searchTerm, index == -1 ? index : index + replacement.length())) > -1) {
                buffer.delete(index, index + searchTerm.length());
                buffer.insert(index, replacement);
            }
        }
        return buffer.toString();
    }

    public static String getBooleanString(Boolean value) {
        if (value == null) {
            return "";
        }
        if (value.booleanValue()) {
            return ResourceManager.getResource(StringUtils.class, "CI_Yes_text");
        }
        return ResourceManager.getResource(StringUtils.class, "CI_No_text");
    }

    public static String tryAppendSuffix(String filename, String suffix) {
        if (filename.toLowerCase().endsWith(suffix.toLowerCase())) {
            return filename;
        }
        return filename + suffix;
    }

    public static String firstLetterToLowercase(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value);
        buffer.replace(0, 1, buffer.substring(0, 1).toLowerCase());
        return buffer.toString();
    }

    public static String firstLetterToUppercase(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value);
        buffer.replace(0, 1, buffer.substring(0, 1).toUpperCase());
        return buffer.toString();
    }

    public static String makeValidFileName(String filename, String replacmenetSeparator) {
        String fn = StringUtils.replace(filename, ":", replacmenetSeparator);
        fn = StringUtils.replace(fn, "\"", replacmenetSeparator);
        fn = StringUtils.replace(fn, "\\", replacmenetSeparator);
        fn = StringUtils.replace(fn, "/", replacmenetSeparator);
        return StringUtils.replace(fn, File.pathSeparator, replacmenetSeparator);
    }
}

