/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ArrangeableProxyListener;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyThread;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.PersistentConnectionListener;

public class ProxyServer
implements Runnable {
    protected Thread thread = null;
    protected static final int PORT_TIME_OUT = 0;
    protected ServerSocket proxySocket = null;
    protected boolean isProxyRunning = false;
    protected ProxyParam proxyParam = new ProxyParam();
    protected ConnectionParam connectionParam = new ConnectionParam();
    protected Vector<ProxyListener> listenerList = new Vector();
    protected Vector<OverrideMessageProxyListener> overrideListeners = new Vector();
    protected Vector<PersistentConnectionListener> persistentConnectionListenerList = new Vector();
    private final List<ConnectRequestProxyListener> connectRequestProxyListeners;
    private static Comparator<ArrangeableProxyListener> listenersComparator;
    protected boolean serialize = false;
    protected boolean enableCacheProcessing = false;
    protected Vector<CacheProcessingItem> cacheProcessingList = new Vector();
    private List<Pattern> excludeUrls = null;
    private boolean enableApi = false;
    private static Logger log;
    private String threadName = "ZAP-ProxyServer";

    public boolean isEnableCacheProcessing() {
        return this.enableCacheProcessing;
    }

    public void setEnableCacheProcessing(boolean bl) {
        this.enableCacheProcessing = bl;
        if (!bl) {
            this.cacheProcessingList.clear();
        }
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public ProxyServer() {
        this(null);
    }

    public ProxyServer(String string) {
        this.connectRequestProxyListeners = new ArrayList<ConnectRequestProxyListener>(1);
        if (string != null) {
            this.threadName = string;
        }
    }

    public void setProxyParam(ProxyParam proxyParam) {
        this.proxyParam = proxyParam;
    }

    public ProxyParam getProxyParam() {
        return this.proxyParam;
    }

    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public synchronized int startServer(String string, int n, boolean bl) {
        if (this.isProxyRunning) {
            this.stopServer();
        }
        this.isProxyRunning = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        this.proxySocket = null;
        for (int i = 0; i < 20 && this.proxySocket == null; ++i) {
            try {
                this.proxySocket = this.createServerSocket(string, n);
                this.proxySocket.setSoTimeout(0);
                this.isProxyRunning = true;
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                if (View.isInitialised()) {
                    View.getSingleton().showWarningDialog(Constant.messages.getString("proxy.error.host.unknow") + " " + string);
                } else {
                    System.out.println(Constant.messages.getString("proxy.error.host.unknow") + " " + string);
                }
                return -1;
            }
            catch (BindException bindException) {
                String string2 = bindException.getMessage();
                if (string2 == null || string2.isEmpty()) {
                    ProxyServer.handleUnknownException(bindException);
                    return -1;
                }
                if (string2.startsWith("Cannot assign requested address")) {
                    ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.address") + " " + string);
                    return -1;
                }
                if (string2.startsWith("Permission denied") || string2.startsWith("Address already in use")) {
                    if (!bl) {
                        ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.port") + " " + string + ":" + n);
                        return -1;
                    }
                    if (n >= 65535) continue;
                    ++n;
                    continue;
                }
                ProxyServer.handleUnknownException(bindException);
                return -1;
            }
            catch (IOException iOException) {
                ProxyServer.handleUnknownException(iOException);
                return -1;
            }
        }
        if (this.proxySocket == null) {
            return -1;
        }
        this.thread.start();
        return this.proxySocket.getLocalPort();
    }

    private static void showErrorMessage(String string) {
        if (View.isInitialised()) {
            View.getSingleton().showWarningDialog(string);
        } else {
            log.error((Object)string);
            System.out.println(string);
        }
    }

    private static void handleUnknownException(Exception exception) {
        log.error((Object)"Failed to start the proxy server: ", (Throwable)exception);
        ProxyServer.showErrorMessage(Constant.messages.getString("proxy.error.generic") + exception.getLocalizedMessage());
    }

    public synchronized boolean stopServer() {
        if (!this.isProxyRunning) {
            return false;
        }
        this.isProxyRunning = false;
        HttpUtil.closeServerSocket(this.proxySocket);
        try {
            this.thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.proxySocket = null;
        return true;
    }

    @Override
    public void run() {
        while (this.isProxyRunning) {
            try {
                Socket socket = this.proxySocket.accept();
                ProxyThread proxyThread = this.createProxyProcess(socket);
                proxyThread.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected ServerSocket createServerSocket(String string, int n) throws UnknownHostException, IOException {
        InetAddress inetAddress = null;
        if (string != null && !string.isEmpty()) {
            inetAddress = InetAddress.getByName(string);
        }
        ServerSocket serverSocket = new ServerSocket(n, 400, inetAddress);
        return serverSocket;
    }

    protected ProxyThread createProxyProcess(Socket socket) {
        ProxyThread proxyThread = new ProxyThread(this, socket);
        return proxyThread;
    }

    protected void writeOutput(String string) {
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.listenerList.add(proxyListener);
        Collections.sort(this.listenerList, this.getListenersComparator());
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.listenerList.remove(proxyListener);
    }

    synchronized List<ProxyListener> getListenerList() {
        return this.listenerList;
    }

    public void addPersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.persistentConnectionListenerList.add(persistentConnectionListener);
        Collections.sort(this.persistentConnectionListenerList, this.getListenersComparator());
    }

    public void removePersistentConnectionListener(PersistentConnectionListener persistentConnectionListener) {
        this.persistentConnectionListenerList.remove(persistentConnectionListener);
    }

    synchronized List<PersistentConnectionListener> getPersistentConnectionListenerList() {
        return this.persistentConnectionListenerList;
    }

    public void addOverrideMessageProxyListener(OverrideMessageProxyListener overrideMessageProxyListener) {
        this.overrideListeners.add(overrideMessageProxyListener);
        Collections.sort(this.overrideListeners, this.getListenersComparator());
    }

    public void removeOverrideMessageProxyListener(OverrideMessageProxyListener overrideMessageProxyListener) {
        this.overrideListeners.remove(overrideMessageProxyListener);
    }

    List<OverrideMessageProxyListener> getOverrideMessageProxyListeners() {
        return this.overrideListeners;
    }

    public void addConnectRequestProxyListener(ConnectRequestProxyListener connectRequestProxyListener) {
        this.connectRequestProxyListeners.add(connectRequestProxyListener);
    }

    private static void validateListenerNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter listener must not be null.");
        }
    }

    public void removeConnectRequestProxyListener(ConnectRequestProxyListener connectRequestProxyListener) {
        ProxyServer.validateListenerNotNull(connectRequestProxyListener);
        this.connectRequestProxyListeners.remove(connectRequestProxyListener);
    }

    List<ConnectRequestProxyListener> getConnectRequestProxyListeners() {
        return Collections.unmodifiableList(this.connectRequestProxyListeners);
    }

    public boolean isAnyProxyThreadRunning() {
        return ProxyThread.isAnyProxyThreadRunning();
    }

    public void setSerialize(boolean bl) {
        this.serialize = bl;
    }

    public void addCacheProcessingList(CacheProcessingItem cacheProcessingItem) {
        this.cacheProcessingList.add(cacheProcessingItem);
    }

    Vector<CacheProcessingItem> getCacheProcessingList() {
        return this.cacheProcessingList;
    }

    public void setExcludeList(List<String> list) {
        this.excludeUrls = new ArrayList<Pattern>(list.size());
        for (String string : list) {
            Pattern pattern = Pattern.compile(string, 2);
            this.excludeUrls.add(pattern);
        }
    }

    public boolean excludeUrl(URI uRI) {
        boolean bl = false;
        if (this.excludeUrls != null) {
            String string = uRI.toString();
            for (Pattern pattern : this.excludeUrls) {
                if (!pattern.matcher(string).matches()) continue;
                bl = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("URL excluded: " + string + " Regex: " + pattern.pattern()));
                break;
            }
        }
        return bl;
    }

    private Comparator<ArrangeableProxyListener> getListenersComparator() {
        if (listenersComparator == null) {
            this.createListenersComparator();
        }
        return listenersComparator;
    }

    private synchronized void createListenersComparator() {
        if (listenersComparator == null) {
            listenersComparator = new Comparator<ArrangeableProxyListener>(){

                @Override
                public int compare(ArrangeableProxyListener arrangeableProxyListener, ArrangeableProxyListener arrangeableProxyListener2) {
                    int n;
                    int n2 = arrangeableProxyListener.getArrangeableListenerOrder();
                    if (n2 < (n = arrangeableProxyListener2.getArrangeableListenerOrder())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }

    public void setEnableApi(boolean bl) {
        this.enableApi = bl;
    }

    public boolean isEnableApi() {
        return this.enableApi;
    }

    static {
        log = Logger.getLogger(ProxyServer.class);
    }
}

