/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.view.View;

public class SiteNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 7987615016786179150L;
    private String nodeName = null;
    private String hierarchicNodeName = null;
    private HistoryReference historyReference = null;
    private Vector<HistoryReference> pastHistoryList = new Vector(10);
    private SiteMap siteMap = null;
    private Set<Alert> alerts = Collections.synchronizedSet(new HashSet());
    private boolean justSpidered = false;
    private ArrayList<String> icons = null;
    private ArrayList<Boolean> clearIfManual = null;
    private static Logger log = Logger.getLogger(SiteNode.class);
    private boolean isIncludedInScope = false;
    private boolean isExcludedFromScope = false;
    private boolean filtered = false;
    private boolean dataDriven = false;
    private boolean calculateHighestAlert;
    private Alert highestAlert;

    public SiteNode(SiteMap siteMap, int n, String string) {
        this.siteMap = siteMap;
        this.nodeName = string;
        if (string.startsWith("\u00ab")) {
            this.dataDriven = true;
        }
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        if (n == 2) {
            this.justSpidered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomIcons(ArrayList<String> arrayList, ArrayList<Boolean> arrayList2) {
        ArrayList<String> arrayList3 = this.icons;
        synchronized (arrayList3) {
            this.icons.clear();
            this.icons.addAll(arrayList);
            this.clearIfManual = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomIcon(String string, boolean bl) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (!this.icons.contains(string)) {
                this.icons.add(string);
                this.clearIfManual.add(bl);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomIcon(String string) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (this.icons.contains(string)) {
                int n = this.icons.indexOf(string);
                this.icons.remove(n);
                this.clearIfManual.remove(n);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImageIcon> getCustomIcons() {
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        if (this.justSpidered) {
            arrayList.add(new ImageIcon(Constant.class.getResource("/resource/icon/10/spider.png")));
        }
        ArrayList<String> arrayList2 = this.icons;
        synchronized (arrayList2) {
            if (!this.icons.isEmpty()) {
                for (String string : this.icons) {
                    arrayList.add(new ImageIcon(Constant.class.getResource(string)));
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateHighestAlert() {
        Set<Alert> set = this.alerts;
        synchronized (set) {
            this.highestAlert = null;
            for (Alert alert : this.alerts) {
                if (!this.isHighestAlert(alert)) continue;
                this.highestAlert = alert;
            }
            this.calculateHighestAlert = false;
        }
    }

    private boolean isHighestAlert(Alert alert) {
        if (alert.getConfidence() == 0) {
            return false;
        }
        if (this.highestAlert == null) {
            return true;
        }
        return alert.getRisk() > this.highestAlert.getRisk();
    }

    public Alert getHighestAlert() {
        return this.highestAlert;
    }

    @Override
    public String toString() {
        if (this.calculateHighestAlert) {
            this.calculateHighestAlert();
        }
        return this.nodeName;
    }

    public boolean isParentOf(String string) {
        if (string == null) {
            return false;
        }
        return string.compareTo(this.nodeName) < 0;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getCleanNodeName() {
        return this.getCleanNodeName(true);
    }

    public String getCleanNodeName(boolean bl) {
        String string = this.getNodeName();
        if (bl && this.isDataDriven()) {
            string = "(.+?)";
        } else if (this.isLeaf()) {
            int n;
            int n2;
            int n3 = string.indexOf(":");
            if (n3 > 0) {
                string = string.substring(n3 + 1);
            }
            if ((n2 = string.lastIndexOf("(")) > 0) {
                string = string.substring(0, n2);
            }
            if ((n = string.indexOf("?")) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public String getHierarchicNodeName() {
        return this.getHierarchicNodeName(true);
    }

    public String getHierarchicNodeName(boolean bl) {
        if (this.hierarchicNodeName != null && bl) {
            return this.hierarchicNodeName;
        }
        if (this.isRoot()) {
            this.hierarchicNodeName = "";
        } else if (this.getParent().isRoot()) {
            this.hierarchicNodeName = this.getNodeName();
        } else {
            String string = this.getParent().getHierarchicNodeName(bl) + "/" + this.getCleanNodeName(bl);
            if (!bl) {
                return string;
            }
            this.hierarchicNodeName = string;
        }
        return this.hierarchicNodeName;
    }

    public HistoryReference getHistoryReference() {
        return this.historyReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryReference(HistoryReference historyReference) {
        if (this.getHistoryReference() != null) {
            if (this.justSpidered && (historyReference.getHistoryType() == 1 || historyReference.getHistoryType() == 15)) {
                this.justSpidered = false;
                this.nodeChanged();
            }
            if (!(this.icons.isEmpty() || historyReference.getHistoryType() != 1 && historyReference.getHistoryType() != 15)) {
                ArrayList<String> arrayList = this.icons;
                synchronized (arrayList) {
                    for (int i = 0; i < this.clearIfManual.size(); ++i) {
                        if (!this.clearIfManual.get(i).booleanValue() || this.icons.size() <= i) continue;
                        this.icons.remove(i);
                        this.clearIfManual.remove(i);
                    }
                }
                this.nodeChanged();
            }
            if (3 == historyReference.getHistoryType()) {
                this.getPastHistoryReference().add(historyReference);
                return;
            }
            if (!this.getPastHistoryReference().contains(this.getHistoryReference())) {
                this.getPastHistoryReference().add(this.getHistoryReference());
            }
        }
        this.historyReference = historyReference;
        this.historyReference.setSiteNode(this);
    }

    private void nodeChanged() {
        if (this.siteMap == null || !View.isInitialised()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.nodeChangedEventHandler();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SiteNode.this.nodeChangedEventHandler();
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void nodeChangedEventHandler() {
        this.siteMap.nodeChanged(this);
    }

    public Vector<HistoryReference> getPastHistoryReference() {
        return this.pastHistoryList;
    }

    public boolean hasAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        return this.alerts.contains(alert);
    }

    public void addAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        if (!this.alerts.add(alert)) {
            return;
        }
        if (this.isHighestAlert(alert)) {
            this.highestAlert = alert;
        }
        if (this.getParent() != null) {
            this.getParent().addAlert(alert);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        boolean bl = false;
        Set<Alert> set = this.alerts;
        synchronized (set) {
            Iterator<Alert> iterator = this.alerts.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getAlertId() != alert.getAlertId()) continue;
                iterator.remove();
                bl = true;
                this.alerts.add(alert);
                this.setCalculateHighestAlertIfSameAlert(alert);
                break;
            }
        }
        if (bl) {
            if (this.getParent() != null) {
                this.getParent().updateAlert(alert);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Alert> getAlerts() {
        Set<Alert> set = this.alerts;
        synchronized (set) {
            return new ArrayList<Alert>(this.alerts);
        }
    }

    private void clearChildAlert(Alert alert, SiteNode siteNode) {
        boolean bl = true;
        this.alerts.remove(alert);
        if (this.getChildCount() > 0) {
            SiteNode siteNode2 = (SiteNode)this.getFirstChild();
            while (siteNode2 != null) {
                if (!siteNode2.equals(siteNode) && siteNode2.hasAlert(alert)) {
                    this.alerts.add(alert);
                    bl = false;
                    break;
                }
                siteNode2 = (SiteNode)this.getChildAfter(siteNode2);
            }
        }
        if (bl) {
            this.setCalculateHighestAlertIfSameAlert(alert);
            this.nodeChanged();
            if (this.getParent() != null) {
                this.getParent().clearChildAlert(alert, this);
            }
        }
    }

    public void deleteAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        if (!this.alerts.remove(alert)) {
            return;
        }
        this.setCalculateHighestAlertIfSameAlert(alert);
        if (this.getParent() != null) {
            this.getParent().clearChildAlert(alert, this);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    private void setCalculateHighestAlertIfSameAlert(Alert alert) {
        if (this.highestAlert != null && this.highestAlert.getAlertId() == alert.getAlertId()) {
            this.calculateHighestAlert = true;
            this.highestAlert = null;
        }
    }

    public void deleteAlerts(List<Alert> list) {
        if (this.alerts.removeAll(list)) {
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(list);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.calculateHighestAlert = true;
            this.nodeChanged();
        }
    }

    public void deleteAllAlerts() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((SiteNode)this.getChildAt(i)).deleteAllAlerts();
        }
        if (!this.alerts.isEmpty()) {
            this.alerts.clear();
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    private void clearChildAlerts(List<Alert> list) {
        boolean bl;
        ArrayList<Alert> arrayList = new ArrayList<Alert>(list);
        if (this.getChildCount() > 0) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                arrayList.removeAll(siteNode.alerts);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
        if (bl = this.alerts.removeAll(arrayList)) {
            this.calculateHighestAlert = true;
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(arrayList);
            }
            this.nodeChangedEventHandler();
        }
    }

    public boolean hasHistoryType(int n) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() == n) {
            return true;
        }
        for (HistoryReference historyReference : this.pastHistoryList) {
            if (historyReference.getHistoryType() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasJustHistoryType(int n) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() != n) {
            return false;
        }
        for (HistoryReference historyReference : this.pastHistoryList) {
            if (historyReference.getHistoryType() == n) continue;
            return false;
        }
        return true;
    }

    public boolean isIncludedInScope() {
        return this.isIncludedInScope;
    }

    public void setIncludedInScope(boolean bl, boolean bl2) {
        this.isIncludedInScope = bl;
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (this.getChildCount() > 0 && bl2) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                siteNode.setIncludedInScope(bl, bl2);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
    }

    public boolean isExcludedFromScope() {
        return this.isExcludedFromScope;
    }

    public void setExcludedFromScope(boolean bl, boolean bl2) {
        this.isExcludedFromScope = bl;
        if (bl) {
            this.isIncludedInScope = false;
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (this.getChildCount() > 0 && bl2) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                siteNode.setExcludedFromScope(bl, bl2);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == this) {
            return;
        }
        super.setParent(mutableTreeNode);
    }

    @Override
    public SiteNode getParent() {
        return (SiteNode)super.getParent();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    protected void setFiltered(boolean bl) {
        this.filtered = bl;
    }

    public boolean isDataDriven() {
        return this.dataDriven;
    }
}

