/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.GenericMethod;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.network.ZapDeleteMethod;
import org.zaproxy.zap.network.ZapHeadMethod;
import org.zaproxy.zap.network.ZapOptionsMethod;
import org.zaproxy.zap.network.ZapPostMethod;
import org.zaproxy.zap.network.ZapPutMethod;
import org.zaproxy.zap.network.ZapTraceMethod;

public class HttpMethodHelper {
    private static final Logger logger = Logger.getLogger(HttpMethodHelper.class);
    private static final String OPTIONS = "OPTIONS";
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private static final Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    private static final Pattern patternLF = Pattern.compile("\\n", 8);
    private String mUserAgent = "";

    public void setUserAgent(String string) {
        this.mUserAgent = string;
    }

    public HttpMethod createRequestMethodNew(HttpRequestHeader httpRequestHeader, HttpBody httpBody) throws URIException {
        GenericMethod genericMethod = null;
        String string = httpRequestHeader.getMethod();
        URI uRI = httpRequestHeader.getURI();
        String string2 = httpRequestHeader.getVersion();
        genericMethod = new GenericMethod(string);
        genericMethod.setURI(uRI);
        HttpMethodParams httpMethodParams = genericMethod.getParams();
        httpMethodParams.setVersion(HttpVersion.HTTP_1_0);
        if (string2.equalsIgnoreCase("HTTP/1.1")) {
            httpMethodParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int n = 0;
        Pattern pattern = patternCRLF;
        String string3 = CRLF;
        String string4 = httpRequestHeader.getHeadersAsString();
        n = string4.indexOf(CRLF);
        if (n < 0) {
            n = string4.indexOf(LF);
            if (n < 0) {
                string3 = LF;
                pattern = patternLF;
            }
        } else {
            string3 = CRLF;
            pattern = patternCRLF;
        }
        String[] stringArray = pattern.split(string4);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = stringArray[i];
            if (string5.equals("")) continue;
            n = string5.indexOf(":");
            if (n < 0) {
                return null;
            }
            string6 = string5.substring(0, n).trim();
            string7 = string5.substring(n + 1).trim();
            genericMethod.addRequestHeader(string6, string7);
        }
        if (httpBody != null && httpBody.length() > 0) {
            EntityEnclosingMethod entityEnclosingMethod = genericMethod;
            entityEnclosingMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(httpBody.getBytes()));
        }
        genericMethod.setFollowRedirects(false);
        return genericMethod;
    }

    public HttpMethod createRequestMethod(HttpRequestHeader httpRequestHeader, HttpBody httpBody) throws URIException {
        Object object = null;
        String string = httpRequestHeader.getMethod();
        URI uRI = httpRequestHeader.getURI();
        String string2 = httpRequestHeader.getVersion();
        if (string == null || string.trim().length() < 3) {
            throw new URIException("Invalid HTTP method: " + string);
        }
        object = string.equalsIgnoreCase(GET) ? new ZapGetMethod() : (string.equalsIgnoreCase(POST) ? new ZapPostMethod() : (string.equalsIgnoreCase(DELETE) ? new ZapDeleteMethod() : (string.equalsIgnoreCase(PUT) ? new ZapPutMethod() : (string.equalsIgnoreCase(HEAD) ? new ZapHeadMethod() : (string.equalsIgnoreCase(OPTIONS) ? new ZapOptionsMethod() : (string.equalsIgnoreCase(TRACE) ? new ZapTraceMethod(uRI.toString()) : new GenericMethod(string)))))));
        try {
            object.setURI(uRI);
        }
        catch (Exception exception) {
            throw new URIException("Failed to set URI [" + uRI + "]: " + exception.getMessage());
        }
        HttpMethodParams httpMethodParams = object.getParams();
        httpMethodParams.setVersion(HttpVersion.HTTP_1_0);
        if (string2.equalsIgnoreCase("HTTP/1.1")) {
            httpMethodParams.setVersion(HttpVersion.HTTP_1_1);
        }
        int n = 0;
        Pattern pattern = patternCRLF;
        String string3 = httpRequestHeader.getLineDelimiter();
        if (string3.equals(LF)) {
            string3 = LF;
            pattern = patternLF;
        }
        String string4 = httpRequestHeader.getHeadersAsString();
        String[] stringArray = pattern.split(string4);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = stringArray[i];
            if (string5.equals("")) continue;
            n = string5.indexOf(":");
            if (n < 0) {
                return null;
            }
            string6 = string5.substring(0, n).trim();
            string7 = string5.substring(n + 1).trim();
            object.addRequestHeader(string6, string7);
        }
        if (httpBody != null && httpBody.length() > 0 && object instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)object;
            entityEnclosingMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(httpBody.getBytes()));
        }
        object.setFollowRedirects(false);
        return object;
    }

    public static void updateHttpRequestHeaderSent(HttpRequestHeader httpRequestHeader, HttpMethod httpMethod) {
        if (!httpMethod.hasBeenUsed()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = null;
        String string2 = null;
        stringBuilder.append(httpRequestHeader.getPrimeHeader()).append(CRLF);
        Header[] headerArray = httpMethod.getRequestHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            string = headerArray[i].getName();
            string2 = headerArray[i].getValue();
            stringBuilder.append(string).append(": ").append(string2).append(CRLF);
        }
        stringBuilder.append(CRLF);
        try {
            httpRequestHeader.setMessage(stringBuilder.toString());
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.error((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
        }
    }

    private static String getHttpResponseHeaderAsString(HttpMethod httpMethod) {
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = null;
        String string2 = null;
        stringBuilder.append(httpMethod.getStatusLine().toString()).append(CRLF);
        Header[] headerArray = httpMethod.getResponseHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            string = headerArray[i].getName();
            string2 = headerArray[i].getValue();
            stringBuilder.append(string).append(": ").append(string2).append(CRLF);
        }
        stringBuilder.append(CRLF);
        return stringBuilder.toString();
    }

    public static HttpResponseHeader getHttpResponseHeader(HttpMethod httpMethod) throws HttpMalformedHeaderException {
        return new HttpResponseHeader(HttpMethodHelper.getHttpResponseHeaderAsString(httpMethod));
    }
}

