/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;

public class GenericAuthenticationCredentials
implements AuthenticationCredentials {
    private static final String API_NAME = "GenericAuthenticationCredentials";
    private String[] paramNames;
    private Map<String, String> paramValues;
    private static final String ACTION_SET_CREDENTIALS = "scriptBasedAuthenticationCredentials";
    private static final String PARAM_CONFIG_PARAMS = "authenticationCredentialsParams";

    public GenericAuthenticationCredentials(String[] stringArray) {
        this.paramNames = stringArray;
        this.paramValues = new HashMap<String, String>(stringArray.length);
    }

    public String getParam(String string) {
        return this.paramValues.get(string);
    }

    public String setParam(String string, String string2) {
        return this.paramValues.put(string, string2);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public String encode(String string) {
        return EncodingUtils.mapToString(this.paramValues);
    }

    @Override
    public void decode(String string) {
        this.paramValues = EncodingUtils.stringToMap(string);
        this.paramNames = this.paramValues.keySet().toArray(new String[this.paramValues.size()]);
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.paramValues);
        hashMap.put("type", API_NAME);
        return new ApiResponseSet<String>("credentials", hashMap);
    }

    public static ApiDynamicActionImplementor getSetCredentialsForUserApiAction(final AuthenticationMethodType authenticationMethodType) {
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, null, new String[]{PARAM_CONFIG_PARAMS}){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                int n = ApiUtils.getIntParam(jSONObject, "userId");
                if (!authenticationMethodType.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                User user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(n);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                GenericAuthenticationCredentials genericAuthenticationCredentials = (GenericAuthenticationCredentials)context.getAuthenticationMethod().createAuthenticationCredentials();
                for (String string : genericAuthenticationCredentials.paramNames) {
                    genericAuthenticationCredentials.setParam(string, ApiUtils.getNonEmptyStringParam(jSONObject, string));
                }
                user.setAuthenticationCredentials(genericAuthenticationCredentials);
            }
        };
    }

    protected static class GenericAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<GenericAuthenticationCredentials> {
        private static final long serialVersionUID = -6486907666459197059L;
        private DynamicFieldsPanel fieldsPanel;

        public GenericAuthenticationCredentialsOptionsPanel(GenericAuthenticationCredentials genericAuthenticationCredentials) {
            super(genericAuthenticationCredentials);
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            this.fieldsPanel = new DynamicFieldsPanel(((GenericAuthenticationCredentials)this.credentials).paramNames);
            this.fieldsPanel.bindFieldValues(((GenericAuthenticationCredentials)this.credentials).paramValues);
            this.add((Component)this.fieldsPanel, "Center");
        }

        @Override
        public boolean validateFields() {
            try {
                this.fieldsPanel.validateFields();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), Constant.messages.getString("authentication.method.fb.dialog.error.title"), 2);
                return false;
            }
            return true;
        }

        @Override
        public void saveCredentials() {
            ((GenericAuthenticationCredentials)this.credentials).paramValues = new HashMap<String, String>(this.fieldsPanel.getFieldValues());
        }
    }
}

