/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.autoupdate.OptionsAutoupdateDirsTableModel;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsCheckForUpdatesPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JCheckBox chkCheckOnStart = null;
    private JCheckBox chkDownloadNewRelease = null;
    private JCheckBox chkCheckAddonUpdates = null;
    private JCheckBox chkInstallAddonUpdates = null;
    private JCheckBox chkInstallScannerRules = null;
    private JCheckBox chkReportReleaseAddons = null;
    private JCheckBox chkReportBetaAddons = null;
    private JCheckBox chkReportAlphaAddons = null;
    private OptionsAutoupdateDirsTableModel scriptDirModel = null;
    private JComboBox<String> downloadDir = null;

    public OptionsCheckForUpdatesPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("cfu.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.options.zap.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            jPanel.add((Component)this.getChkDownloadNewRelease(), LayoutHelper.getGBC(0, 1, 1, 1.0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.options.updates.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            jPanel2.add((Component)this.getChkCheckAddonUpdates(), LayoutHelper.getGBC(0, 0, 1, 1.0));
            jPanel2.add((Component)this.getChkInstallAddonUpdates(), LayoutHelper.getGBC(0, 1, 1, 1.0));
            jPanel2.add((Component)this.getChkInstallScannerRules(), LayoutHelper.getGBC(0, 2, 1, 1.0));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.options.new.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            jPanel3.add((Component)this.getChkReportReleaseAddons(), LayoutHelper.getGBC(0, 0, 1, 1.0));
            jPanel3.add((Component)this.getChkReportBetaAddons(), LayoutHelper.getGBC(0, 1, 1, 1.0));
            jPanel3.add((Component)this.getChkReportAlphaAddons(), LayoutHelper.getGBC(0, 2, 1, 1.0));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.options.dir.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            jPanel4.add((Component)new CfuDirsOptionsPanel(this.getScriptDirModel()), LayoutHelper.getGBC(0, 0, 2, 1.0, 1.0));
            JLabel jLabel = new JLabel(Constant.messages.getString("cfu.options.downloaddir.label"));
            jLabel.setLabelFor(this.getDownloadDirCombo());
            jPanel4.add((Component)jLabel, LayoutHelper.getGBC(0, 1, 1, 0.5));
            jPanel4.add(this.getDownloadDirCombo(), LayoutHelper.getGBC(1, 1, 1, 0.5));
            this.panelMisc.add((Component)this.getChkCheckOnStart(), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelMisc.add((Component)jPanel, LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelMisc.add((Component)jPanel2, LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelMisc.add((Component)jPanel3, LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelMisc.add((Component)jPanel4, LayoutHelper.getGBC(0, 4, 1, 1.0, 1.0));
        }
        return this.panelMisc;
    }

    private void setCheckBoxStates() {
        if (this.chkCheckOnStart.isSelected()) {
            this.getChkDownloadNewRelease().setEnabled(!Constant.isKali());
            this.getChkCheckAddonUpdates().setEnabled(true);
            this.getChkInstallAddonUpdates().setEnabled(this.getChkCheckAddonUpdates().isSelected());
            this.getChkInstallScannerRules().setEnabled(this.getChkCheckAddonUpdates().isSelected());
            this.getChkReportReleaseAddons().setEnabled(true);
            this.getChkReportBetaAddons().setEnabled(this.getChkReportReleaseAddons().isSelected());
            this.getChkReportAlphaAddons().setEnabled(this.getChkReportReleaseAddons().isSelected() && this.getChkReportBetaAddons().isSelected());
        } else {
            this.getChkDownloadNewRelease().setEnabled(false);
            this.getChkCheckAddonUpdates().setEnabled(false);
            this.getChkInstallAddonUpdates().setEnabled(false);
            this.getChkInstallScannerRules().setEnabled(false);
            this.getChkReportReleaseAddons().setEnabled(false);
            this.getChkReportBetaAddons().setEnabled(false);
            this.getChkReportAlphaAddons().setEnabled(false);
        }
    }

    private JCheckBox getChkCheckOnStart() {
        if (this.chkCheckOnStart == null) {
            this.chkCheckOnStart = new JCheckBox();
            this.chkCheckOnStart.setText(Constant.messages.getString("cfu.options.startUp"));
            this.chkCheckOnStart.setVerticalAlignment(1);
            this.chkCheckOnStart.setVerticalTextPosition(1);
            this.chkCheckOnStart.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsCheckForUpdatesPanel.this.setCheckBoxStates();
                }
            });
        }
        return this.chkCheckOnStart;
    }

    private JCheckBox getChkDownloadNewRelease() {
        if (this.chkDownloadNewRelease == null) {
            this.chkDownloadNewRelease = new JCheckBox();
            this.chkDownloadNewRelease.setText(Constant.messages.getString("cfu.options.downloadNewRelease"));
            this.chkDownloadNewRelease.setVerticalAlignment(1);
            this.chkDownloadNewRelease.setVerticalTextPosition(1);
            if (Constant.isKali()) {
                this.chkDownloadNewRelease.setText(Constant.messages.getString("cfu.options.downloadNewRelease.kali"));
            }
        }
        return this.chkDownloadNewRelease;
    }

    private JCheckBox getChkCheckAddonUpdates() {
        if (this.chkCheckAddonUpdates == null) {
            this.chkCheckAddonUpdates = new JCheckBox();
            this.chkCheckAddonUpdates.setText(Constant.messages.getString("cfu.options.checkAddonUpdates"));
            this.chkCheckAddonUpdates.setVerticalAlignment(1);
            this.chkCheckAddonUpdates.setVerticalTextPosition(1);
            this.chkCheckAddonUpdates.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsCheckForUpdatesPanel.this.setCheckBoxStates();
                }
            });
        }
        return this.chkCheckAddonUpdates;
    }

    private JCheckBox getChkInstallAddonUpdates() {
        if (this.chkInstallAddonUpdates == null) {
            this.chkInstallAddonUpdates = new JCheckBox();
            this.chkInstallAddonUpdates.setText(Constant.messages.getString("cfu.options.installAddonUpdates"));
            this.chkInstallAddonUpdates.setVerticalAlignment(1);
            this.chkInstallAddonUpdates.setVerticalTextPosition(1);
        }
        return this.chkInstallAddonUpdates;
    }

    private JCheckBox getChkInstallScannerRules() {
        if (this.chkInstallScannerRules == null) {
            this.chkInstallScannerRules = new JCheckBox();
            this.chkInstallScannerRules.setText(Constant.messages.getString("cfu.options.installScannerRules"));
            this.chkInstallScannerRules.setVerticalAlignment(1);
            this.chkInstallScannerRules.setVerticalTextPosition(1);
        }
        return this.chkInstallScannerRules;
    }

    private JCheckBox getChkReportReleaseAddons() {
        if (this.chkReportReleaseAddons == null) {
            this.chkReportReleaseAddons = new JCheckBox();
            this.chkReportReleaseAddons.setText(Constant.messages.getString("cfu.options.reportReleaseAddons"));
            this.chkReportReleaseAddons.setVerticalAlignment(1);
            this.chkReportReleaseAddons.setVerticalTextPosition(1);
            this.chkReportReleaseAddons.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsCheckForUpdatesPanel.this.setCheckBoxStates();
                }
            });
        }
        return this.chkReportReleaseAddons;
    }

    private JCheckBox getChkReportBetaAddons() {
        if (this.chkReportBetaAddons == null) {
            this.chkReportBetaAddons = new JCheckBox();
            this.chkReportBetaAddons.setText(Constant.messages.getString("cfu.options.reportBetaAddons"));
            this.chkReportBetaAddons.setVerticalAlignment(1);
            this.chkReportBetaAddons.setVerticalTextPosition(1);
            this.chkReportBetaAddons.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsCheckForUpdatesPanel.this.setCheckBoxStates();
                }
            });
        }
        return this.chkReportBetaAddons;
    }

    private JCheckBox getChkReportAlphaAddons() {
        if (this.chkReportAlphaAddons == null) {
            this.chkReportAlphaAddons = new JCheckBox();
            this.chkReportAlphaAddons.setText(Constant.messages.getString("cfu.options.reportAlphaAddons"));
            this.chkReportAlphaAddons.setVerticalAlignment(1);
            this.chkReportAlphaAddons.setVerticalTextPosition(1);
        }
        return this.chkReportAlphaAddons;
    }

    private OptionsAutoupdateDirsTableModel getScriptDirModel() {
        if (this.scriptDirModel == null) {
            this.scriptDirModel = new OptionsAutoupdateDirsTableModel();
            this.scriptDirModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    OptionsCheckForUpdatesPanel.this.repopulatDownloadDirs();
                }
            });
        }
        return this.scriptDirModel;
    }

    private JComboBox<String> getDownloadDirCombo() {
        if (this.downloadDir == null) {
            this.downloadDir = new JComboBox();
            this.repopulatDownloadDirs();
        }
        return this.downloadDir;
    }

    private void repopulatDownloadDirs() {
        Object object = this.getDownloadDirCombo().getSelectedItem();
        this.getDownloadDirCombo().removeAllItems();
        this.downloadDir.addItem(Constant.FOLDER_LOCAL_PLUGIN);
        for (File file : this.getScriptDirModel().getElements()) {
            if (!file.canWrite()) continue;
            this.downloadDir.addItem(file.getAbsolutePath());
        }
        this.getDownloadDirCombo().setSelectedItem(object);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        this.getChkCheckOnStart().setSelected(optionsParam.getCheckForUpdatesParam().isCheckOnStart());
        this.getChkDownloadNewRelease().setSelected(optionsParam.getCheckForUpdatesParam().isDownloadNewRelease());
        this.getChkCheckAddonUpdates().setSelected(optionsParam.getCheckForUpdatesParam().isCheckAddonUpdates());
        this.getChkInstallAddonUpdates().setSelected(optionsParam.getCheckForUpdatesParam().isInstallAddonUpdates());
        this.getChkInstallScannerRules().setSelected(optionsParam.getCheckForUpdatesParam().isInstallScannerRules());
        this.getChkReportReleaseAddons().setSelected(optionsParam.getCheckForUpdatesParam().isReportReleaseAddons());
        this.getChkReportBetaAddons().setSelected(optionsParam.getCheckForUpdatesParam().isReportBetaAddons());
        this.getChkReportAlphaAddons().setSelected(optionsParam.getCheckForUpdatesParam().isReportAlphaAddons());
        this.getScriptDirModel().setFiles(optionsParam.getCheckForUpdatesParam().getAddonDirectories());
        this.getDownloadDirCombo().setSelectedItem(optionsParam.getCheckForUpdatesParam().getDownloadDirectory().getAbsolutePath());
        this.setCheckBoxStates();
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        optionsParam.getCheckForUpdatesParam().setCheckOnStart(this.getChkCheckOnStart().isSelected());
        optionsParam.getCheckForUpdatesParam().setDownloadNewRelease(this.getChkDownloadNewRelease().isSelected());
        optionsParam.getCheckForUpdatesParam().setCheckAddonUpdates(this.getChkCheckAddonUpdates().isSelected());
        optionsParam.getCheckForUpdatesParam().setInstallAddonUpdates(this.getChkInstallAddonUpdates().isSelected());
        optionsParam.getCheckForUpdatesParam().setInstallScannerRules(this.getChkInstallScannerRules().isSelected());
        optionsParam.getCheckForUpdatesParam().setReportReleaseAddons(this.getChkReportReleaseAddons().isSelected());
        optionsParam.getCheckForUpdatesParam().setReportBetaAddons(this.getChkReportBetaAddons().isSelected());
        optionsParam.getCheckForUpdatesParam().setReportAlphaAddons(this.getChkReportAlphaAddons().isSelected());
        optionsParam.getCheckForUpdatesParam().setAddonDirectories(this.getScriptDirModel().getElements());
        optionsParam.getCheckForUpdatesParam().setDownloadDirectory(new File(this.getDownloadDirCombo().getSelectedItem().toString()));
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.checkforupdates";
    }

    private static class CfuDirsOptionsPanel
    extends AbstractMultipleOptionsBaseTablePanel<File> {
        private static final long serialVersionUID = 1L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("cfu.options.dialog.dirs.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("cfu.options.dialog.dirs.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("cfu.options.dialog.dirs.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("cfu.options.dialog.dirs.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("cfu.options.dialog.dirs.remove.checkbox.label");

        public CfuDirsOptionsPanel(OptionsAutoupdateDirsTableModel optionsAutoupdateDirsTableModel) {
            super(optionsAutoupdateDirsTableModel);
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
        }

        @Override
        public File showAddDialogue() {
            return this.showDirSelectDialog(null);
        }

        @Override
        public File showModifyDialogue(File file) {
            return this.showDirSelectDialog(file);
        }

        private File showDirSelectDialog(File file) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(this) == 0) {
                return jFileChooser.getSelectedFile();
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(File file) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

