/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import java.net.HttpCookie;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;

public class CookieBasedSessionManagementHelper {
    private static final Logger log = Logger.getLogger(CookieBasedSessionManagementHelper.class);

    public static void processMessageToMatchSession(HttpMessage httpMessage, HttpSession httpSession) {
        CookieBasedSessionManagementHelper.processMessageToMatchSession(httpMessage, httpMessage.getRequestHeader().getHttpCookies(), httpSession);
    }

    public static void processMessageToMatchSession(HttpMessage httpMessage, List<HttpCookie> list, HttpSession httpSession) {
        String string;
        HttpSessionTokensSet httpSessionTokensSet = httpSession.getTokensNames();
        if (httpSessionTokensSet == null) {
            httpSessionTokensSet = new HttpSessionTokensSet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(httpSessionTokensSet.getTokensSet());
        Iterator<HttpCookie> iterator = list.iterator();
        while (iterator.hasNext()) {
            HttpCookie httpCookie = iterator.next();
            String string2 = httpCookie.getName();
            if (!httpSessionTokensSet.isSessionToken(string2)) continue;
            string = httpSession.getTokenValue(string2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Changing value of token '" + string2 + "' to: " + string));
            }
            if (string != null) {
                httpCookie.setValue(string);
            } else {
                iterator.remove();
            }
            linkedHashSet.remove(string2);
        }
        for (String string2 : linkedHashSet) {
            string = httpSession.getTokenValue(string2);
            if (string == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding token '" + string2 + " with value: " + string));
            }
            HttpCookie httpCookie = new HttpCookie(string2, string);
            list.add(httpCookie);
        }
        httpMessage.setHttpSession(httpSession);
        httpMessage.getRequestHeader().setCookies(list);
    }

    public static HttpSession getMatchingHttpSession(Collection<HttpSession> collection, List<HttpCookie> list, HttpSessionTokensSet httpSessionTokensSet) {
        if (collection.isEmpty()) {
            return null;
        }
        LinkedList<HttpSession> linkedList = new LinkedList<HttpSession>(collection);
        for (String string : httpSessionTokensSet.getTokensSet()) {
            HttpCookie httpCookie = null;
            for (HttpCookie httpCookie2 : list) {
                if (!httpCookie2.getName().equals(string)) continue;
                httpCookie = httpCookie2;
                break;
            }
            Iterator<HttpCookie> iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (((HttpSession)((Object)iterator.next())).matchesToken(string, httpCookie)) continue;
                iterator.remove();
            }
        }
        if (linkedList.size() >= 1) {
            if (linkedList.size() > 1) {
                log.warn((Object)"Multiple sessions matching the cookies from response. Using first one.");
            }
            return (HttpSession)linkedList.get(0);
        }
        return null;
    }
}

