/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.TabbedPanel2;

public class TabbedPanelTab
extends JPanel {
    private static final Icon CLOSE_TAB_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/cross-small-grey.png")));
    private static final Icon CLOSE_TAB_RED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/cross-small-red.png")));
    private static final Icon PIN_TAB_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-grey.png")));
    private static final Icon PIN_TAB_LIGHT_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-ltgrey.png")));
    private static final Icon PIN_TAB_RED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-red.png")));
    private static final long serialVersionUID = 1L;
    private JButton btnPin = new JButton();
    private JButton btnClose = new JButton();
    private AbstractPanel ap = null;

    public TabbedPanelTab(final TabbedPanel2 tabbedPanel2, String string, Icon icon, final Component component, boolean bl, boolean bl2) {
        super(new FlowLayout(1, 0, 0));
        this.setOpaque(false);
        if (!Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames()) {
            string = "";
        }
        if (component.getName() == null) {
            component.setName(string);
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setIcon(icon);
        this.add(jLabel);
        if (bl) {
            ActionListener actionListener;
            if (component instanceof AbstractPanel) {
                this.ap = (AbstractPanel)component;
                this.ap.setPinned(bl2);
                this.btnPin.setOpaque(false);
                this.btnPin.setRolloverEnabled(true);
                this.btnPin.setToolTipText(Constant.messages.getString("all.button.pin"));
                this.btnPin.setContentAreaFilled(false);
                if (this.ap.isPinned()) {
                    this.btnPin.setIcon(PIN_TAB_GREY_ICON);
                    this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
                } else {
                    this.btnPin.setIcon(PIN_TAB_LIGHT_GREY_ICON);
                    this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
                }
                this.btnPin.setBorder(new EmptyBorder(0, 6, 0, 0));
                this.btnPin.setBorderPainted(false);
                this.btnPin.setFocusable(false);
                this.btnPin.setEnabled(false);
                this.btnPin.setVisible(false);
                actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TabbedPanelTab.this.setPinned(!TabbedPanelTab.this.ap.isPinned());
                        tabbedPanel2.saveTabState(TabbedPanelTab.this.ap);
                    }
                };
                this.btnPin.addActionListener(actionListener);
                this.add(this.btnPin);
            }
            this.btnClose.setOpaque(false);
            this.btnClose.setRolloverIcon(CLOSE_TAB_RED_ICON);
            this.btnClose.setRolloverEnabled(true);
            this.btnClose.setContentAreaFilled(false);
            this.btnClose.setToolTipText(Constant.messages.getString("all.button.close"));
            this.btnClose.setIcon(CLOSE_TAB_GREY_ICON);
            this.btnClose.setBorder(new EmptyBorder(0, 6, 0, 0));
            this.btnClose.setBorderPainted(false);
            this.btnClose.setFocusable(false);
            this.btnClose.setEnabled(false);
            this.btnClose.setVisible(false);
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    tabbedPanel2.setVisible(component, false);
                }
            };
            this.btnClose.addActionListener(actionListener);
            this.add(this.btnClose);
        }
    }

    public void setPinned(boolean bl) {
        if (this.ap == null) {
            return;
        }
        this.ap.setPinned(bl);
        if (this.ap.isPinned()) {
            this.btnPin.setIcon(PIN_TAB_GREY_ICON);
            this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
            this.btnPin.setToolTipText(Constant.messages.getString("all.button.unpin"));
        } else {
            this.btnPin.setIcon(PIN_TAB_LIGHT_GREY_ICON);
            this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
            this.btnPin.setToolTipText(Constant.messages.getString("all.button.pin"));
        }
        this.btnClose.setEnabled(!this.ap.isPinned());
        this.btnClose.setVisible(!this.ap.isPinned());
    }

    public void setLocked(boolean bl) {
        if (this.ap == null) {
            return;
        }
        this.ap.setLocked(bl);
        this.btnPin.setVisible(!bl);
        if (!this.ap.isPinned()) {
            this.btnClose.setVisible(!bl);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.ap != null && this.ap.isLocked()) {
            return;
        }
        this.btnPin.setEnabled(bl);
        this.btnPin.setVisible(bl);
        if (this.ap == null || !this.ap.isPinned()) {
            this.btnClose.setEnabled(bl);
            this.btnClose.setVisible(bl);
        }
    }

    protected AbstractPanel getAbstractPanel() {
        return this.ap;
    }
}

