#ifndef EFL_CONTAINER_EO_HH
#define EFL_CONTAINER_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_container.eo.h"
#include "efl_gfx.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_gfx.eo.hh"
namespace efl { 
struct Container;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Container> : ::std::true_type {}; } }
namespace efl { 
struct Container;
} 
namespace efl { 
struct Gfx;
} 

namespace eo_cxx {
namespace efl { 
struct Container {
   ::efl::eolian::return_traits< ::efl::Gfx>::type content_get() const;
   ::efl::eolian::return_traits<bool>::type content_set( ::efl::eolian::in_traits< ::efl::Gfx>::type content) const;
   ::efl::eolian::return_traits< ::efl::Gfx>::type content_unset() const;
   ::efl::eolian::return_traits<bool>::type content_remove( ::efl::eolian::in_traits< ::efl::Gfx>::type content) const;
   ::efl::eolian::return_traits< ::efl::eina::iterator< ::efl::Gfx>>::type content_iterate() const;
   ::efl::eolian::return_traits<int>::type content_count() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_CONTAINER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Container() const;
   operator ::efl::Container&();
   operator ::efl::Container const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Container,  ::efl::Gfx> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Container const ,  ::efl::Gfx const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Container : ::efl::eo::concrete
   , EO_CXX_INHERIT( ::efl::Gfx)
{
   explicit Container( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Container(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Container(Container const& other) = default;
   Container(Container&& other) = default;
   Container& operator=(Container const& other) = default;
   Container& operator=(Container&& other) = default;
   Container()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Container( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Container(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits< ::efl::Gfx>::type content_get() const;
   ::efl::eolian::return_traits<bool>::type content_set( ::efl::eolian::in_traits< ::efl::Gfx>::type content) const;
   ::efl::eolian::return_traits< ::efl::Gfx>::type content_unset() const;
   ::efl::eolian::return_traits<bool>::type content_remove( ::efl::eolian::in_traits< ::efl::Gfx>::type content) const;
   ::efl::eolian::return_traits< ::efl::eina::iterator< ::efl::Gfx>>::type content_iterate() const;
   ::efl::eolian::return_traits<int>::type content_count() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_CONTAINER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct content_added_event
   {
      static Efl_Event_Description const* description()
      { return EFL_CONTAINER_EVENT_CONTENT_ADDED; }
      typedef  ::efl::Gfx parameter_type;
   } const content_added_event;
   static struct content_removed_event
   {
      static Efl_Event_Description const* description()
      { return EFL_CONTAINER_EVENT_CONTENT_REMOVED; }
      typedef  ::efl::Gfx parameter_type;
   } const content_removed_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Container,  ::efl::Gfx> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Container const ,  ::efl::Gfx const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Container) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Container>::value, "");
} 
#endif
