/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class LangSys {
    private int _lookupOrder;
    private int _reqFeatureIndex;
    private int _featureCount;
    private int[] _featureIndex;

    protected LangSys(DataInput dataInput) throws IOException {
        this._lookupOrder = dataInput.readUnsignedShort();
        this._reqFeatureIndex = dataInput.readUnsignedShort();
        this._featureCount = dataInput.readUnsignedShort();
        this._featureIndex = new int[this._featureCount];
        for (int i = 0; i < this._featureCount; ++i) {
            this._featureIndex[i] = dataInput.readUnsignedShort();
        }
    }

    public int getLookupOrder() {
        return this._lookupOrder;
    }

    public int getReqFeatureIndex() {
        return this._reqFeatureIndex;
    }

    public int getFeatureCount() {
        return this._featureCount;
    }

    public int getFeatureIndex(int n) {
        return this._featureIndex[n];
    }

    protected boolean isFeatureIndexed(int n) {
        for (int i = 0; i < this._featureCount; ++i) {
            if (this._featureIndex[i] != n) continue;
            return true;
        }
        return false;
    }
}

