/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.util.RunnableExecutor;
import com.jogamp.common.util.VersionNumber;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.media.opengl.GLProfile;
import jogamp.opengl.util.av.impl.FFMPEGMediaPlayer;
import jogamp.opengl.util.av.impl.FFMPEGNatives;
import jogamp.opengl.util.av.impl.FFMPEGStaticNatives;
import jogamp.opengl.util.av.impl.FFMPEGv08Natives;
import jogamp.opengl.util.av.impl.FFMPEGv09Natives;
import jogamp.opengl.util.av.impl.FFMPEGv10Natives;

class FFMPEGDynamicLibraryBundleInfo
implements DynamicLibraryBundleInfo {
    private static final boolean DEBUG = FFMPEGMediaPlayer.DEBUG || DynamicLibraryBundleInfo.DEBUG;
    private static final List<String> glueLibNames = new ArrayList<String>();
    private static final int symbolCount = 65;
    private static final String[] symbolNames = new String[]{"avutil_version", "avformat_version", "avcodec_version", "avresample_version", "swresample_version", "avcodec_register_all", "avcodec_close", "avcodec_string", "avcodec_find_decoder", "avcodec_open2", "avcodec_alloc_frame", "avcodec_get_frame_defaults", "avcodec_free_frame", "avcodec_default_get_buffer", "avcodec_default_release_buffer", "avcodec_default_get_buffer2", "avcodec_get_edge_width", "av_image_fill_linesizes", "avcodec_align_dimensions", "avcodec_align_dimensions2", "avcodec_flush_buffers", "av_init_packet", "av_new_packet", "av_destruct_packet", "av_free_packet", "avcodec_decode_audio4", "avcodec_decode_video2", "av_pix_fmt_descriptors", "av_frame_unref", "av_realloc", "av_free", "av_get_bits_per_pixel", "av_samples_get_buffer_size", "av_get_bytes_per_sample", "av_opt_set_int", "av_dict_get", "av_dict_count", "av_dict_set", "av_dict_free", "avformat_alloc_context", "avformat_free_context", "avformat_close_input", "av_register_all", "av_find_input_format", "avformat_open_input", "av_dump_format", "av_read_frame", "av_seek_frame", "avformat_seek_file", "av_read_play", "av_read_pause", "avformat_network_init", "avformat_network_deinit", "avformat_find_stream_info", "avdevice_register_all", "avresample_alloc_context", "avresample_open", "avresample_close", "avresample_free", "avresample_convert", "av_opt_set_sample_fmt", "swr_alloc", "swr_init", "swr_free", "swr_convert"};
    private static final String[] optionalSymbolNames = new String[]{"avformat_seek_file", "avcodec_free_frame", "av_frame_unref", "av_dict_count", "avcodec_default_get_buffer", "avcodec_default_release_buffer", "avcodec_default_get_buffer2", "avdevice_register_all", "avresample_version", "avresample_alloc_context", "avresample_open", "avresample_close", "avresample_free", "avresample_convert", "av_opt_set_sample_fmt", "swresample_version", "swr_alloc", "swr_init", "swr_free", "swr_convert"};
    private static final long[] symbolAddr = new long[65];
    private static final boolean ready;
    private static final boolean libsUFCLoaded;
    private static final boolean avresampleLoaded;
    private static final boolean swresampleLoaded;
    private static final boolean avdeviceLoaded;
    static final VersionNumber avCodecVersion;
    static final VersionNumber avFormatVersion;
    static final VersionNumber avUtilVersion;
    static final VersionNumber avResampleVersion;
    static final VersionNumber swResampleVersion;
    private static final FFMPEGNatives natives;
    private static final int LIB_IDX_UTI = 0;
    private static final int LIB_IDX_FMT = 1;
    private static final int LIB_IDX_COD = 2;
    private static final int LIB_IDX_DEV = 3;
    private static final int LIB_IDX_AVR = 4;
    private static final int LIB_IDX_SWR = 5;

    static boolean libsLoaded() {
        return libsUFCLoaded;
    }

    static boolean avDeviceLoaded() {
        return avdeviceLoaded;
    }

    static boolean avResampleLoaded() {
        return avresampleLoaded;
    }

    static boolean swResampleLoaded() {
        return swresampleLoaded;
    }

    static FFMPEGNatives getNatives() {
        return natives;
    }

    static boolean initSingleton() {
        return ready;
    }

    private static final boolean initSymbols(boolean[] blArray, VersionNumber[] versionNumberArray) {
        for (int i = 0; i < 6; ++i) {
            blArray[i] = false;
        }
        final DynamicLibraryBundle dynamicLibraryBundle = AccessController.doPrivileged(new PrivilegedAction<DynamicLibraryBundle>(){

            @Override
            public DynamicLibraryBundle run() {
                return new DynamicLibraryBundle((DynamicLibraryBundleInfo)new FFMPEGDynamicLibraryBundleInfo());
            }
        });
        dynamicLibraryBundle.toString();
        for (int i = 0; i < 6; ++i) {
            blArray[i] = dynamicLibraryBundle.isToolLibLoaded(i);
        }
        if (!(blArray[0] && blArray[1] && blArray[2])) {
            throw new RuntimeException("FFMPEG Tool library incomplete: [ avutil " + blArray[0] + ", avformat " + blArray[1] + ", avcodec " + blArray[2] + "]");
        }
        if (symbolNames.length != 65) {
            throw new InternalError("XXX0 " + symbolNames.length + " != " + 65);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(optionalSymbolNames));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (int i = 0; i < 65; ++i) {
                    symbolAddr[i] = dynamicLibraryBundle.dynamicLookupFunction(symbolNames[i]);
                }
                return null;
            }
        });
        boolean bl = true;
        for (int i = 0; i < 65; ++i) {
            if (0L != symbolAddr[i]) continue;
            String string = symbolNames[i];
            if (!hashSet.contains(string)) {
                System.err.println("Fail: Could not resolve symbol <" + symbolNames[i] + ">: not optional, no alternatives.");
                bl = false;
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("OK: Unresolved optional symbol <" + symbolNames[i] + ">");
        }
        versionNumberArray[0] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[0]));
        versionNumberArray[1] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[1]));
        versionNumberArray[2] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[2]));
        versionNumberArray[3] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[3]));
        versionNumberArray[4] = FFMPEGStaticNatives.getAVVersion(FFMPEGStaticNatives.getAvVersion0(symbolAddr[4]));
        return bl;
    }

    protected FFMPEGDynamicLibraryBundleInfo() {
    }

    public final boolean shallLinkGlobal() {
        return true;
    }

    public final boolean shallLookupGlobal() {
        return true;
    }

    public final List<String> getGlueLibNames() {
        return glueLibNames;
    }

    public final List<List<String>> getToolLibNames() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("avutil");
        arrayList2.add("libavutil.so.53");
        arrayList2.add("libavutil.so.52");
        arrayList2.add("libavutil.so.51");
        arrayList2.add("libavutil.so.50");
        arrayList2.add("avutil-53");
        arrayList2.add("avutil-52");
        arrayList2.add("avutil-51");
        arrayList2.add("avutil-50");
        arrayList.add(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("avformat");
        arrayList3.add("libavformat.so.56");
        arrayList3.add("libavformat.so.55");
        arrayList3.add("libavformat.so.54");
        arrayList3.add("libavformat.so.53");
        arrayList3.add("libavformat.so.52");
        arrayList3.add("avformat-56");
        arrayList3.add("avformat-55");
        arrayList3.add("avformat-54");
        arrayList3.add("avformat-53");
        arrayList3.add("avformat-52");
        arrayList.add(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("avcodec");
        arrayList4.add("libavcodec.so.56");
        arrayList4.add("libavcodec.so.55");
        arrayList4.add("libavcodec.so.54");
        arrayList4.add("libavcodec.so.53");
        arrayList4.add("libavcodec.so.52");
        arrayList4.add("avcodec-56");
        arrayList4.add("avcodec-55");
        arrayList4.add("avcodec-54");
        arrayList4.add("avcodec-53");
        arrayList4.add("avcodec-52");
        arrayList.add(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("avdevice");
        arrayList5.add("libavdevice.so.56");
        arrayList5.add("libavdevice.so.55");
        arrayList5.add("libavdevice.so.54");
        arrayList5.add("libavdevice.so.53");
        arrayList5.add("avdevice-56");
        arrayList5.add("avdevice-55");
        arrayList5.add("avdevice-54");
        arrayList5.add("avdevice-53");
        arrayList.add(arrayList5);
        ArrayList<String> arrayList6 = new ArrayList<String>();
        arrayList6.add("avresample");
        arrayList6.add("libavresample.so.2");
        arrayList6.add("libavresample.so.1");
        arrayList6.add("avresample-2");
        arrayList6.add("avresample-1");
        arrayList.add(arrayList6);
        ArrayList<String> arrayList7 = new ArrayList<String>();
        arrayList7.add("swresample");
        arrayList7.add("libswresample.so.1");
        arrayList7.add("libswresample.so.0");
        arrayList7.add("swresample-1");
        arrayList7.add("swresample-0");
        arrayList.add(arrayList7);
        return arrayList;
    }

    public final List<String> getToolGetProcAddressFuncNameList() {
        return null;
    }

    public final long toolGetProcAddress(long l, String string) {
        return 0L;
    }

    public final boolean useToolGetProcAdressFirst(String string) {
        return false;
    }

    public final RunnableExecutor getLibLoaderExecutor() {
        return DynamicLibraryBundle.getDefaultRunnableExecutor();
    }

    static {
        GLProfile.initSingleton();
        boolean bl = false;
        boolean[] blArray = new boolean[6];
        VersionNumber[] versionNumberArray = new VersionNumber[5];
        try {
            bl = FFMPEGDynamicLibraryBundleInfo.initSymbols(blArray, versionNumberArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        libsUFCLoaded = blArray[0] && blArray[1] && blArray[2];
        avdeviceLoaded = blArray[3];
        avresampleLoaded = blArray[4];
        swresampleLoaded = blArray[5];
        avUtilVersion = versionNumberArray[0];
        avFormatVersion = versionNumberArray[1];
        avCodecVersion = versionNumberArray[2];
        avResampleVersion = versionNumberArray[3];
        swResampleVersion = versionNumberArray[4];
        if (!libsUFCLoaded) {
            System.err.println("LIB_AV Not Available: lavu, lavc, lavu");
            natives = null;
            ready = false;
        } else if (!bl) {
            System.err.println("LIB_AV Not Matching");
            natives = null;
            ready = false;
        } else {
            if (avCodecVersion.getMajor() == 53 && avFormatVersion.getMajor() == 53 && avUtilVersion.getMajor() == 51) {
                natives = new FFMPEGv08Natives();
            } else if (avCodecVersion.getMajor() == 54 && avFormatVersion.getMajor() == 54 && avUtilVersion.getMajor() == 52) {
                natives = new FFMPEGv09Natives();
            } else if (avCodecVersion.getMajor() == 55 && avFormatVersion.getMajor() == 55 && avUtilVersion.getMajor() == 52) {
                natives = new FFMPEGv10Natives();
            } else {
                System.err.println("LIB_AV No Version/Native-Impl Match");
                natives = null;
            }
            ready = null != natives && FFMPEGStaticNatives.initIDs0() ? natives.initSymbols0(symbolAddr, 65) : false;
        }
    }
}

