/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.languagetool.JLanguageTool;

class UndoRedoSupport {
    final UndoAction undoAction;
    final RedoAction redoAction;
    private final UndoManager undoManager;
    private final ResourceBundle messages;
    private boolean compoundMode = false;
    private CompoundEdit ce = null;

    UndoRedoSupport(JTextComponent textComponent, ResourceBundle messages) {
        this.messages = messages;
        this.undoManager = new UndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        textComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                if (UndoRedoSupport.this.compoundMode) {
                    UndoRedoSupport.this.ce.addEdit(e.getEdit());
                } else {
                    UndoRedoSupport.this.undoManager.addEdit(e.getEdit());
                }
                UndoRedoSupport.this.undoAction.updateUndoState();
                UndoRedoSupport.this.redoAction.updateRedoState();
            }
        });
        InputMap inputMap = textComponent.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "undo");
        textComponent.getActionMap().put("undo", this.undoAction);
        key = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
        inputMap.put(key, "redo");
        textComponent.getActionMap().put("redo", this.redoAction);
    }

    void startCompoundEdit() {
        if (this.compoundMode) {
            throw new RuntimeException("already in compound mode");
        }
        this.ce = new CompoundEdit();
        this.compoundMode = true;
    }

    void endCompoundEdit() {
        if (!this.compoundMode) {
            throw new RuntimeException("not in compound mode");
        }
        this.ce.end();
        this.undoManager.addEdit(this.ce);
        this.ce = null;
        this.compoundMode = false;
    }

    class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super(UndoRedoSupport.this.messages.getString("guiRedo"));
            Image img = Toolkit.getDefaultToolkit().getImage(JLanguageTool.getDataBroker().getFromResourceDirAsUrl("sc_redo.png"));
            this.putValue("SmallIcon", new ImageIcon(img));
            img = Toolkit.getDefaultToolkit().getImage(JLanguageTool.getDataBroker().getFromResourceDirAsUrl("lc_redo.png"));
            this.putValue("SwingLargeIconKey", new ImageIcon(img));
            KeyStroke key = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
            this.putValue("AcceleratorKey", key);
            this.putValue("MnemonicKey", 82);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoSupport.this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            UndoRedoSupport.this.undoAction.updateUndoState();
        }

        private void updateRedoState() {
            if (UndoRedoSupport.this.undoManager.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super(UndoRedoSupport.this.messages.getString("guiUndo"));
            Image img = Toolkit.getDefaultToolkit().getImage(JLanguageTool.getDataBroker().getFromResourceDirAsUrl("sc_undo.png"));
            this.putValue("SmallIcon", new ImageIcon(img));
            img = Toolkit.getDefaultToolkit().getImage(JLanguageTool.getDataBroker().getFromResourceDirAsUrl("lc_undo.png"));
            this.putValue("SwingLargeIconKey", new ImageIcon(img));
            KeyStroke key = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.putValue("AcceleratorKey", key);
            this.putValue("MnemonicKey", 85);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoSupport.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            UndoRedoSupport.this.redoAction.updateRedoState();
        }

        private void updateUndoState() {
            if (UndoRedoSupport.this.undoManager.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

