/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.util.InsufficientTrainingDataException;

public class OnePassRealValueDataIndexer
extends OnePassDataIndexer {
    float[][] values;

    @Override
    public float[][] getValues() {
        return this.values;
    }

    @Override
    protected int sortAndMerge(List<ComparableEvent> eventsToCompare, boolean sort) throws InsufficientTrainingDataException {
        int numUniqueEvents = super.sortAndMerge(eventsToCompare, sort);
        this.values = new float[numUniqueEvents][];
        int numEvents = eventsToCompare.size();
        int j = 0;
        for (int i = 0; i < numEvents; ++i) {
            ComparableEvent evt = eventsToCompare.get(i);
            if (null == evt) continue;
            this.values[j++] = evt.values;
        }
        return numUniqueEvents;
    }

    @Override
    protected List<ComparableEvent> index(List<Event> events, Map<String, Integer> predicateIndex) {
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int numEvents = events.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        for (Event ev : events) {
            int ocID;
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons, ev.getValues());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.clear();
        }
        this.outcomeLabels = OnePassRealValueDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassRealValueDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

