/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    short[][] data;

    public ShortLookupTable(int offset, short[][] data) {
        super(offset, data.length);
        this.numComponents = data.length;
        this.numEntries = data[0].length;
        this.data = new short[this.numComponents][];
        for (int i = 0; i < this.numComponents; ++i) {
            this.data[i] = data[i];
        }
    }

    public ShortLookupTable(int offset, short[] data) {
        super(offset, data.length);
        this.numComponents = 1;
        this.numEntries = data.length;
        this.data = new short[1][];
        this.data[0] = data;
    }

    public final short[][] getTable() {
        return this.data;
    }

    @Override
    public int[] lookupPixel(int[] src, int[] dst) {
        if (dst == null) {
            dst = new int[src.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < src.length; ++i) {
                int s = (src[i] & 0xFFFF) - this.offset;
                if (s < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                dst[i] = this.data[0][s];
            }
        } else {
            for (int i = 0; i < src.length; ++i) {
                int s = (src[i] & 0xFFFF) - this.offset;
                if (s < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                dst[i] = this.data[i][s];
            }
        }
        return dst;
    }

    public short[] lookupPixel(short[] src, short[] dst) {
        if (dst == null) {
            dst = new short[src.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < src.length; ++i) {
                int s = (src[i] & 0xFFFF) - this.offset;
                if (s < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                dst[i] = this.data[0][s];
            }
        } else {
            for (int i = 0; i < src.length; ++i) {
                int s = (src[i] & 0xFFFF) - this.offset;
                if (s < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                dst[i] = this.data[i][s];
            }
        }
        return dst;
    }
}

