/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.java.BS;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSlicer;
import org.jmol.util.TempArray;
import org.jmol.viewer.Viewer;

public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public static final int P_CHECK = 3;
    public static final int P_CONTOUR = 4;
    public static final int P_EXPLICIT_COLOR = 4;
    public Viewer vwr;
    private MeshSlicer slicer;
    public V3[] spanningVectors;
    public String meshType;
    public int vc;
    public T3[] vs;
    public float[] vvs;
    public int[] vertexSource;
    public BS surfaceAtoms;
    public int pc;
    public int[][] pis;
    public boolean colorsExplicit;
    public boolean isDrawPolygon;
    public boolean haveQuads;
    public short colix;
    public short colixBack;
    public boolean isColorSolid = true;
    public P3 offset;
    public T3[] altVertices;
    public short[] pcs;
    public short[] vcs;
    public T3[] normals;
    public V3[] normalsTemp;
    public int normalCount;
    public int normixCount;
    public BS bsPolygons;
    public M4 mat4;
    public BS[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public boolean dataOnly;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;
    public int polygonCount0;
    public int vertexCount0;
    public BS bsSlabDisplay;
    public BS bsSlabGhost;
    public int slabMeshType;
    public short slabColix;
    public BS bsDisplay;
    public SB slabOptions;
    public int mergeVertexCount0;
    public int mergePolygonCount0;
    public boolean isMerged;

    public MeshSlicer getMeshSlicer() {
        return this.slicer == null ? (this.slicer = ((MeshSlicer)Interface.getInterface("org.jmol.util.MeshSlicer", this.vwr, "script")).set(this)) : this.slicer;
    }

    public static MeshSurface newMesh(boolean isAlt, T3[] vertices, int vertexCount, int[][] polygonIndexes, T3[] normals, int nNormals) {
        MeshSurface ms = new MeshSurface();
        ms.pis = polygonIndexes;
        if (isAlt) {
            ms.altVertices = vertices;
        } else {
            ms.vs = vertices;
        }
        ms.vc = vertexCount == 0 ? vertices.length : vertexCount;
        ms.normals = normals;
        ms.normalCount = nNormals == 0 && normals != null ? normals.length : nNormals;
        return ms;
    }

    public T3[] getVertices() {
        return this.altVertices == null ? this.vs : this.altVertices;
    }

    public int[][] getFaces() {
        return this.pis;
    }

    public void setColix(short colix) {
        this.colix = colix;
    }

    public void setColixBack(short colix) {
        this.colixBack = colix;
    }

    public int addV(T3 vertex, boolean asCopy) {
        if (this.vc == 0) {
            this.vs = new T3[25];
        } else if (this.vc == this.vs.length) {
            this.vs = (T3[])AU.doubleLength(this.vs);
        }
        this.vs[this.vc] = asCopy ? P3.newP(vertex) : vertex;
        return this.vc++;
    }

    public void addTriangle(int vertexA, int vertexB, int vertexC) {
        this.addPolygon(new int[]{vertexA, vertexB, vertexC}, null);
    }

    public void addQuad(int vertexA, int vertexB, int vertexC, int vertexD) {
        this.haveQuads = true;
        this.addPolygon(new int[]{vertexA, vertexB, vertexC, vertexD}, null);
    }

    public void setPolygonCount(int polygonCount) {
        this.pc = polygonCount;
        if (polygonCount < 0) {
            return;
        }
        if (this.pis == null || polygonCount > this.pis.length) {
            this.pis = AU.newInt2(polygonCount);
        }
    }

    public int addVCVal(T3 vertex, float value, boolean asCopy) {
        if (this.vc == 0) {
            this.vvs = new float[25];
        } else if (this.vc >= this.vvs.length) {
            this.vvs = AU.doubleLengthF(this.vvs);
        }
        this.vvs[this.vc] = value;
        return this.addV(vertex, asCopy);
    }

    public int addTriangleCheck(int vertexA, int vertexB, int vertexC, int check, int iContour, int color) {
        return this.vs == null || this.vvs != null && (Float.isNaN(this.vvs[vertexA]) || Float.isNaN(this.vvs[vertexB]) || Float.isNaN(this.vvs[vertexC])) || Float.isNaN(this.vs[vertexA].x) || Float.isNaN(this.vs[vertexB].x) || Float.isNaN(this.vs[vertexC].x) ? -1 : this.addPolygonV3(vertexA, vertexB, vertexC, check, iContour, color, null);
    }

    int addPolygonV3(int vertexA, int vertexB, int vertexC, int check, int iContour, int color, BS bs) {
        return this.dataOnly ? this.addPolygon(new int[]{vertexA, vertexB, vertexC, check}, bs) : this.addPolygonC(new int[]{vertexA, vertexB, vertexC, check, iContour}, color, bs, iContour < 0);
    }

    protected int addPolygonC(int[] polygon, int color, BS bs, boolean isExplicit) {
        if (color != 0) {
            if (this.pcs == null || this.pc == 0) {
                this.lastColor = 0;
            }
            if (isExplicit) {
                this.colorsExplicit = true;
            } else {
                int n;
                if (this.pcs == null) {
                    this.pcs = new short[25];
                } else if (this.pc >= this.pcs.length) {
                    this.pcs = AU.doubleLengthShort(this.pcs);
                }
                if (isExplicit) {
                    n = 2047;
                } else if (color == this.lastColor) {
                    n = this.lastColix;
                } else {
                    this.lastColor = color;
                    short s = C.getColix(this.lastColor);
                    n = s;
                    this.lastColix = s;
                }
                this.pcs[this.pc] = n;
            }
        }
        return this.addPolygon(polygon, bs);
    }

    public int addPolygon(int[] polygon, BS bs) {
        int n = this.pc;
        if (n == 0) {
            this.pis = AU.newInt2(25);
        } else if (n == this.pis.length) {
            this.pis = (int[][])AU.doubleLength(this.pis);
        }
        if (bs != null) {
            bs.set(n);
        }
        this.pis[this.pc++] = polygon;
        return n;
    }

    public void invalidatePolygons() {
        int i = this.pc;
        while (--i >= this.mergePolygonCount0) {
            if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(i) || this.setABC(i) != null) continue;
            this.pis[i] = null;
        }
    }

    protected int[] setABC(int i) {
        if (!(this.bsSlabDisplay == null || this.bsSlabDisplay.get(i) || this.bsSlabGhost != null && this.bsSlabGhost.get(i))) {
            return null;
        }
        int[] polygon = this.pis[i];
        if (polygon == null || polygon.length < 3) {
            return null;
        }
        this.iA = polygon[0];
        this.iB = polygon[1];
        this.iC = polygon[2];
        return (int[])(this.vvs == null || !Float.isNaN(this.vvs[this.iA]) && !Float.isNaN(this.vvs[this.iB]) && !Float.isNaN(this.vvs[this.iC]) ? polygon : null);
    }

    public void setTranslucentVertices(BS bsVertices) {
    }

    public String getSlabColor() {
        return this.bsSlabGhost == null ? null : C.getHexCode(this.slabColix);
    }

    public String getSlabType() {
        return this.bsSlabGhost != null && this.slabMeshType == 1073742018 ? "mesh" : null;
    }

    public void resetSlab() {
        if (this.slicer != null) {
            this.slicer.slabPolygons(TempArray.getSlabObjectType(1073742333, null, false, null), false);
        }
    }

    public void slabPolygonsList(Lst<Object[]> slabInfo, boolean allowCap) {
        this.getMeshSlicer();
        for (int i = 0; i < slabInfo.size() && this.slicer.slabPolygons((Object[])slabInfo.get(i), allowCap); ++i) {
        }
    }

    protected void slabBrillouin(P3[] unitCellVectors) {
    }

    public float getResolution() {
        return 0.0f;
    }

    public static MeshSurface getSphereData(int lvl) {
        Geodesic.createGeodesic(lvl);
        int vertexCount = Geodesic.getVertexCount(lvl);
        short[] f = Geodesic.getFaceVertexes(lvl);
        int nFaces = f.length / 3;
        int[][] faces = AU.newInt2(nFaces);
        int fpt = 0;
        for (int i = 0; i < nFaces; ++i) {
            faces[i] = new int[]{f[fpt++], f[fpt++], f[fpt++]};
        }
        T3[] vectors = new V3[vertexCount];
        for (int i = 0; i < vertexCount; ++i) {
            vectors[i] = Geodesic.getVertexVector(i);
        }
        return MeshSurface.newMesh(true, vectors, 0, faces, vectors, 0);
    }

    public void setBox(P3 xyzMin, P3 xyzMax) {
        xyzMin.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        xyzMax.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        for (int i = 0; i < this.vc; ++i) {
            T3 p = this.vs[i];
            if (Float.isNaN(p.x)) continue;
            BoxInfo.addPoint(p, xyzMin, xyzMax, 0.0f);
        }
    }

    public void setBoundingBox(P3[] boundBoxPoints) {
    }

    public static float getSphericalInterpolationFraction(double r, double valueA, double valueB, double d) {
        double ra = Math.abs(r + valueA) / d;
        double rb = Math.abs(r + valueB) / d;
        double ra2 = ra * ra;
        double q = ra2 - rb * rb + 1.0;
        double p = 4.0 * ((r /= d) * r - ra2);
        double factor = ra < rb ? 1 : -1;
        return (float)((q + factor * Math.sqrt(q * q + p)) / 2.0);
    }
}

