/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es_MX extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora de \u00c1frica Central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e1ndar de Mosc\u00fa",
               "MSK",
               "Hora de verano de Mosc\u00fa",
               "MSD",
               "Hora de Mosc\u00fa",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e1ndar de Jap\u00f3n",
               "JST",
               "Hora de verano de Jap\u00f3n",
               "JDT",
               "Hora de Jap\u00f3n",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e1ndar de Pakist\u00e1n",
               "PKT",
               "Hora de verano de Pakist\u00e1n",
               "PKST",
               "Hora de Pakist\u00e1n",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Hora est\u00e1ndar de Taip\u00e9i",
               "CST",
               "Hora de verano de Taip\u00e9i",
               "CDT",
               "Hora de Taip\u00e9i",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e1ndar de Hovd",
               "HOVT",
               "Hora de verano de Hovd",
               "HOVST",
               "Hora de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e1ndar de Magad\u00e1n",
               "MAGT",
               "Hora de verano de Magad\u00e1n",
               "MAGST",
               "Hora de Magad\u00e1n",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e1ndar de Australia Centroccidental",
               "ACWST",
               "Hora de verano de Australia Centroccidental",
               "ACWDT",
               "Hora de Australia Centroccidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e1ndar de Europa Central",
               "\u2205\u2205\u2205",
               "Hora de verano de Europa Central",
               "\u2205\u2205\u2205",
               "Hora de Europa Central",
               "\u2205\u2205\u2205",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e1ndar de Sajal\u00edn",
               "SAKT",
               "Hora de verano de Sajal\u00edn",
               "SAKST",
               "Hora de Sajal\u00edn",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e1ndar de Paraguay",
               "PYT",
               "Hora de verano de Paraguay",
               "PYST",
               "Hora de Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malasia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e1ndar del este de Norteam\u00e9rica",
               "EST",
               "Hora de verano del este de Norteam\u00e9rica",
               "EDT",
               "Hora del este de Norteam\u00e9rica",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e1ndar de Lord Howe",
               "LHST",
               "Hora de verano de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "Hora de verano de Nueva Zelanda",
               "NZDT",
               "Hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora del Oc\u00e9ano \u00cdndico",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e1ndar de Yakutsk",
               "YAKT",
               "Hora de verano de Yakutsk",
               "YAKST",
               "Hora de Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Hora est\u00e1ndar de Mauricio",
               "MUT",
               "Hora de verano de Mauricio",
               "MUST",
               "Hora de Mauricio",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de \u00c1frica Oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Hora de las islas Salom\u00f3n",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de las Islas Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e1ndar de Europa del Este",
               "\u2205\u2205\u2205",
               "Hora de verano de Europa del Este",
               "\u2205\u2205\u2205",
               "Hora de Europa del Este",
               "\u2205\u2205\u2205",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e1ndar de Terranova",
               "NST",
               "Hora de verano de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Hora de Afganist\u00e1n",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e1ndar de Hong Kong",
               "HKT",
               "Hora de verano de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e1ndar de Argentina Occidental",
               "ART",
               "Hora de verano de Argentina Occidental",
               "ARST",
               "Hora de Argentina Occidental",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "Hora de verano del Atl\u00e1ntico",
               "ADT",
               "Hora del Atl\u00e1ntico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Hora de Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "PMST",
               "Hora de verano de San Pedro y Miquel\u00f3n",
               "PMDT",
               "Hora de San Pedro y Miquel\u00f3n",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hora de Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e1ndar de Ekaterimburgo",
               "YEKT",
               "Hora de verano de Ekaterimburgo",
               "YEKST",
               "Hora de Ekaterimburgo",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Hora de Maldivas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahit\u00ed",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e1ndar de Israel",
               "IST",
               "Hora de verano de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora de Indonesia Central",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis y Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora de Sud\u00e1frica",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Hora de las Esp\u00f3radas Ecuatoriales",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e1ndar de Uzbekist\u00e1n",
               "UZT",
               "Hora de verano de Uzbekist\u00e1n",
               "UZST",
               "Hora de Uzbekist\u00e1n",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e1ndar de Omsk",
               "OMST",
               "Hora de verano de Omsk",
               "OMSST",
               "Hora de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Hora de Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e1ndar de Uruguay",
               "UYT",
               "Hora de verano de Uruguay",
               "UYST",
               "Hora de Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Hora de Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e1ndar de Ul\u00e1n Bator",
               "ULAT",
               "Hora de verano de Ul\u00e1n Bator",
               "ULAST",
               "Hora de Ul\u00e1n Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e1ndar del centro de Norteam\u00e9rica",
               "CST",
               "Hora de verano del centro de Norteam\u00e9rica",
               "CDT",
               "Hora del centro de Norteam\u00e9rica",
               "CT",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Hora de la isla Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Hora est\u00e1ndar de las islas Malvinas",
               "FKT",
               "Hora de verano de las islas Malvinas",
               "FKST",
               "Hora de las islas Malvinas",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Hora est\u00e1ndar de Vanuatu",
               "VUT",
               "Hora de verano de Vanuatu",
               "VUST",
               "Hora de Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e1ndar de Novosibirsk",
               "NOVT",
               "Hora de verano de Novosibirsk",
               "NOVST",
               "Hora de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Hora de Singapur",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e1ndar de las Azores",
               "AZOT",
               "Hora de verano de las Azores",
               "AZOST",
               "Hora de las Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Hora est\u00e1ndar de Apia",
               "WSST",
               "Hora de verano de Apia",
               "WSDT",
               "Hora de Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Hora de But\u00e1n",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e1ndar de Krasnoyarsk",
               "KRAT",
               "Hora de verano de Krasnoyarsk",
               "KRAST",
               "Hora de Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de Kazajist\u00e1n Occidental",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Hora de la isla de Navidad",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e1ndar del Amazonas",
               "AMT",
               "Hora de verano del Amazonas",
               "AMST",
               "Hora del Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de Kazajist\u00e1n Oriental",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Hora est\u00e1ndar de Fiyi",
               "FJT",
               "Hora de verano de Fiyi",
               "FJST",
               "Hora de Fiyi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00f3n",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Hora de las islas Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Hora est\u00e1ndar de Chatham",
               "CHAST",
               "Hora de verano de Chatham",
               "CHADT",
               "Hora de Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e1ndar de Argentina",
               "ART",
               "Hora de verano de Argentina",
               "ARST",
               "Hora de Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Hora de la isla Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Hora de Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e1ndar de Haw\u00e1i-Aleutiano",
               "HAST",
               "Hora de verano de Haw\u00e1i-Aleutiano",
               "HADT",
               "Hora de Haw\u00e1i-Aleutiano",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e1ndar de Australia Central",
               "ACST",
               "Hora de verano de Australia Central",
               "ACDT",
               "Hora de Australia Central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edfico de Norteam\u00e9rica",
               "PST",
               "Hora de verano del Pac\u00edfico de Norteam\u00e9rica",
               "PDT",
               "Hora del Pac\u00edfico de Norteam\u00e9rica",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de las islas F\u00e9nix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e1ndar de Turkmenist\u00e1n",
               "TMT",
               "Hora de verano de Turkmenist\u00e1n",
               "TMST",
               "Hora de Turkmenist\u00e1n",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e1ndar de Europa Occidental",
               "\u2205\u2205\u2205",
               "Hora de verano de Europa Occidental",
               "\u2205\u2205\u2205",
               "Hora de Europa Occidental",
               "\u2205\u2205\u2205",
            };
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e1ndar de Cabo Verde",
               "CVT",
               "Hora de verano de Cabo Verde",
               "CVST",
               "Hora de Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Hora de las islas Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Hora de Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e1ndar de Samoa",
               "SST",
               "Hora de verano de Samoa",
               "SDT",
               "Hora de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Hora de Palaos",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Hora del Extremo Oriental de Europa",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e1ndar de Azerbaiy\u00e1n",
               "AZT",
               "Hora de verano de Azerbaiy\u00e1n",
               "AZST",
               "Hora de Azerbaiy\u00e1n",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edfico",
               "MST",
               "Hora de verano del Pac\u00edfico",
               "MDT",
               "Hora del Pac\u00edfico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e1ndar de Cuba",
               "CST",
               "Hora de verano de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e1ndar de \u00c1frica Occidental",
               "WAT",
               "Hora de verano de \u00c1frica Occidental",
               "WAST",
               "Hora de \u00c1frica Occidental",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Hora del meridiano de Greenwich",
               "\u2205\u2205\u2205",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e1ndar de Filipinas",
               "PHT",
               "Hora de verano de Filipinas",
               "PHST",
               "Hora de Filipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Hora de las Tierras Australes y Ant\u00e1rticas Francesas",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Georgia meridional",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Hora est\u00e1ndar de Nueva Caledonia",
               "NCT",
               "Hora de verano de Nueva Caledonia",
               "NCST",
               "Hora de Nueva Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Hora de Brun\u00e9i",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Hora est\u00e1ndar de Ir\u00e1n",
               "IRST",
               "Hora de verano de Ir\u00e1n",
               "IRDT",
               "Hora de Ir\u00e1n",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Hora est\u00e1ndar de la isla de Pascua",
               "EAST",
               "Hora de verano de la isla de Pascua",
               "EASST",
               "Hora de la isla de Pascua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora est\u00e1ndar del noroeste",
               "PST",
               "Hora de verano del noroeste",
               "PDT",
               "Hora del noroeste",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Hora de Tayikist\u00e1n",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Hora est\u00e1ndar de Tonga",
               "TOT",
               "Hora de verano de Tonga",
               "TOST",
               "Hora de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Hora est\u00e1ndar de Bangladesh",
               "BDT",
               "Hora de verano de Bangladesh",
               "BDST",
               "Hora de Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e1ndar de Per\u00fa",
               "PET",
               "Hora de verano de Per\u00fa",
               "PEST",
               "Hora de Per\u00fa",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e1ndar de Groenlandia Occidental",
               "WGT",
               "Hora de verano de Groenlandia Occidental",
               "WGST",
               "Hora de Groenlandia Occidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Hora de Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e1ndar de Groenlandia Oriental",
               "EGT",
               "Hora de verano de Groenlandia Oriental",
               "EGST",
               "Hora de Groenlandia Oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Hora est\u00e1ndar del Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de Indonesia Oriental",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e1ndar de Corea",
               "KST",
               "Hora de verano de Corea",
               "KDT",
               "Hora de Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e1ndar de Australia Occidental",
               "AWST",
               "Hora de verano de Australia Occidental",
               "AWDT",
               "Hora de Australia Occidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Hora de Kirguist\u00e1n",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de Indonesia Occidental",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e1ndar de Australia Oriental",
               "AEST",
               "Hora de verano de Australia Oriental",
               "AEDT",
               "Hora de Australia Oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guayana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e1ndar de Colombia",
               "COT",
               "Hora de verano de Colombia",
               "COST",
               "Hora de Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e1ndar de Chile",
               "CLT",
               "Hora de verano de Chile",
               "CLST",
               "Hora de Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de las islas Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e1ndar de la monta\u00f1a de Norteam\u00e9rica",
               "MST",
               "Hora de verano de la monta\u00f1a de Norteam\u00e9rica",
               "MDT",
               "Hora de la monta\u00f1a de Norteam\u00e9rica",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Hora de las islas Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e1ndar de Arabia",
               "AST",
               "Hora de verano de Arabia",
               "ADT",
               "Hora de Arabia",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e1ndar de Alaska",
               "AKST",
               "Hora de verano de Alaska",
               "AKDT",
               "Hora de Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e1ndar de Vladivostok",
               "VLAT",
               "Hora de verano de Vladivostok",
               "VLAST",
               "Hora de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Hora est\u00e1ndar de Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e1ndar de Irkutsk",
               "IRKT",
               "Hora de verano de Irkutsk",
               "IRKST",
               "Hora de Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e1ndar de Georgia",
               "GET",
               "Hora de verano de Georgia",
               "GEST",
               "Hora de Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Pap\u00faa Nueva Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e1ndar de Fernando de Noronha",
               "FNT",
               "Hora de verano de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e1ndar de Choybalsan",
               "CHOT",
               "Hora de verano de Choybalsan",
               "CHOST",
               "Hora de Choybalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e1ndar de Brasilia",
               "BRT",
               "Hora de verano de Brasilia",
               "BRST",
               "Hora de Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Hora est\u00e1ndar de China",
               "CST",
               "Hora de verano de China",
               "CDT",
               "Hora de China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e1ndar de Armenia",
               "AMT",
               "Hora de verano de Armenia",
               "AMST",
               "Hora de Armenia",
               "AMT",
            };
        final String[] India = new String[] {
               "Hora est\u00e1ndar de la India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Hora est\u00e1ndar de las islas Cook",
               "CKT",
               "Hora de verano media de las islas Cook",
               "CKHST",
               "Hora de las islas Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Hora del meridiano de Greenwich",
                    "\u2205\u2205\u2205",
                    "Hora de verano brit\u00e1nica",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hora del meridiano de Greenwich",
                    "\u2205\u2205\u2205",
                    "Hora de verano irlandesa",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
