/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ms extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Waktu Afrika Tengah",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Waktu Piawai Moscow",
               "MSK",
               "Waktu Musim Panas Moscow",
               "MSD",
               "Waktu Moscow",
               "MT",
            };
        final String[] Japan = new String[] {
               "Waktu Piawai Jepun",
               "JST",
               "Waktu Siang Jepun",
               "JDT",
               "Waktu Jepun",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Waktu Piawai Pakistan",
               "PKT",
               "Waktu Musim Panas Pakistan",
               "PKST",
               "Waktu Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Waktu Piawai Taipei",
               "CST",
               "Waktu Siang Taipei",
               "CDT",
               "Waktu Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Waktu Piawai Hovd",
               "HOVT",
               "Waktu Musim Panas Hovd",
               "HOVST",
               "Waktu Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Waktu Piawai Magadan",
               "MAGT",
               "Waktu Musim Panas Magadan",
               "MAGST",
               "Waktu Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waktu Piawai Barat Tengah Australia",
               "ACWST",
               "Waktu Siang Barat Tengah Australia",
               "ACWDT",
               "Waktu Barat Tengah Australia",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Waktu Piawai Eropah Tengah",
               "CET",
               "Waktu Musim Panas Eropah Tengah",
               "CEST",
               "Waktu Eropah Tengah",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Waktu Piawai Sakhalin",
               "SAKT",
               "Waktu Musim Panas Sakhalin",
               "SAKST",
               "Waktu Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Waktu Piawai Paraguay",
               "PYT",
               "Waktu Musim Panas Paraguay",
               "PYST",
               "Waktu Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Waktu Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Waktu Piawai Timur",
               "EST",
               "Waktu Siang Timur",
               "EDT",
               "Waktu Timur",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Waktu Piawai Lord Howe",
               "LHST",
               "Waktu Siang Lord Howe",
               "LHDT",
               "Waktu Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Waktu Piawai New Zealand",
               "NZST",
               "Waktu Siang New Zealand",
               "NZDT",
               "Waktu New Zealand",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Waktu Lautan Hindi",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Waktu Piawai Yakutsk",
               "YAKT",
               "Waktu Musim Panas Yakutsk",
               "YAKST",
               "Waktu Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Waktu Piawai Mauritius",
               "MUT",
               "Waktu Musim Panas Mauritius",
               "MUST",
               "Waktu Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waktu Afrika Timur",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Waktu Timor Timur",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Waktu Kepulauan Solomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Waktu Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Waktu Kepulauan Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Waktu Piawai Eropah Timur",
               "EET",
               "Waktu Musim Panas Eropah Timur",
               "EEST",
               "Waktu Eropah Timur",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Waktu Piawai Newfoundland",
               "NST",
               "Waktu Siang Newfoundland",
               "NDT",
               "Waktu Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Waktu Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Waktu Piawai Hong Kong",
               "HKT",
               "Waktu Musim Panas Hong Kong",
               "HKST",
               "Waktu Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Waktu Piawai Argentina Barat",
               "ART",
               "Waktu Musim Panas Argentina Barat",
               "ARST",
               "Waktu Argentina Barat",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Waktu Piawai Atlantik",
               "AST",
               "Waktu Siang Atlantik",
               "ADT",
               "Waktu Atlantik",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Waktu Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Waktu Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waktu Piawai Saint Pierre dan Miquelon",
               "PMST",
               "Waktu Siang Saint Pierre dan Miquelon",
               "PMDT",
               "Waktu Saint Pierre dan Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Waktu Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Waktu Piawai Yekaterinburg",
               "YEKT",
               "Waktu Musim Panas Yekaterinburg",
               "YEKST",
               "Waktu Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Waktu Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Waktu Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Waktu Piawai Israel",
               "IST",
               "Waktu Siang Israel",
               "IDT",
               "Waktu Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Waktu Indonesia Tengah",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Waktu Wallis dan Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Waktu Piawai Afrika Selatan",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Waktu Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Waktu Kepulauan Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Waktu Piawai Uzbekistan",
               "UZT",
               "Waktu Musim Panas Uzbekistan",
               "UZST",
               "Waktu Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Waktu Piawai Omsk",
               "OMST",
               "Waktu Musim Panas Omsk",
               "OMSST",
               "Waktu Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Waktu Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Waktu Piawai Uruguay",
               "UYT",
               "Waktu Musim Panas Uruguay",
               "UYST",
               "Waktu Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Waktu Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Waktu Piawai Ulan Bator",
               "ULAT",
               "Waktu Musim Panas Ulan Bator",
               "ULAST",
               "Waktu Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Waktu Piawai Pusat",
               "CST",
               "Waktu Siang Tengah",
               "CDT",
               "Waktu Pusat",
               "CT",
            };
        final String[] Truk = new String[] {
               "Waktu Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Waktu Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Waktu Pulau Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Waktu Piawai Kepulauan Falkland",
               "FKT",
               "Waktu Musim Panas Kepulauan Falkland",
               "FKST",
               "Waktu Kepulauan Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Waktu Piawai Vanuatu",
               "VUT",
               "Waktu Musim Panas Vanuatu",
               "VUST",
               "Waktu Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Waktu Piawai Novosibirsk",
               "NOVT",
               "Waktu Musim Panas Novosibirsk",
               "NOVST",
               "Waktu Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Waktu Piawai Singapura",
               "SGT",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Waktu Piawai Azores",
               "AZOT",
               "Waktu Musim Panas Azores",
               "AZOST",
               "Waktu Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Waktu Standard Apia",
               "WSST",
               "Waktu Siang Apia",
               "WSDT",
               "Waktu Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Waktu Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Waktu Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Waktu Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waktu Piawai Krasnoyarsk",
               "KRAT",
               "Waktu Musim Panas Krasnoyarsk",
               "KRAST",
               "Waktu Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waktu Kazakhstan Barat",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Waktu Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Waktu Pulau Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Waktu Piawai Amazon",
               "AMT",
               "Waktu Musim Panas Amazon",
               "AMST",
               "Waktu Amazon",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Waktu Kazakhstan Timur",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Waktu Piawai Fiji",
               "FJT",
               "Waktu Musim Panas Fiji",
               "FJST",
               "Waktu Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Waktu Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Waktu Kepulauan Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Waktu Piawai Chatham",
               "CHAST",
               "Waktu Siang Chatham",
               "CHADT",
               "Waktu Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Waktu Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Waktu Piawai Argentina",
               "ART",
               "Waktu Musim Panas Argentina",
               "ARST",
               "Waktu Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Waktu Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Waktu Piawai Petropavlovsk-Kamchatski",
               "PETT",
               "Waktu Musim Panas Petropavlovsk-Kamchatski",
               "PETST",
               "Waktu Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Waktu Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Waktu Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Waktu Pulau Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Waktu Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waktu Piawai Hawaii-Aleutian",
               "HAST",
               "Waktu Siang Hawaii-Aleutian",
               "HADT",
               "Waktu Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Waktu Piawai Australia Tengah",
               "ACST",
               "Waktu Siang Australia Tengah",
               "ACDT",
               "Waktu Australia Tengah",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Waktu Piawai Pasifik",
               "PST",
               "Waktu Siang Pasifik",
               "PDT",
               "Waktu Pasifik",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waktu Kepulauan Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Waktu Piawai Turkmenistan",
               "TMT",
               "Waktu Musim Panas Turkmenistan",
               "TMST",
               "Waktu Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Waktu Piawai Eropah Barat",
               "WET",
               "Waktu Musim Panas Eropah Barat",
               "WEST",
               "Waktu Eropah Barat",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Waktu Piawai Tanjung Verde",
               "CVT",
               "Waktu Musim Panas Tanjung Verde",
               "CVST",
               "Waktu Tanjung Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Waktu Kepulauan Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Waktu Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Waktu Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Waktu Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Waktu Piawai Samoa",
               "SST",
               "Waktu Musim Panas Samoa",
               "SDT",
               "Waktu Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Waktu Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Waktu Eropah ceruk timur",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Waktu Piawai Azerbaijan",
               "AZT",
               "Waktu Musim Panas Azerbaijan",
               "AZST",
               "Waktu Azerbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Waktu Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waktu Piawai Pasifik Mexico",
               "MST",
               "Waktu Siang Pasifik Mexico",
               "MDT",
               "Waktu Pasifik Mexico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Waktu Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Waktu Piawai Cuba",
               "CST",
               "Waktu Siang Cuba",
               "CDT",
               "Waktu Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Waktu Piawai Afrika Barat",
               "WAT",
               "Waktu Musim Panas Afrika Barat",
               "WAST",
               "Waktu Afrika Barat",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Waktu Min Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Waktu Piawai Filipina",
               "PHT",
               "Waktu Musim Panas Filipina",
               "PHST",
               "Waktu Filipina",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Waktu Perancis Selatan dan Antartika",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Waktu Georgia Selatan",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Waktu Piawai New Caledonia",
               "NCT",
               "Waktu Musim Panas New Caledonia",
               "NCST",
               "Waktu New Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Waktu Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Waktu Piawai Iran",
               "IRST",
               "Waktu Siang Iran",
               "IRDT",
               "Waktu Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Waktu Piawai Pulau Easter",
               "EAST",
               "Waktu Musim Panas Pulau Easter",
               "EASST",
               "Waktu Pulau Easter",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Waktu Piawai Barat Laut Mexico",
               "PST",
               "Waktu Siang Barat Laut Mexico",
               "PDT",
               "Waktu Barat Laut Mexico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Waktu Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Waktu Tajikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Waktu Piawai Tonga",
               "TOT",
               "Waktu Musim Panas Tonga",
               "TOST",
               "Waktu Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Waktu Piawai Bangladesh",
               "BDT",
               "Waktu Musim Panas Bangladesh",
               "BDST",
               "Waktu Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Waktu Piawai Peru",
               "PET",
               "Waktu Musim Panas Peru",
               "PEST",
               "Waktu Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Waktu Piawai Greenland Barat",
               "WGT",
               "Waktu Musim Panas Greenland Barat",
               "WGST",
               "Waktu Greenland Barat",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Waktu Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Waktu Piawai Greenland Timur",
               "EGT",
               "Waktu Musim Panas Greenland Timur",
               "EGST",
               "Waktu Greenland Timur",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Waktu Teluk",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waktu Indonesia Timur",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Waktu Piawai Korea",
               "KST",
               "Waktu Siang Korea",
               "KDT",
               "Waktu Korea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Waktu Piawai Australia Barat",
               "AWST",
               "Waktu Siang Australia Barat",
               "AWDT",
               "Waktu Australia Barat",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Waktu Kyrgystan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waktu Indonesia Barat",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Waktu Piawai Timur Australia",
               "AEST",
               "Waktu Siang Australia Timur",
               "AEDT",
               "Waktu Australia Timur",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Waktu Guyana Perancis",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Waktu Piawai Colombia",
               "COT",
               "Waktu Musim Panas Colombia",
               "COST",
               "Waktu Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Waktu Piawai Chile",
               "CLT",
               "Waktu Musim Panas Chile",
               "CLST",
               "Waktu Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waktu Kepulauan Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Waktu Piawai Pergunungan",
               "MST",
               "Waktu Hari Siang Pergunungan",
               "MDT",
               "Waktu Pergunungan",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Waktu Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Waktu Piawai Arab",
               "AST",
               "Waktu Siang Arab",
               "ADT",
               "Waktu Arab",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Waktu Piawai Alaska",
               "AKST",
               "Waktu Siang Alaska",
               "AKDT",
               "Waktu Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Waktu Piawai Vladivostok",
               "VLAT",
               "Waktu Musim Panas Vladivostok",
               "VLAST",
               "Waktu Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Waktu Piawai Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Waktu Piawai Irkutsk",
               "IRKT",
               "Waktu Musim Panas Irkutsk",
               "IRKST",
               "Waktu Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Waktu Piawai Georgia",
               "GET",
               "Waktu Musim Panas Georgia",
               "GEST",
               "Waktu Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Waktu Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waktu Papua New Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Waktu Piawai Fernando de Noronha",
               "FNT",
               "Waktu Musim Panas Fernando de Noronha",
               "FNST",
               "Waktu Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Waktu Piawai Choibalsan",
               "CHOT",
               "Waktu Musim Panas Choibalsan",
               "CHOST",
               "Waktu Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Waktu Piawai Brasilia",
               "BRT",
               "Waktu Musim Panas Brasilia",
               "BRST",
               "Waktu Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Waktu Piawai China",
               "CST",
               "Waktu Siang China",
               "CDT",
               "Waktu China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Waktu Piawai Armenia",
               "AMT",
               "Waktu Musim Panas Armenia",
               "AMST",
               "Waktu Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Waktu Piawai Samara",
               "SAMT",
               "Waktu Musim Panas Samara",
               "SAMST",
               "Waktu Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Waktu Piawai India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Waktu Piawai Kepulauan Cook",
               "CKT",
               "Waktu Musim Panas Separuh Kepulauan Cook",
               "CKHST",
               "Waktu Kepulauan Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Waktu Min Greenwich",
                    "GMT",
                    "Waktu Musim Panas British",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Waktu Min Greenwich",
                    "GMT",
                    "Waktu Musim Panas Ireland",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
