/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import groovy.lang.Closure;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.mapping.config.DatastoreEnvironment;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionCallback;
import org.grails.datastore.mapping.core.VoidSessionCallback;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.support.SpringSessionSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class DatastoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreUtils.class);
    private static final String DATASTORE_CONFIG_FLAT = "datastoreConfigFlat";
    private static final ThreadLocal<Map<Datastore, Set<Session>>> deferredCloseHolder = new NamedThreadLocal("Datastore Sessions registered for deferred close");
    private static final String DATASTORE_CONFIG = "datastoreConfig";

    public static Session getSession(Datastore datastore, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return DatastoreUtils.doGetSession(datastore, allowCreate);
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Could not open Datastore Session", (Throwable)ex);
        }
    }

    public static Session doGetSession(Datastore datastore, boolean allowCreate) {
        Session session;
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)datastore));
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                session = sessionHolder.getValidatedSession();
                if (session != null && !sessionHolder.isSynchronizedWithTransaction()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Registering Spring transaction synchronization for existing Datastore Session");
                    }
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, datastore, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                }
                if (session != null) {
                    return session;
                }
            } else {
                session = sessionHolder.getValidatedSession();
                if (session != null) {
                    return session;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Opening Datastore Session");
        }
        session = datastore.connect();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            SessionHolder holderToUse;
            if (logger.isDebugEnabled()) {
                logger.debug("Registering Spring transaction synchronization for new Datastore Session");
            }
            if ((holderToUse = sessionHolder) == null) {
                holderToUse = new SessionHolder(session);
            } else {
                holderToUse.addSession(session);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(holderToUse, datastore, true));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource((Object)datastore, (Object)((Object)holderToUse));
            }
        }
        if (!allowCreate && !DatastoreUtils.isSessionTransactional(session, datastore)) {
            DatastoreUtils.closeSession(session);
            throw new IllegalStateException("No Datastore Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return session;
    }

    public static boolean isSessionTransactional(Session session, Datastore datastore) {
        if (datastore == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)datastore));
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void closeSession(Session session) {
        if (session == null) {
            return;
        }
        logger.debug("Closing Datastore Session");
        try {
            session.disconnect();
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing Datastore Session", ex);
        }
    }

    public static void releaseSession(Session session, Datastore datastore) {
        if (session == null) {
            return;
        }
        if (!DatastoreUtils.isSessionTransactional(session, datastore)) {
            DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
        }
    }

    public static void processDeferredClose(Datastore datastore) {
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(datastore)) {
            throw new IllegalStateException("Deferred close not active for Datastore [" + datastore + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processing deferred close of Datastore Sessions");
        }
        Set<Session> sessions = holderMap.remove(datastore);
        for (Session session : sessions) {
            DatastoreUtils.closeSession(session);
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void initDeferredClose(Datastore datastore) {
        Assert.notNull((Object)datastore, (String)"No Datastore specified");
        logger.debug("Initializing deferred close of Datastore Sessions");
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap<Datastore, Set<Session>>();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(datastore, new LinkedHashSet(4));
    }

    public static void closeSessionOrRegisterDeferredClose(Session session, Datastore datastore) {
        Map<Datastore, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap != null && datastore != null && holderMap.containsKey(datastore)) {
            logger.debug("Registering Datastore Session for deferred close");
            holderMap.get(datastore).add(session);
        } else {
            DatastoreUtils.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doWithSession(Datastore datastore, Closure c) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            Object object = c.call((Object)session);
            return object;
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Datastore datastore, SessionCallback<T> callback) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            T t = callback.doInSession(session);
            return t;
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Datastore datastore, VoidSessionCallback callback) {
        boolean existing = datastore.hasCurrentSession();
        Session session = existing ? datastore.getCurrentSession() : DatastoreUtils.bindSession(datastore.connect());
        try {
            callback.doInSession(session);
        }
        finally {
            if (!existing) {
                TransactionSynchronizationManager.unbindResource((Object)datastore);
                DatastoreUtils.closeSessionOrRegisterDeferredClose(session, datastore);
            }
        }
    }

    public static Session bindSession(Session session) {
        TransactionSynchronizationManager.bindResource((Object)session.getDatastore(), (Object)((Object)new SessionHolder(session)));
        return session;
    }

    public static Session bindSession(Session session, Object creator) {
        TransactionSynchronizationManager.bindResource((Object)session.getDatastore(), (Object)((Object)new SessionHolder(session, creator)));
        return session;
    }

    public static Session bindNewSession(Session session) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getDatastore()));
        if (sessionHolder == null) {
            return DatastoreUtils.bindSession(session);
        }
        sessionHolder.addSession(session);
        return session;
    }

    public static void unbindSession(Session session) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)session.getDatastore()));
        if (sessionHolder == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Cannot unbind session, there's no SessionHolder registered");
            }
            return;
        }
        if (!sessionHolder.containsSession(session)) {
            if (logger.isWarnEnabled()) {
                logger.warn("Cannot unbind session, it's not registered in a SessionHolder");
            }
            return;
        }
        if (sessionHolder.size() > 1) {
            sessionHolder.removeSession(session);
        } else {
            TransactionSynchronizationManager.unbindResource((Object)session.getDatastore());
        }
        DatastoreUtils.closeSessionOrRegisterDeferredClose(session, session.getDatastore());
    }

    public static PropertyResolver preparePropertyResolver(PropertyResolver propertyResolver) {
        return DatastoreUtils.preparePropertyResolver(propertyResolver, "grails");
    }

    public static PropertyResolver preparePropertyResolver(PropertyResolver propertyResolver, String ... keyPrefixes) {
        if (propertyResolver instanceof Map || propertyResolver instanceof DatastoreEnvironment) {
            return propertyResolver;
        }
        if (propertyResolver instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)propertyResolver;
            List propertySources = DefaultGroovyMethods.asList((Iterable)env.getPropertySources());
            Collections.reverse(propertySources);
            LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
            for (PropertySource propertySource : propertySources) {
                String[] propertyNames;
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource eps = (EnumerablePropertySource)propertySource;
                block1: for (String propertyName : propertyNames = eps.getPropertyNames()) {
                    for (String keyPrefix : keyPrefixes) {
                        if (!propertyName.startsWith(keyPrefix)) continue;
                        configuration.put(propertyName, eps.getProperty(propertyName));
                        continue block1;
                    }
                }
            }
            return DatastoreUtils.createPropertyResolver(configuration);
        }
        return propertyResolver;
    }

    public static PropertyResolver createPropertyResolver(Map<String, Object> configuration) {
        if (configuration instanceof PropertyResolver) {
            return (PropertyResolver)configuration;
        }
        Map[] configurations = new Map[]{configuration};
        return DatastoreUtils.createPropertyResolvers(configurations);
    }

    public static PropertyResolver createPropertyResolvers(Map<String, Object> ... configurations) {
        return DatastoreUtils.createPropertyResolvers(Arrays.asList(configurations));
    }

    public static PropertyResolver createPropertyResolvers(Collection<Map<String, Object>> configurations) {
        DatastoreEnvironment env = new DatastoreEnvironment();
        env.getConversionService().addConverter((Converter)new Converter<String, Class>(){

            public Class convert(String source) {
                try {
                    return ClassUtils.forName((String)source, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new ConversionException("Cannot convert String [" + source + "] to class. The class was not found.", e){};
                }
            }
        });
        env.getConversionService().addConverter((Converter)new Converter<String, Resource>(){

            public Resource convert(String source) {
                return new PathMatchingResourcePatternResolver().getResource(source);
            }
        });
        int i = 0;
        for (Map<String, Object> configuration : configurations) {
            ++i;
            if (configuration == null) continue;
            MutablePropertySources propertySources = env.getPropertySources();
            if (configuration instanceof ConfigObject) {
                ConfigObject existingConfig = (ConfigObject)configuration;
                ConfigObject cloned = existingConfig.clone();
                propertySources.addFirst((PropertySource)new ConfigObjectPropertySource(DATASTORE_CONFIG + i, (Map)cloned));
                propertySources.addFirst((PropertySource)new ConfigObjectPropertySource(DATASTORE_CONFIG_FLAT + i, DatastoreUtils.createFlatConfig(cloned)));
                continue;
            }
            ConfigSlurper configSlurper = new ConfigSlurper();
            Properties properties = new Properties();
            LinkedHashMap<String, Object> finalConfig = new LinkedHashMap<String, Object>();
            for (String name : configuration.keySet()) {
                Object value = configuration.get(name);
                if (value == null) continue;
                finalConfig.put(name, value);
            }
            properties.putAll((Map<?, ?>)finalConfig);
            ConfigObject configObject = configSlurper.parse(properties);
            ConfigObject flatConfigObject = new ConfigObject();
            configObject.flatten((Map)flatConfigObject);
            flatConfigObject.merge(configObject);
            propertySources.addFirst((PropertySource)new ConfigObjectPropertySource(DATASTORE_CONFIG + i, (Map)configObject));
            propertySources.addFirst((PropertySource)new ConfigObjectPropertySource(DATASTORE_CONFIG_FLAT + i, DatastoreUtils.createFlatConfig(flatConfigObject)));
        }
        return env;
    }

    private static Map<String, Object> createFlatConfig(ConfigObject configuration) {
        LinkedHashMap<String, Object> flatConfig = new LinkedHashMap<String, Object>();
        String prefix = "";
        DatastoreUtils.createFlatConfig(configuration, flatConfig, prefix);
        return flatConfig;
    }

    private static void createFlatConfig(ConfigObject currentConfigObject, Map<String, Object> rootConfig, String prefix) {
        Set keySet = currentConfigObject.keySet();
        for (Object key : keySet) {
            Object value = currentConfigObject.get(key);
            if (value instanceof ConfigObject) {
                ConfigObject sub = ((ConfigObject)value).clone();
                String fullPath = prefix + key;
                if (sub.isEmpty()) continue;
                Map flattened = sub.flatten();
                sub.putAll(flattened);
                DatastoreUtils.createFlatConfig(sub, rootConfig, fullPath + ".");
                if (rootConfig.containsKey(fullPath)) continue;
                rootConfig.put(fullPath, sub);
                continue;
            }
            rootConfig.put(prefix + key, value);
        }
    }

    private static class ConfigObjectPropertySource
    extends MapPropertySource {
        public ConfigObjectPropertySource(String id, Map configObject) {
            super(id, configObject);
        }

        public Object getProperty(String name) {
            Object value = super.getProperty(name);
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    return null;
                }
                LinkedHashMap newMap = new LinkedHashMap();
                for (Object key : map.keySet()) {
                    Object v = map.get(key);
                    if (v instanceof ConfigObject) continue;
                    newMap.put(key, v);
                }
                return newMap;
            }
            return value;
        }
    }
}

