/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RenameLayerAction
extends AbstractAction {
    private final File file;
    private final transient Layer layer;

    public RenameLayerAction(File file, Layer layer) {
        super(I18n.tr("Rename layer", new Object[0]), ImageProvider.get("dialogs", "edit"));
        this.file = file;
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/RenameLayer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Box panel = Box.createVerticalBox();
        JosmTextField name = new JosmTextField(this.layer.getName());
        panel.add(name);
        JCheckBox filerename = new JCheckBox(I18n.tr("Also rename the file", new Object[0]));
        panel.add(filerename);
        filerename.setEnabled(this.file != null);
        if (filerename.isEnabled()) {
            filerename.setSelected(Config.getPref().getBoolean("layer.rename-file", true));
        }
        InitialValueOptionPane optionPane = new InitialValueOptionPane(panel, name);
        JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr("Rename layer", new Object[0]));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return;
        }
        String nameText = name.getText();
        if (filerename.isEnabled()) {
            Config.getPref().putBoolean("layer.rename-file", filerename.isSelected());
            if (filerename.isSelected()) {
                File newFile;
                String newname = nameText;
                if (newname.indexOf(47) == -1 && newname.indexOf(92) == -1) {
                    newname = this.file.getParent() + File.separator + newname;
                }
                String oldname = this.file.getName();
                if (name.getText().indexOf(46) == -1 && oldname.indexOf(46) >= 0) {
                    newname = newname + oldname.substring(oldname.lastIndexOf(46));
                }
                if (!SaveActionBase.confirmOverwrite(newFile = new File(newname))) {
                    return;
                }
                if (Main.platform.rename(this.file, newFile)) {
                    this.layer.setAssociatedFile(newFile);
                    if (!this.layer.isRenamed()) {
                        nameText = newFile.getName();
                    }
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not rename file ''{0}''", this.file.getPath()), I18n.tr("Error", new Object[0]), 0);
                    return;
                }
            }
        }
        this.layer.rename(nameText);
        Main.parent.repaint();
    }

    static class InitialValueOptionPane
    extends JOptionPane {
        InitialValueOptionPane(Box panel, JosmTextField initial) {
            super(panel, 3, 2, null, null, initial);
        }

        @Override
        public void selectInitialValue() {
            JosmTextField initial = (JosmTextField)this.getInitialValue();
            initial.requestFocusInWindow();
            initial.selectAll();
        }
    }
}

