/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.Color;
import java.util.Locale;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;

public class ColorProperty
extends AbstractToStringProperty<Color> {
    private final String name;

    public ColorProperty(String colName, String defaultValue) {
        this(colName, ColorHelper.html2color(defaultValue));
    }

    public ColorProperty(String colName, Color defaultValue) {
        super(ColorProperty.getColorKey(colName), defaultValue);
        CheckParameterUtil.ensureParameterNotNull(defaultValue, "defaultValue");
        this.name = colName;
        this.getPreferences().registerColor(ColorProperty.getColorKey(colName), colName);
    }

    @Override
    public Color get() {
        return (Color)super.get();
    }

    @Override
    public boolean put(Color value) {
        return super.put(value);
    }

    @Override
    protected Color fromString(String string) {
        return ColorHelper.html2color(string);
    }

    @Override
    protected String toString(Color t) {
        return ColorHelper.color2html(t, true);
    }

    public AbstractToStringProperty<Color> getChildColor(String colorName) {
        return this.getChildProperty(ColorProperty.getColorKey(colorName));
    }

    public String getName() {
        return this.name;
    }

    public static String getColorKey(String colName) {
        return colName == null ? null : "color." + colName.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]+", ".");
    }

    public String toString() {
        return "ColorProperty [name=" + this.name + ", defaultValue=" + this.getDefaultValue() + "]";
    }
}

