/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;

public class IntegerProperty
extends AbstractToStringProperty<Integer> {
    public IntegerProperty(String key, int defaultValue) {
        super(key, defaultValue);
        if (Main.pref != null) {
            this.get();
        }
    }

    @Override
    public Integer get() {
        return (Integer)super.get();
    }

    @Override
    public boolean put(Integer value) {
        return super.put(value);
    }

    @Override
    protected Integer fromString(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new AbstractProperty.InvalidPreferenceValueException(e);
        }
    }

    @Override
    protected String toString(Integer t) {
        return t.toString();
    }

    public boolean parseAndPut(String value) {
        try {
            return this.put(Integer.valueOf(value));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

