/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.CLIModule;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DeleteAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.data.projection.ProjectionCLI;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileSource;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.NTV2Proj4DirGridShiftFileSource;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.DownloadParamType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.ProgramArguments;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.bugreport.BugReportDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.AutosaveTask;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.mappaint.RenderingCLI;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.progress.swing.ProgressMonitorExecutor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.RedirectInputMap;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.protocols.data.Handler;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.FontsManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.OverpassTurboQueryWizard;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;
import org.xml.sax.SAXException;

public class MainApplication
extends Main {
    private static volatile List<String> commandLineArgs;
    static MainMenu menu;
    static MainPanel mainPanel;
    static JComponent contentPanePrivate;
    static MapFrame map;
    static volatile ToolbarPreferences toolbar;
    private final MainFrame mainFrame;
    public static final ExecutorService worker;
    private static final MainLayerManager layerManager;
    public static volatile UndoRedoHandler undoRedo;
    private static final LayerManager.LayerChangeListener undoRedoCleaner;
    private static final List<CLIModule> cliModules;
    public static final CLIModule JOSM_CLI_MODULE;
    private final UndoRedoHandler.CommandQueueListener redoUndoListener = (queueSize, redoSize) -> {
        MainApplication.menu.undo.setEnabled(queueSize > 0);
        MainApplication.menu.redo.setEnabled(redoSize > 0);
    };
    public static final NTV2GridShiftFileSource JOSM_WEBSITE_NTV2_SOURCE;

    public static void registerCLIModule(CLIModule module) {
        cliModules.add(module);
    }

    public MainApplication() {
        this(null);
    }

    public MainApplication(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        undoRedo = ((Main)this).undoRedo;
        MainApplication.getLayerManager().addLayerChangeListener(undoRedoCleaner);
    }

    public static void askUpdateJava(String updVersion, String url, String eolDate, boolean major) {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Outdated Java version", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Update Java", new Object[0]), I18n.tr("Cancel", new Object[0]));
        if (!ed.toggleEnable("askUpdateJava" + updVersion).toggleCheckState()) {
            ed.setButtonIcons("ok", "java", "cancel").setCancelButton(3);
            ed.setMinimumSize(new Dimension(480, 300));
            ed.setIcon(2);
            StringBuilder content = new StringBuilder(I18n.tr("You are running version {0} of Java.", "<b>" + System.getProperty("java.version") + "</b>")).append("<br><br>");
            if ("Sun Microsystems Inc.".equals(System.getProperty("java.vendor")) && !platform.isOpenJDK()) {
                content.append("<b>").append(I18n.tr("This version is no longer supported by {0} since {1} and is not recommended for use.", "Oracle", eolDate)).append("</b><br><br>");
            }
            content.append("<b>").append(major ? I18n.tr("JOSM will soon stop working with this version; we highly recommend you to update to Java {0}.", updVersion) : I18n.tr("You may face critical Java bugs; we highly recommend you to update to Java {0}.", updVersion)).append("</b><br><br>").append(I18n.tr("Would you like to update now ?", new Object[0]));
            ed.setContent(content.toString());
            if (ed.showDialog().getValue() == 2) {
                try {
                    platform.openUrl(url);
                }
                catch (IOException e) {
                    Logging.warn(e);
                }
            }
        }
    }

    @Override
    protected List<Main.InitializationTask> beforeInitializationTasks() {
        Main.InitializationTask[] initializationTaskArray = new Main.InitializationTask[5];
        initializationTaskArray[0] = new Main.InitializationTask(I18n.tr("Starting file watcher", new Object[0]), fileWatcher::start);
        initializationTaskArray[1] = new Main.InitializationTask(I18n.tr("Executing platform startup hook", new Object[0]), () -> platform.startupHook(MainApplication::askUpdateJava));
        initializationTaskArray[2] = new Main.InitializationTask(I18n.tr("Building main menu", new Object[0]), this::initializeMainWindow);
        initializationTaskArray[3] = new Main.InitializationTask(I18n.tr("Updating user interface", new Object[0]), () -> {
            undoRedo.addCommandQueueListener(this.redoUndoListener);
            GuiHelper.runInEDTAndWait(() -> contentPanePrivate.add((Component)MainApplication.toolbar.control, "North"));
            MainApplication.registerActionShortcut(MainApplication.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        });
        initializationTaskArray[4] = new Main.InitializationTask(I18n.tr("Initializing internal boundaries data", new Object[0]), Territories::initialize);
        return Arrays.asList(initializationTaskArray);
    }

    @Override
    protected Collection<Main.InitializationTask> parallelInitializationTasks() {
        return Arrays.asList(new Main.InitializationTask(I18n.tr("Initializing OSM API", new Object[0]), () -> {
            OsmApi.addOsmApiInitializationListener(api -> {
                if (MainApplication.isDisplayingMapView()) {
                    for (Layer layer : MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                        if (!((ImageryLayer)layer).getInfo().isBlacklisted()) continue;
                        Logging.info(I18n.tr("Removed layer {0} because it is not allowed by the configured API.", layer.getName()));
                        MainApplication.getLayerManager().removeLayer(layer);
                    }
                }
            });
            try {
                OsmApi.getOsmApi().initialize(null, true);
            }
            catch (OsmApiInitializationException | OsmTransferCanceledException e) {
                Logging.warn(Logging.getErrorMessage(Utils.getRootCause(e)));
            }
        }), new Main.InitializationTask(I18n.tr("Initializing internal traffic data", new Object[0]), RightAndLefthandTraffic::initialize), new Main.InitializationTask(I18n.tr("Initializing validator", new Object[0]), OsmValidator::initialize), new Main.InitializationTask(I18n.tr("Initializing presets", new Object[0]), TaggingPresets::initialize), new Main.InitializationTask(I18n.tr("Initializing map styles", new Object[0]), MapPaintPreference::initialize), new Main.InitializationTask(I18n.tr("Loading imagery preferences", new Object[0]), ImageryPreference::initialize));
    }

    @Override
    protected List<Callable<?>> asynchronousCallableTasks() {
        return Arrays.asList(OverpassTurboQueryWizard::getInstance);
    }

    @Override
    protected List<Runnable> asynchronousRunnableTasks() {
        return Arrays.asList(TMSLayer::getCache, OsmValidator::initializeTests);
    }

    @Override
    protected List<Main.InitializationTask> afterInitializationTasks() {
        return Arrays.asList(new Main.InitializationTask(I18n.tr("Updating user interface", new Object[0]), () -> GuiHelper.runInEDTAndWait(() -> {
            FeatureAdapter.registerBrowserAdapter(OpenBrowser::displayUrl);
            FeatureAdapter.registerTranslationAdapter(I18n::tr);
            FeatureAdapter.registerLoggingAdapter(name -> Logging.getLogger());
            toolbar.refreshToolbarControl();
            MainApplication.toolbar.control.updateUI();
            contentPanePrivate.updateUI();
        })));
    }

    protected void initializeMainWindow() {
        if (this.mainFrame != null) {
            this.panel = mainPanel = this.mainFrame.getPanel();
            this.mainFrame.initialize();
            ((Main)this).menu = menu = this.mainFrame.getMenu();
        } else {
            this.panel = mainPanel = new MainPanel(layerManager);
            ((Main)this).menu = menu = new MainMenu();
        }
        mainPanel.addMapFrameListener((o, n) -> this.redoUndoListener.commandChanged(0, 0));
        mainPanel.reAddListeners();
    }

    @Override
    protected void shutdown() {
        if (!GraphicsEnvironment.isHeadless()) {
            worker.shutdown();
            JCSCacheManager.shutdown();
        }
        if (this.mainFrame != null) {
            this.mainFrame.storeState();
        }
        if (map != null) {
            map.rememberToggleDialogWidth();
        }
        layerManager.resetState();
        super.shutdown();
        if (!GraphicsEnvironment.isHeadless()) {
            worker.shutdownNow();
        }
    }

    @Override
    protected Bounds getRealBounds() {
        return MainApplication.isDisplayingMapView() ? MainApplication.map.mapView.getRealBounds() : null;
    }

    @Override
    protected void restoreOldBounds(Bounds oldBounds) {
        if (MainApplication.isDisplayingMapView()) {
            MainApplication.map.mapView.zoomTo(oldBounds);
        }
    }

    @Override
    public Collection<OsmPrimitive> getInProgressSelection() {
        if (map != null && MainApplication.map.mapMode instanceof DrawAction) {
            return ((DrawAction)MainApplication.map.mapMode).getInProgressSelection();
        }
        DataSet ds = layerManager.getEditDataSet();
        if (ds == null) {
            return null;
        }
        return ds.getSelected();
    }

    @Override
    public DataSet getEditDataSet() {
        return MainApplication.getLayerManager().getEditDataSet();
    }

    @Override
    public void setEditDataSet(DataSet ds) {
        Optional<OsmDataLayer> layer = MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().filter(l -> l.data.equals(ds)).findFirst();
        if (layer.isPresent()) {
            MainApplication.getLayerManager().setActiveLayer(layer.get());
        }
    }

    @Override
    public boolean containsDataSet(DataSet ds) {
        return MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().anyMatch(l -> l.data.equals(ds));
    }

    public static List<String> getCommandLineArgs() {
        return Collections.unmodifiableList(commandLineArgs);
    }

    public static MainLayerManager getLayerManager() {
        return layerManager;
    }

    public static MapFrame getMap() {
        return map;
    }

    public static MainPanel getMainPanel() {
        return mainPanel;
    }

    public static MainMenu getMenu() {
        return menu;
    }

    public static ToolbarPreferences getToolbar() {
        return toolbar;
    }

    public static boolean isDisplayingMapView() {
        return map != null && MainApplication.map.mapView != null;
    }

    public static boolean exitJosm(boolean exit, int exitCode, SaveLayersDialog.Reason reason) {
        boolean proceed = Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> SaveLayersDialog.saveUnsavedModifications(layerManager.getLayers(), reason != null ? reason : SaveLayersDialog.Reason.EXIT)));
        if (proceed) {
            return Main.exitJosm(exit, exitCode);
        }
        return false;
    }

    public static void redirectToMainContentPane(JComponent source) {
        RedirectInputMap.redirect(source, contentPanePrivate);
    }

    public static boolean addAndFireMapFrameListener(MapFrameListener listener) {
        return mainPanel != null && mainPanel.addAndFireMapFrameListener(listener);
    }

    public static boolean addMapFrameListener(MapFrameListener listener) {
        return mainPanel != null && mainPanel.addMapFrameListener(listener);
    }

    public static boolean removeMapFrameListener(MapFrameListener listener) {
        return mainPanel != null && mainPanel.removeMapFrameListener(listener);
    }

    public static void registerActionShortcut(JosmAction action) {
        MainApplication.registerActionShortcut(action, action.getShortcut());
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object existing = inputMap.get(keyStroke);
        if (existing != null && !existing.equals(action)) {
            Logging.info(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, existing, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction action) {
        MainApplication.unregisterActionShortcut(action, action.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        MainApplication.unregisterShortcut(shortcut);
        contentPanePrivate.getActionMap().remove(action);
    }

    public static Action getRegisteredActionShortcut(Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return null;
        }
        Object action = contentPanePrivate.getInputMap(2).get(keyStroke);
        if (action instanceof Action) {
            return (Action)action;
        }
        return null;
    }

    public static void showHelp() {
        System.out.println(MainApplication.getHelp());
    }

    static String getHelp() {
        return I18n.tr("Java OpenStreetMap Editor", new Object[0]) + " [" + Version.getInstance().getAgentString() + "]\n\n" + I18n.tr("usage", new Object[0]) + ":\n\tjava -jar josm.jar [<command>] <options>...\n\n" + I18n.tr("commands", new Object[0]) + ":\n\trunjosm     " + I18n.tr("launch JOSM (default, performed when no command is specified)", new Object[0]) + '\n' + "\trender      " + I18n.tr("render data and save the result to an image file", new Object[0]) + '\n' + "\tproject     " + I18n.tr("convert coordinates from one coordinate reference system to another", new Object[0]) + "\n\n" + I18n.tr("For details on the {0} and {1} commands, run them with the {2} option.", "render", "project", "--help") + '\n' + I18n.tr("The remainder of this help page documents the {0} command.", "runjosm") + "\n\n" + I18n.tr("options", new Object[0]) + ":\n\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + '\n' + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + '\n' + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + '\n' + "\t[--download=]<URL>                        " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z)", new Object[0]) + '\n' + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + '\n' + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw GPS", new Object[0]) + '\n' + "\t--downloadgps=<URL>                       " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z) as raw GPS", new Object[0]) + '\n' + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + '\n' + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + '\n' + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n\t--version                                 " + I18n.tr("Displays the JOSM version and exits", new Object[0]) + "\n\n\t--debug                                   " + I18n.tr("Print debugging messages to console", new Object[0]) + "\n\n\t--skip-plugins                            " + I18n.tr("Skip loading plugins", new Object[0]) + "\n\n\t--offline=<osm_api|josm_website|all>      " + I18n.tr("Disable access to the given resource(s), separated by comma", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + MainApplication.align("\t-Djosm.dir.name=JOSM") + I18n.tr("Change the JOSM directory name", new Object[0]) + "\n\n" + MainApplication.align("\t-Djosm.pref=" + I18n.tr("/PATH/TO/JOSM/PREF    ", new Object[0])) + I18n.tr("Set the preferences directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultPrefDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.userdata=" + I18n.tr("/PATH/TO/JOSM/USERDATA", new Object[0])) + I18n.tr("Set the user data directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultUserDataDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.cache=" + I18n.tr("/PATH/TO/JOSM/CACHE   ", new Object[0])) + I18n.tr("Set the cache directory", new Object[0]) + "\n" + MainApplication.align("\t") + I18n.tr("Default: {0}", platform.getDefaultCacheDirectory()) + "\n\n" + MainApplication.align("\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/HOMEDIR ", new Object[0])) + I18n.tr("Set the preferences+data+cache directory (cache directory will be josm.home/cache)", new Object[0]) + "\n\n" + I18n.tr("-Djosm.home has lower precedence, i.e. the specific setting overrides the general one", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n\tjava -jar josm.jar " + OsmUrlToBounds.getURL(43.2, 11.1, 13) + '\n' + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n\tjava -Djosm.pref=$XDG_CONFIG_HOME -Djosm.userdata=$XDG_DATA_HOME -Djosm.cache=$XDG_CACHE_HOME -jar josm.jar\n\tjava -Djosm.dir.name=josm_dev -jar josm.jar\n\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n\tjava -Xmx1024m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + '\n' + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + '\n';
    }

    private static String align(String str) {
        return str + Stream.generate(() -> " ").limit(Math.max(0, 43 - str.length())).collect(Collectors.joining(""));
    }

    public static void main(String[] argArray) {
        I18n.init();
        commandLineArgs = Arrays.asList(Arrays.copyOf(argArray, argArray.length));
        if (argArray.length > 0) {
            String moduleStr = argArray[0];
            for (CLIModule module : cliModules) {
                if (!Objects.equals(moduleStr, module.getActionKeyword())) continue;
                String[] argArrayCdr = Arrays.copyOfRange(argArray, 1, argArray.length);
                module.processArguments(argArrayCdr);
                return;
            }
        }
        JOSM_CLI_MODULE.processArguments(argArray);
    }

    public static void mainJOSM(ProgramArguments args) {
        if (!GraphicsEnvironment.isHeadless()) {
            BugReportQueue.getInstance().setBugReportHandler(BugReportDialog::showFor);
            BugReportSender.setBugReportSendingHandler(BugReportDialog.bugReportSendingHandler);
        }
        Level logLevel = args.getLogLevel();
        Logging.setLogLevel(logLevel);
        if (!args.showVersion() && !args.showHelp()) {
            Logging.info(I18n.tr("Log level is at {0} ({1}, {2})", logLevel.getLocalizedName(), logLevel.getName(), logLevel.intValue()));
        }
        Optional<String> language = args.getSingle(ProgramArguments.Option.LANGUAGE);
        I18n.set(language.orElse(null));
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.setNativeOsCallback(new DefaultNativeOsCallback());
        Main.platform.preStartupHook();
        if (args.showVersion()) {
            System.out.println(Version.getInstance().getAgentString());
            return;
        }
        if (args.showHelp()) {
            MainApplication.showHelp();
            return;
        }
        boolean skipLoadingPlugins = args.hasOption(ProgramArguments.Option.SKIP_PLUGINS);
        if (skipLoadingPlugins) {
            Logging.info(I18n.tr("Plugin loading skipped", new Object[0]));
        }
        if (Logging.isLoggingEnabled(Logging.LEVEL_TRACE)) {
            Utils.updateSystemProperty("debug", "true");
            Logging.info(I18n.tr("Enabled detailed debug level (trace)", new Object[0]));
        }
        Main.pref.init(args.hasOption(ProgramArguments.Option.RESET_PREFERENCES));
        Config.setPreferencesInstance(Main.pref);
        Config.setBaseDirectoriesProvider(Main.pref);
        args.getPreferencesToSet().forEach(Main.pref::put);
        if (!language.isPresent()) {
            I18n.set(Config.getPref().get("language", null));
        }
        Main.pref.updateSystemProperties();
        MainApplication.checkIPv6();
        MainApplication.processOffline(args);
        Main.platform.afterPrefStartupHook();
        MainApplication.applyWorkarounds();
        FontsManager.initialize();
        GuiHelper.setupLanguageFonts();
        Handler.install();
        WindowGeometry geometry = WindowGeometry.mainWindow("gui.geometry", args.getSingle(ProgramArguments.Option.GEOMETRY).orElse(null), !args.hasOption(ProgramArguments.Option.NO_MAXIMIZE) && Config.getPref().getBoolean("gui.maximized", false));
        MainFrame mainFrame = new MainFrame(geometry);
        Container contentPane = mainFrame.getContentPane();
        if (contentPane instanceof JComponent) {
            contentPanePrivate = (JComponent)contentPane;
        }
        mainPanel = mainFrame.getPanel();
        Main.parent = mainFrame;
        if (args.hasOption(ProgramArguments.Option.LOAD_PREFERENCES)) {
            CustomConfigurator.XMLCommandProcessor config = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String i : args.get(ProgramArguments.Option.LOAD_PREFERENCES)) {
                Logging.info("Reading preferences from " + i);
                try {
                    InputStream is = MainApplication.openStream(new URL(i));
                    Throwable throwable = null;
                    try {
                        config.openAndReadXML(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    throw BugReport.intercept(ex).put("file", i);
                }
            }
        }
        try {
            CertificateAmendment.addMissingCertificates();
        }
        catch (IOException | GeneralSecurityException ex) {
            Logging.warn(ex);
            Logging.warn(Logging.getErrorMessage(Utils.getRootCause(ex)));
        }
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        DefaultProxySelector proxySelector = new DefaultProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault(proxySelector);
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        MainApplication.setupCallbacks();
        SplashScreen splash = GuiHelper.runInEDTAndWaitAndReturn(SplashScreen::new);
        final SplashScreen.SplashProgressMonitor monitor = splash.getProgressMonitor();
        monitor.beginTask(I18n.tr("Initializing", new Object[0]));
        GuiHelper.runInEDT(() -> splash.setVisible(Config.getPref().getBoolean("draw.splashscreen", true)));
        Main.setInitStatusListener(new Main.InitStatusListener(){

            @Override
            public Object updateStatus(String event) {
                monitor.beginTask(event);
                return event;
            }

            @Override
            public void finish(Object status) {
                if (status instanceof String) {
                    monitor.finishTask((String)status);
                }
            }
        });
        Collection<PluginInformation> pluginsToLoad = null;
        if (!skipLoadingPlugins) {
            pluginsToLoad = MainApplication.updateAndLoadEarlyPlugins(splash, monitor);
        }
        monitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.setupUIManager();
        Main.toolbar = toolbar = new ToolbarPreferences();
        ProjectionPreference.setProjection();
        MainApplication.setupNadGridSources();
        GuiHelper.translateJavaInternalMessages();
        MainApplication.preConstructorInit();
        monitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        MainApplication main = new MainApplication(mainFrame);
        main.initialize();
        if (!skipLoadingPlugins) {
            MainApplication.loadLatePlugins(splash, monitor, pluginsToLoad);
        }
        GuiHelper.runInEDTAndWait(() -> {
            splash.setVisible(false);
            splash.dispose();
            mainFrame.setVisible(true);
        });
        boolean maximized = Config.getPref().getBoolean("gui.maximized", false);
        if (!args.hasOption(ProgramArguments.Option.NO_MAXIMIZE) && maximized || args.hasOption(ProgramArguments.Option.MAXIMIZE)) {
            mainFrame.setMaximized(true);
        }
        if (((Main)main).menu.fullscreenToggleAction != null) {
            ((Main)main).menu.fullscreenToggleAction.initial();
        }
        SwingUtilities.invokeLater(new GuiFinalizationWorker(args, proxySelector));
        if (Main.isPlatformWindows()) {
            try {
                PlatformHookWindows.removeInsecureCertificates();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                Logging.error(e);
            }
        }
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get().booleanValue()) {
            RemoteControl.start();
        }
        if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
            MessageNotifier.start();
        }
        if (Config.getPref().getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            Logging.info("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    public static void setupNadGridSources() {
        NTV2GridShiftFileWrapper.registerNTV2GridShiftFileSource(10.0f, NTV2Proj4DirGridShiftFileSource.getInstance());
        NTV2GridShiftFileWrapper.registerNTV2GridShiftFileSource(5.0f, JOSM_WEBSITE_NTV2_SOURCE);
    }

    static void applyWorkarounds() {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows 10") && platform.getDefaultStyle().equals(LafPreference.LAF.get())) {
            try {
                int currentBuild = Integer.parseInt(PlatformHookWindows.getCurrentBuild());
                int javaVersion = Utils.getJavaVersion();
                int javaUpdate = Utils.getJavaUpdate();
                int javaBuild = Utils.getJavaBuild();
                if (currentBuild >= 15063 && (javaVersion == 8 && javaUpdate < 141 || javaVersion == 9 && javaUpdate == 0 && javaBuild < 173)) {
                    UIManager.put("FileChooser.useSystemExtensionHiding", Boolean.FALSE);
                }
            }
            catch (NumberFormatException | ReflectiveOperationException | JosmRuntimeException e) {
                Logging.error(e);
            }
        }
    }

    static void setupCallbacks() {
        OsmConnection.setOAuthAccessTokenFetcher(OAuthAuthorizationWizard::obtainAccessToken);
        AbstractCredentialsAgent.setCredentialsProvider(CredentialDialog::promptCredentials);
        MessageNotifier.setNotifierCallback(MainApplication::notifyNewMessages);
        DeleteCommand.setDeletionCallback(DeleteAction.defaultDeletionCallback);
        SplitWayCommand.setWarningNotifier(msg -> new Notification((String)msg).setIcon(2).show());
        FileWatcher.registerLoader(SourceType.MAP_PAINT_STYLE, MapPaintStyleLoader::reloadStyle);
        FileWatcher.registerLoader(SourceType.TAGCHECKER_RULE, MapCSSTagChecker::reloadRule);
        OsmUrlToBounds.setMapSizeSupplier(() -> {
            if (MainApplication.isDisplayingMapView()) {
                MapView mapView = MainApplication.getMap().mapView;
                return new Dimension(mapView.getWidth(), mapView.getHeight());
            }
            return GuiHelper.getScreenSize();
        });
    }

    static void setupUIManager() {
        String defaultlaf = platform.getDefaultStyle();
        String laf = LafPreference.LAF.get();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Logging.trace(e);
            Class<?> klass = null;
            for (ClassLoader cl : PluginHandler.getResourceClassLoaders()) {
                try {
                    klass = cl.loadClass(laf);
                    break;
                }
                catch (ClassNotFoundException ex) {
                    Logging.trace(ex);
                }
            }
            if (klass != null && LookAndFeel.class.isAssignableFrom(klass)) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)klass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException ex) {
                    Logging.log(Logging.LEVEL_WARN, "Cannot set Look and Feel: " + laf + ": " + ex.getMessage(), ex);
                }
                catch (UnsupportedLookAndFeelException ex) {
                    Logging.info("Look and Feel not supported: " + laf);
                    LafPreference.LAF.put(defaultlaf);
                    Logging.trace(ex);
                }
            } else {
                Logging.info("Look and Feel not found: " + laf);
                LafPreference.LAF.put(defaultlaf);
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            Logging.info("Look and Feel not supported: " + laf);
            LafPreference.LAF.put(defaultlaf);
            Logging.trace(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logging.error(e);
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        for (String p : Arrays.asList("EditorPane", "FormattedTextField", "PasswordField", "TextArea", "TextField", "TextPane")) {
            UIManager.put(p + ".caretForeground", UIManager.getColor(p + ".foreground"));
        }
    }

    private static InputStream openStream(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            return url.openStream();
        }
        return HttpClient.create(url).connect().getContent();
    }

    static Collection<PluginInformation> updateAndLoadEarlyPlugins(SplashScreen splash, SplashScreen.SplashProgressMonitor monitor) {
        Collection<PluginInformation> pluginsToLoad = PluginHandler.buildListOfPluginsToLoad(splash, monitor.createSubTaskMonitor(1, false));
        if (!pluginsToLoad.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splash)) {
            monitor.subTask(I18n.tr("Updating plugins", new Object[0]));
            pluginsToLoad = PluginHandler.updatePlugins(splash, null, monitor.createSubTaskMonitor(1, false), false);
        }
        monitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
        PluginHandler.installDownloadedPlugins(true);
        monitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
        PluginHandler.loadEarlyPlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        return pluginsToLoad;
    }

    static void loadLatePlugins(SplashScreen splash, SplashScreen.SplashProgressMonitor monitor, Collection<PluginInformation> pluginsToLoad) {
        monitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
        PluginHandler.loadLatePlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        GuiHelper.runInEDTAndWait(() -> toolbar.refreshToolbarControl());
    }

    private static void processOffline(ProgramArguments args) {
        for (String offlineNames : args.get(ProgramArguments.Option.OFFLINE)) {
            for (String s : offlineNames.split(",")) {
                try {
                    Main.setOffline(OnlineResource.valueOf(s.toUpperCase(Locale.ENGLISH)));
                }
                catch (IllegalArgumentException e) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("''{0}'' is not a valid value for argument ''{1}''. Possible values are {2}, possibly delimited by commas.", s.toUpperCase(Locale.ENGLISH), ProgramArguments.Option.OFFLINE.getName(), Arrays.toString((Object[])OnlineResource.values())), e);
                    System.exit(1);
                    return;
                }
            }
        }
        Set<OnlineResource> offline = Main.getOfflineResources();
        if (!offline.isEmpty()) {
            Logging.warn(I18n.trn("JOSM is running in offline mode. This resource will not be available: {0}", "JOSM is running in offline mode. These resources will not be available: {0}", offline.size(), offline.size() == 1 ? offline.iterator().next() : Arrays.toString(offline.toArray())));
        }
    }

    private static void checkIPv6() {
        if ("auto".equals(Config.getPref().get("prefer.ipv6", "auto"))) {
            new Thread(() -> {
                boolean hasv6 = false;
                boolean wasv6 = Config.getPref().getBoolean("validated.ipv6", false);
                try {
                    if (wasv6) {
                        Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                    }
                    for (InetAddress a : InetAddress.getAllByName("josm.openstreetmap.de")) {
                        if (!(a instanceof Inet6Address)) continue;
                        if (a.isReachable(1000)) {
                            SSLSocketFactory.getDefault().createSocket(a, 443).close();
                            Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
                            if (!wasv6) {
                                Logging.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4 after next restart.", new Object[0]));
                            } else {
                                Logging.info(I18n.tr("Detected useable IPv6 network, prefering IPv6 over IPv4.", new Object[0]));
                            }
                            hasv6 = true;
                        }
                        break;
                    }
                }
                catch (IOException | SecurityException e) {
                    Logging.debug("Exception while checking IPv6 connectivity: {0}", e);
                    Logging.trace(e);
                }
                if (wasv6 && !hasv6) {
                    Logging.info(I18n.tr("Detected no useable IPv6 network, prefering IPv4 over IPv6 after next restart.", new Object[0]));
                    Config.getPref().putBoolean("validated.ipv6", hasv6);
                    try {
                        RestartAction.restartJOSM();
                    }
                    catch (IOException e) {
                        Logging.error(e);
                    }
                }
                Config.getPref().putBoolean("validated.ipv6", hasv6);
            }, "IPv6-checker").start();
        }
    }

    static List<Future<?>> downloadFromParamBounds(boolean rawGps, Bounds b) {
        AbstractDownloadTask task = rawGps ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = task.download(true, b, null);
        return Collections.singletonList(worker.submit(new PostDownloadHandler(task, future)));
    }

    static List<Future<?>> postConstructorProcessCmdLine(ProgramArguments args) {
        ArrayList tasks = new ArrayList();
        ArrayList<File> fileList = new ArrayList<File>();
        for (String s : args.get(ProgramArguments.Option.DOWNLOAD)) {
            tasks.addAll(DownloadParamType.paramType(s).download(s, fileList));
        }
        if (!fileList.isEmpty()) {
            tasks.add(OpenFileAction.openFiles(fileList, true));
        }
        for (String s : args.get(ProgramArguments.Option.DOWNLOADGPS)) {
            tasks.addAll(DownloadParamType.paramType(s).downloadGps(s));
        }
        Collection<String> selectionArguments = args.get(ProgramArguments.Option.SELECTION);
        if (!selectionArguments.isEmpty()) {
            tasks.add(worker.submit(() -> {
                for (String s : selectionArguments) {
                    SearchAction.search(s, SearchMode.add);
                }
            }));
        }
        return tasks;
    }

    static void notifyNewMessages(UserInfo userInfo) {
        GuiHelper.runInEDT(() -> {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(I18n.trn("You have {0} unread message.", "You have {0} unread messages.", userInfo.getUnreadMessages(), userInfo.getUnreadMessages())), GBC.eol());
            panel.add((Component)new UrlLabel(Main.getBaseUserUrl() + '/' + userInfo.getDisplayName() + "/inbox", I18n.tr("Click here to see your inbox.", new Object[0])), GBC.eol());
            panel.setOpaque(false);
            new Notification().setContent(panel).setIcon(1).setDuration(Notification.TIME_LONG).show();
        });
    }

    static {
        Main.worker = worker = new ProgressMonitorExecutor("main-worker-%d", 5);
        layerManager = new MainLayerManager();
        undoRedoCleaner = new LayerManager.LayerChangeListener(){

            @Override
            public void layerRemoving(LayerManager.LayerRemoveEvent e) {
                Layer layer = e.getRemovedLayer();
                if (layer instanceof OsmDataLayer) {
                    undoRedo.clean(((OsmDataLayer)layer).data);
                }
            }

            @Override
            public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            }

            @Override
            public void layerAdded(LayerManager.LayerAddEvent e) {
            }
        };
        cliModules = new ArrayList<CLIModule>();
        JOSM_CLI_MODULE = new CLIModule(){

            @Override
            public String getActionKeyword() {
                return "runjosm";
            }

            @Override
            public void processArguments(String[] argArray) {
                ProgramArguments args = null;
                try {
                    args = new ProgramArguments(argArray);
                }
                catch (IllegalArgumentException e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
                MainApplication.mainJOSM(args);
            }
        };
        JOSM_WEBSITE_NTV2_SOURCE = gridFileName -> {
            String location = Main.getJOSMWebsite() + "/proj/" + gridFileName;
            CachedFile cf = new CachedFile(location);
            try {
                return cf.getInputStream();
            }
            catch (IOException ex) {
                Logging.warn(ex);
                return null;
            }
        };
        MainApplication.registerCLIModule(JOSM_CLI_MODULE);
        MainApplication.registerCLIModule(ProjectionCLI.INSTANCE);
        MainApplication.registerCLIModule(RenderingCLI.INSTANCE);
    }

    private static class DefaultNativeOsCallback
    implements PlatformHook.NativeOsCallback {
        private DefaultNativeOsCallback() {
        }

        @Override
        public void openFiles(List<File> files) {
            Executors.newSingleThreadExecutor(Utils.newThreadFactory("openFiles-%d", 5)).submit(new OpenFileAction.OpenFileTask(files, null){

                @Override
                protected void realRun() throws SAXException, IOException, OsmTransferException {
                    while (Main.parent == null || !Main.parent.isVisible()) {
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException e) {
                            Logging.warn(e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    super.realRun();
                }
            });
        }

        @Override
        public boolean handleQuitRequest() {
            return MainApplication.exitJosm(false, 0, null);
        }

        @Override
        public void handleAbout() {
            MainApplication.getMenu().about.actionPerformed(null);
        }

        @Override
        public void handlePreferences() {
            MainApplication.getMenu().preferences.actionPerformed(null);
        }
    }

    private static class GuiFinalizationWorker
    implements Runnable {
        private final ProgramArguments args;
        private final DefaultProxySelector proxySelector;

        GuiFinalizationWorker(ProgramArguments args, DefaultProxySelector proxySelector) {
            this.args = args;
            this.proxySelector = proxySelector;
        }

        @Override
        public void run() {
            if (!this.handleProxyErrors()) {
                GuiFinalizationWorker.handleNetworkErrors();
            }
            GuiFinalizationWorker.handleAutosave();
            MainApplication.postConstructorProcessCmdLine(this.args);
            DownloadDialog.autostartIfNeeded();
        }

        private static void handleAutosave() {
            if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get().booleanValue()) {
                AutosaveTask autosaveTask = new AutosaveTask();
                List<File> unsavedLayerFiles = autosaveTask.getUnsavedLayersFiles();
                if (!unsavedLayerFiles.isEmpty()) {
                    ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0]));
                    dialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", unsavedLayerFiles.size(), unsavedLayerFiles.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                    dialog.setButtonIcons("ok", "cancel", "dialogs/delete");
                    int selection = dialog.showDialog().getValue();
                    if (selection == 1) {
                        autosaveTask.recoverUnsavedLayers();
                    } else if (selection == 3) {
                        autosaveTask.discardUnsavedLayers();
                    }
                }
                autosaveTask.schedule();
            }
        }

        private static boolean handleNetworkOrProxyErrors(boolean hasErrors, String title, String message) {
            if (hasErrors) {
                ExtendedDialog ed = new ExtendedDialog(Main.parent, title, I18n.tr("Change proxy settings", new Object[0]), I18n.tr("Cancel", new Object[0]));
                ed.setButtonIcons("dialogs/settings", "cancel").setCancelButton(2);
                ed.setMinimumSize(new Dimension(460, 260));
                ed.setIcon(2);
                ed.setContent(message);
                if (ed.showDialog().getValue() == 1) {
                    PreferencesAction.forPreferenceSubTab(null, null, ProxyPreference.class).run();
                }
            }
            return hasErrors;
        }

        private boolean handleProxyErrors() {
            return GuiFinalizationWorker.handleNetworkOrProxyErrors(this.proxySelector.hasErrors(), I18n.tr("Proxy errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following proxy errors:<br>{1}Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorResources()), Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorMessages())));
        }

        private static boolean handleNetworkErrors() {
            boolean condition;
            Map<String, Throwable> networkErrors = Main.getNetworkErrors();
            boolean bl = condition = !networkErrors.isEmpty();
            if (condition) {
                TreeSet<String> errors = new TreeSet<String>();
                for (Throwable t : networkErrors.values()) {
                    errors.add(t.toString());
                }
                return GuiFinalizationWorker.handleNetworkOrProxyErrors(condition, I18n.tr("Network errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following network errors:<br>{1}It may be due to a missing proxy configuration.<br>Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(networkErrors.keySet()), Utils.joinAsHtmlUnorderedList(errors)));
            }
            return false;
        }
    }
}

