/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DuplicateRelationAction
extends AbstractRelationEditorAction {
    private final transient TagEditorModel tagEditorModel;

    public DuplicateRelationAction(MemberTableModel memberTableModel, TagEditorModel tagEditorModel, OsmDataLayer layer) {
        super(null, memberTableModel, null, layer, null);
        this.tagEditorModel = tagEditorModel;
        this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("duplicate"));
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation copy = new Relation();
        this.tagEditorModel.applyToPrimitive(copy);
        this.memberTableModel.applyToRelation(copy);
        if (!GraphicsEnvironment.isHeadless()) {
            RelationEditor.getEditor(this.layer, copy, this.memberTableModel.getSelectedMembers()).setVisible(true);
        }
    }

    @Override
    protected void updateEnabledState() {
    }
}

