/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.OpenChangesetPopupMenu;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class VersionInfoPanel
extends JPanel
implements ChangeListener {
    private final PointInTimeType pointInTimeType;
    private final transient HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private final JButton lblChangesetComments = new JButton(ImageProvider.get("dialogs/notes/note_comment"));
    private final OpenChangesetDialogAction changesetCommentsDialogAction = new OpenChangesetDialogAction(ChangesetDiscussionPanel.class);
    private final OpenChangesetDialogAction changesetDialogAction = new OpenChangesetDialogAction(null);
    private final JButton changesetButton = new JButton(this.changesetDialogAction);
    private JPanel pnlChangesetSource;
    private JPanel pnlChangesetImageryUsed;
    private JLabel lblSource;
    private JLabel lblImageryUsed;
    private JTextArea texChangesetComment;
    private JTextArea texChangesetSource;
    private JTextArea texChangesetImageryUsed;

    protected static JTextArea buildTextArea(String tooltip) {
        JTextArea lbl = new JTextArea();
        lbl.setLineWrap(true);
        lbl.setWrapStyleWord(true);
        lbl.setEditable(false);
        lbl.setOpaque(false);
        lbl.setToolTipText(tooltip);
        return lbl;
    }

    protected static JLabel buildLabel(String text, String tooltip, JTextArea textArea) {
        JLabel lbl = new JLabel("<html><p style='margin-top:" + textArea.getMargin().top + "'>" + text + "</html>");
        lbl.setFont(textArea.getFont());
        lbl.setToolTipText(tooltip);
        lbl.setLabelFor(textArea);
        return lbl;
    }

    protected static JPanel buildTextPanel(JLabel label, JTextArea textArea) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)label, GBC.std().anchor(18));
        pnl.add((Component)textArea, GBC.eol().insets(2, 0, 0, 0).fill());
        return pnl;
    }

    protected void build() {
        JPanel pnl1 = new JPanel(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        pnl1.add((Component)this.lblInfo, "Center");
        JPanel pnlUserAndChangeset = new JPanel(new GridBagLayout());
        pnlUserAndChangeset.add((Component)new JLabel(I18n.tr("User:", new Object[0])), GBC.std());
        this.lblUser = new UrlLabel("", 2);
        pnlUserAndChangeset.add((Component)this.lblUser, GBC.eol().insets(5, 0, 0, 0).weight(1.0, 0.0));
        JPanel changesetPanel = new JPanel(new BorderLayout());
        this.changesetButton.setMargin(new Insets(0, 0, 0, 2));
        changesetPanel.add((Component)this.changesetButton, "Center");
        BasicArrowButton arrowButton = new BasicArrowButton(5);
        arrowButton.addActionListener(action -> {
            OpenChangesetPopupMenu popupMenu = new OpenChangesetPopupMenu(this.changesetDialogAction.id.intValue());
            popupMenu.insert(this.changesetDialogAction, 0);
            ((AbstractButton)popupMenu.getComponent(0)).setText(I18n.tr("Open Changeset Manager", new Object[0]));
            popupMenu.show(arrowButton);
        });
        changesetPanel.add((Component)arrowButton, "East");
        pnlUserAndChangeset.add((Component)changesetPanel, GBC.std().fill().weight(0.0, 0.0));
        this.lblChangeset = new UrlLabel("", 2);
        pnlUserAndChangeset.add((Component)this.lblChangeset, GBC.std().insets(5, 0, 0, 0).weight(1.0, 0.0));
        this.lblChangesetComments.setAction(this.changesetCommentsDialogAction);
        this.lblChangesetComments.setMargin(new Insets(0, 0, 0, 0));
        this.lblChangesetComments.setIcon(new ImageProvider("dialogs/notes/note_comment").setMaxSize(12).get());
        pnlUserAndChangeset.add((Component)this.lblChangesetComments, GBC.eol());
        this.texChangesetComment = VersionInfoPanel.buildTextArea(I18n.tr("Changeset comment", new Object[0]));
        this.texChangesetSource = VersionInfoPanel.buildTextArea(I18n.tr("Changeset source", new Object[0]));
        this.texChangesetImageryUsed = VersionInfoPanel.buildTextArea(I18n.tr("Imagery used", new Object[0]));
        this.lblSource = VersionInfoPanel.buildLabel(I18n.tr("<b>Source</b>:", new Object[0]), I18n.tr("Changeset source", new Object[0]), this.texChangesetSource);
        this.lblImageryUsed = VersionInfoPanel.buildLabel(I18n.tr("<b>Imagery</b>:", new Object[0]), I18n.tr("Imagery used", new Object[0]), this.texChangesetImageryUsed);
        this.pnlChangesetSource = VersionInfoPanel.buildTextPanel(this.lblSource, this.texChangesetSource);
        this.pnlChangesetImageryUsed = VersionInfoPanel.buildTextPanel(this.lblImageryUsed, this.texChangesetImageryUsed);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)pnl1, gc);
        gc.gridy = 1;
        gc.weighty = 0.0;
        this.add((Component)pnlUserAndChangeset, gc);
        gc.gridy = 2;
        this.add((Component)this.texChangesetComment, gc);
        gc.gridy = 3;
        this.add((Component)this.pnlChangesetSource, gc);
        gc.gridy = 4;
        this.add((Component)this.pnlChangesetImageryUsed, gc);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText(Date timestamp, long version, boolean isLatest) {
        String text;
        if (isLatest) {
            OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
            text = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(version), editLayer == null ? I18n.tr("unknown", new Object[0]) : Utils.escapeReservedCharactersHTML(editLayer.getName()));
        } else {
            String date = "?";
            if (timestamp != null) {
                date = DateUtils.formatDateTime(timestamp, 3, 3);
            }
            text = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(version), date);
        }
        return text;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel model, PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(model, "model");
        this.model = model;
        this.pointInTimeType = pointInTimeType;
        model.addChangeListener(this);
        this.build();
    }

    protected static String getUserUrl(String username) {
        return Main.getBaseUserUrl() + '/' + Utils.encodeUrl(username).replaceAll("\\+", "%20");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        HistoryOsmPrimitive primitive = this.getPrimitive();
        if (primitive != null) {
            Changeset cs = primitive.getChangeset();
            this.update(cs, this.model.isLatest(primitive), primitive.getTimestamp(), primitive.getVersion());
        }
    }

    public void update(OsmPrimitive primitive, boolean isLatest) {
        this.update(Changeset.fromPrimitive(primitive), isLatest, primitive.getTimestamp(), primitive.getVersion());
    }

    public void update(Changeset cs, boolean isLatest, Date timestamp, long version) {
        this.lblInfo.setText(this.getInfoText(timestamp, version, isLatest));
        if (!isLatest && cs != null) {
            User user = cs.getUser();
            String url = Main.getBaseBrowseUrl() + "/changeset/" + cs.getId();
            this.lblChangeset.setUrl(url);
            this.lblChangeset.setDescription(Long.toString(cs.getId()));
            this.changesetCommentsDialogAction.setId(cs.getId());
            this.lblChangesetComments.setVisible(cs.getCommentsCount() > 0);
            this.lblChangesetComments.setText(String.valueOf(cs.getCommentsCount()));
            this.lblChangesetComments.setToolTipText(I18n.trn("This changeset has {0} comment", "This changeset has {0} comments", cs.getCommentsCount(), cs.getCommentsCount()));
            this.changesetDialogAction.setId(cs.getId());
            this.changesetButton.setEnabled(true);
            String username = "";
            if (user != null) {
                username = user.getName();
            }
            this.lblUser.setDescription(username);
            if (user != null && user != User.getAnonymous()) {
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl(username));
            } else {
                this.lblUser.setUrl(null);
            }
        } else {
            String username = UserIdentityManager.getInstance().getUserName();
            if (username == null) {
                this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                this.lblUser.setUrl(null);
            } else {
                this.lblUser.setDescription(username);
                this.lblUser.setUrl(VersionInfoPanel.getUserUrl(username));
            }
            this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
            this.lblChangeset.setUrl(null);
            this.lblChangesetComments.setVisible(false);
            this.changesetDialogAction.setId(null);
            this.changesetButton.setEnabled(false);
        }
        Changeset oppCs = this.model != null ? this.model.getPointInTime(this.pointInTimeType.opposite()).getChangeset() : null;
        VersionInfoPanel.updateText(cs, "comment", this.texChangesetComment, null, oppCs, this.texChangesetComment);
        VersionInfoPanel.updateText(cs, "source", this.texChangesetSource, this.lblSource, oppCs, this.pnlChangesetSource);
        VersionInfoPanel.updateText(cs, "imagery_used", this.texChangesetImageryUsed, this.lblImageryUsed, oppCs, this.pnlChangesetImageryUsed);
    }

    protected static void updateText(Changeset cs, String attr, JTextArea textArea, JLabel label, Changeset oppCs, JComponent container) {
        String text;
        String string = text = cs != null ? cs.get(attr) : null;
        if (label != null) {
            label.setVisible(text != null && !Utils.isStripEmpty(text));
        }
        textArea.setText(text);
        container.setVisible(text != null || oppCs != null && oppCs.get(attr) != null);
    }

    static class OpenChangesetDialogAction
    extends AbstractAction {
        private final Class<? extends JComponent> componentToSelect;
        private Integer id;

        OpenChangesetDialogAction(Class<? extends JComponent> componentToSelect) {
            super(I18n.tr("Changeset", new Object[0]), new ImageProvider("dialogs/changeset", "changesetmanager").resetMaxSize(new Dimension(16, 16)).get());
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets", new Object[0]));
            this.componentToSelect = componentToSelect;
        }

        void setId(Integer id) {
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.id != null) {
                ChangesetDialog.LaunchChangesetManager.displayChangesets(Collections.singleton(this.id));
            }
            if (this.componentToSelect != null) {
                ChangesetCacheManager.getInstance().setSelectedComponentInDetailPanel(this.componentToSelect);
            }
        }
    }
}

