/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;

public abstract class AbstractMapViewPaintable
implements MapViewPaintable {
    private final CopyOnWriteArrayList<MapViewPaintable.PaintableInvalidationListener> invalidationListeners = new CopyOnWriteArrayList();

    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        return this.createMapViewPainter(event);
    }

    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new CompatibilityModeLayerPainter();
    }

    @Override
    public void addInvalidationListener(MapViewPaintable.PaintableInvalidationListener l) {
        this.invalidationListeners.add(l);
    }

    @Override
    public void removeInvalidationListener(MapViewPaintable.PaintableInvalidationListener l) {
        this.invalidationListeners.remove(l);
    }

    public void invalidate() {
        for (MapViewPaintable.PaintableInvalidationListener l : this.invalidationListeners) {
            l.paintableInvalidated(new MapViewPaintable.PaintableInvalidationEvent(this));
        }
    }

    protected class CompatibilityModeLayerPainter
    implements MapViewPaintable.LayerPainter {
        protected CompatibilityModeLayerPainter() {
        }

        @Override
        public void paint(MapViewGraphics graphics) {
            AbstractMapViewPaintable.this.paint(graphics.getDefaultGraphics(), graphics.getMapView(), graphics.getClipBounds().getLatLonBoundsBox());
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
        }
    }
}

