/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.gui.layer.geoimage.Timezone;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public final class Offset {
    static final Offset ZERO = new Offset(0L);
    private final long milliseconds;

    private Offset(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    static Offset milliseconds(long milliseconds) {
        return new Offset(milliseconds);
    }

    static Offset seconds(long seconds) {
        return new Offset(1000L * seconds);
    }

    long getMilliseconds() {
        return this.milliseconds;
    }

    long getSeconds() {
        return this.milliseconds / 1000L;
    }

    String formatOffset() {
        if (this.milliseconds % 1000L == 0L) {
            return Long.toString(this.milliseconds / 1000L);
        }
        if (this.milliseconds % 100L == 0L) {
            return String.format(Locale.ENGLISH, "%.1f", (double)this.milliseconds / 1000.0);
        }
        return String.format(Locale.ENGLISH, "%.3f", (double)this.milliseconds / 1000.0);
    }

    static Offset parseOffset(String offset) throws ParseException {
        String error = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
        if (!offset.isEmpty()) {
            try {
                if (offset.startsWith("+")) {
                    offset = offset.substring(1);
                }
                return Offset.milliseconds(Math.round(Double.parseDouble(offset) * 1000.0));
            }
            catch (NumberFormatException nfe) {
                throw (ParseException)new ParseException(error, 0).initCause(nfe);
            }
        }
        return ZERO;
    }

    int getDayOffset() {
        return (int)Math.round((double)this.getMilliseconds() / (double)TimeUnit.DAYS.toMillis(1L));
    }

    Offset withoutDayOffset() {
        return Offset.milliseconds(this.getMilliseconds() - TimeUnit.DAYS.toMillis(this.getDayOffset()));
    }

    Pair<Timezone, Offset> splitOutTimezone() {
        double tz = (double)this.withoutDayOffset().getSeconds() / (double)TimeUnit.HOURS.toSeconds(1L);
        double timezone = (double)Math.round(tz * 2.0) / 2.0;
        long delta = Math.round((double)this.getMilliseconds() - timezone * (double)TimeUnit.HOURS.toMillis(1L));
        return Pair.create(new Timezone(timezone), Offset.milliseconds(delta));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Offset)) {
            return false;
        }
        Offset offset = (Offset)o;
        return this.milliseconds == offset.milliseconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliseconds);
    }
}

