/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public final class Geometry {
    private Geometry() {
    }

    public static Set<Node> addIntersections(List<Way> ways, boolean test, List<Command> cmds) {
        int n = ways.size();
        ArrayList[] newNodes = new ArrayList[n];
        BBox[] wayBounds = new BBox[n];
        boolean[] changedWays = new boolean[n];
        LinkedHashSet<Node> intersectionNodes = new LinkedHashSet<Node>();
        for (int pos = 0; pos < n; ++pos) {
            newNodes[pos] = new ArrayList<Node>(ways.get(pos).getNodes());
            wayBounds[pos] = Geometry.getNodesBounds(newNodes[pos]);
            changedWays[pos] = false;
        }
        DataSet dataset = ways.get(0).getDataSet();
        NodePositionComparator coordsComparator = new NodePositionComparator();
        for (int seg1Way = 0; seg1Way < n; ++seg1Way) {
            for (int seg2Way = seg1Way; seg2Way < n; ++seg2Way) {
                if (!wayBounds[seg1Way].intersects(wayBounds[seg2Way])) continue;
                ArrayList way1Nodes = newNodes[seg1Way];
                ArrayList way2Nodes = newNodes[seg2Way];
                int seg1Pos = 0;
                while (seg1Pos + 1 < way1Nodes.size()) {
                    int seg2Start;
                    int seg2Pos = seg2Start = seg1Way != seg2Way ? 0 : seg1Pos + 2;
                    while (seg2Pos + 1 < way2Nodes.size()) {
                        Node seg1Node1 = (Node)way1Nodes.get(seg1Pos);
                        Node seg1Node2 = (Node)way1Nodes.get(seg1Pos + 1);
                        Node seg2Node1 = (Node)way2Nodes.get(seg2Pos);
                        Node seg2Node2 = (Node)way2Nodes.get(seg2Pos + 1);
                        int commonCount = 0;
                        if (seg1Node1 == seg2Node1 || seg1Node1 == seg2Node2) {
                            ++commonCount;
                            if (seg1Way != seg2Way || seg1Pos != 0 || seg2Pos != way2Nodes.size() - 2) {
                                intersectionNodes.add(seg1Node1);
                            }
                        }
                        if (seg1Node2 == seg2Node1 || seg1Node2 == seg2Node2) {
                            ++commonCount;
                            intersectionNodes.add(seg1Node2);
                        }
                        if (commonCount == 0) {
                            EastNorth intersection = Geometry.getSegmentSegmentIntersection(seg1Node1.getEastNorth(), seg1Node2.getEastNorth(), seg2Node1.getEastNorth(), seg2Node2.getEastNorth());
                            if (intersection != null) {
                                Node newNode;
                                if (test) {
                                    intersectionNodes.add(seg2Node1);
                                    return intersectionNodes;
                                }
                                Node intNode = newNode = new Node(Main.getProjection().eastNorth2latlon(intersection));
                                boolean insertInSeg1 = false;
                                boolean insertInSeg2 = false;
                                if (coordsComparator.compare(newNode, seg1Node1) == 0) {
                                    intNode = seg1Node1;
                                } else if (coordsComparator.compare(newNode, seg1Node2) == 0) {
                                    intNode = seg1Node2;
                                } else {
                                    insertInSeg1 = true;
                                }
                                if (coordsComparator.compare(newNode, seg2Node1) == 0) {
                                    intNode = seg2Node1;
                                } else if (coordsComparator.compare(newNode, seg2Node2) == 0) {
                                    intNode = seg2Node2;
                                } else {
                                    insertInSeg2 = true;
                                }
                                if (insertInSeg1) {
                                    way1Nodes.add(seg1Pos + 1, intNode);
                                    changedWays[seg1Way] = true;
                                    if (seg2Way == seg1Way) {
                                        ++seg2Pos;
                                    }
                                }
                                if (insertInSeg2) {
                                    way2Nodes.add(seg2Pos + 1, intNode);
                                    changedWays[seg2Way] = true;
                                    ++seg2Pos;
                                }
                                intersectionNodes.add(intNode);
                                if (intNode == newNode) {
                                    cmds.add(new AddCommand(dataset, (OsmPrimitive)intNode));
                                }
                            }
                        } else if (test && !intersectionNodes.isEmpty()) {
                            return intersectionNodes;
                        }
                        ++seg2Pos;
                    }
                    ++seg1Pos;
                }
            }
        }
        for (int pos = 0; pos < ways.size(); ++pos) {
            if (!changedWays[pos]) continue;
            Way way = ways.get(pos);
            Way newWay = new Way(way);
            newWay.setNodes(newNodes[pos]);
            cmds.add(new ChangeCommand(dataset, (OsmPrimitive)way, (OsmPrimitive)newWay));
        }
        return intersectionNodes;
    }

    private static BBox getNodesBounds(List<Node> nodes) {
        BBox bounds = new BBox(nodes.get(0));
        for (Node n : nodes) {
            bounds.add(n);
        }
        return bounds;
    }

    public static boolean isToTheRightSideOfLine(Node lineP1, Node lineP2, Node lineP3, Node testPoint) {
        boolean pathBendToRight = Geometry.angleIsClockwise(lineP1, lineP2, lineP3);
        boolean rightOfSeg1 = Geometry.angleIsClockwise(lineP1, lineP2, testPoint);
        boolean rightOfSeg2 = Geometry.angleIsClockwise(lineP2, lineP3, testPoint);
        if (pathBendToRight) {
            return rightOfSeg1 && rightOfSeg2;
        }
        return rightOfSeg1 || rightOfSeg2;
    }

    public static boolean angleIsClockwise(Node commonNode, Node firstNode, Node secondNode) {
        return Geometry.angleIsClockwise(commonNode.getEastNorth(), firstNode.getEastNorth(), secondNode.getEastNorth());
    }

    public static EastNorth getSegmentSegmentIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensure(p1, "p1", EastNorth::isValid);
        CheckParameterUtil.ensure(p2, "p2", EastNorth::isValid);
        CheckParameterUtil.ensure(p3, "p3", EastNorth::isValid);
        CheckParameterUtil.ensure(p4, "p4", EastNorth::isValid);
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double x3 = p3.getX();
        double y3 = p3.getY();
        double x4 = p4.getX();
        double y4 = p4.getY();
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a1 = x2 - x1;
        double b1 = x3 - x4;
        double c1 = x3 - x1;
        double a2 = y2 - y1;
        double b2 = y3 - y4;
        double c2 = y3 - y1;
        double det = a1 * b2 - a2 * b1;
        double uu = b2 * c1 - b1 * c2;
        double vv = a1 * c2 - a2 * c1;
        double mag = Math.abs(uu) + Math.abs(vv);
        if (Math.abs(det) > 1.0E-12 * mag) {
            double u = uu / det;
            double v = vv / det;
            if (u > -1.0E-8 && u < 1.00000001 && v > -1.0E-8 && v < 1.00000001) {
                if (u < 0.0) {
                    u = 0.0;
                }
                if (u > 1.0) {
                    u = 1.0;
                }
                return new EastNorth(x1 + a1 * u, y1 + a2 * u);
            }
            return null;
        }
        return null;
    }

    public static EastNorth getLineLineIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensure(p1, "p1", EastNorth::isValid);
        CheckParameterUtil.ensure(p2, "p2", EastNorth::isValid);
        CheckParameterUtil.ensure(p3, "p3", EastNorth::isValid);
        CheckParameterUtil.ensure(p4, "p4", EastNorth::isValid);
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        double c2 = (p4.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p3.getX() - p1.getX()) * (p4.getY() - p1.getY());
        return new EastNorth(b1 * c2 / det + p1.getX(), -a1 * c2 / det + p1.getY());
    }

    public static boolean segmentsParallel(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        CheckParameterUtil.ensure(p1, "p1", EastNorth::isValid);
        CheckParameterUtil.ensure(p2, "p2", EastNorth::isValid);
        CheckParameterUtil.ensure(p3, "p3", EastNorth::isValid);
        CheckParameterUtil.ensure(p4, "p4", EastNorth::isValid);
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double det = a1 * b2 - a2 * b1;
        return Math.abs(det /= Math.sqrt(a1 * a1 + b1 * b1) * Math.sqrt(a2 * a2 + b2 * b2)) < 0.001;
    }

    private static EastNorth closestPointTo(EastNorth p1, EastNorth p2, EastNorth point, boolean segmentOnly) {
        CheckParameterUtil.ensureParameterNotNull(p1, "p1");
        CheckParameterUtil.ensureParameterNotNull(p2, "p2");
        CheckParameterUtil.ensureParameterNotNull(point, "point");
        double ldx = p2.getX() - p1.getX();
        double ldy = p2.getY() - p1.getY();
        if (ldx == 0.0 && ldy == 0.0) {
            return p1;
        }
        double pdx = point.getX() - p1.getX();
        double pdy = point.getY() - p1.getY();
        double offset = (pdx * ldx + pdy * ldy) / (ldx * ldx + ldy * ldy);
        if (segmentOnly && offset <= 0.0) {
            return p1;
        }
        if (segmentOnly && offset >= 1.0) {
            return p2;
        }
        return p1.interpolate(p2, offset);
    }

    public static EastNorth closestPointToSegment(EastNorth segmentP1, EastNorth segmentP2, EastNorth point) {
        return Geometry.closestPointTo(segmentP1, segmentP2, point, true);
    }

    public static EastNorth closestPointToLine(EastNorth lineP1, EastNorth lineP2, EastNorth point) {
        return Geometry.closestPointTo(lineP1, lineP2, point, false);
    }

    public static boolean angleIsClockwise(EastNorth commonNode, EastNorth firstNode, EastNorth secondNode) {
        CheckParameterUtil.ensure(commonNode, "commonNode", EastNorth::isValid);
        CheckParameterUtil.ensure(firstNode, "firstNode", EastNorth::isValid);
        CheckParameterUtil.ensure(secondNode, "secondNode", EastNorth::isValid);
        double dy1 = firstNode.getY() - commonNode.getY();
        double dy2 = secondNode.getY() - commonNode.getY();
        double dx1 = firstNode.getX() - commonNode.getX();
        double dx2 = secondNode.getX() - commonNode.getX();
        return dy1 * dx2 - dx1 * dy2 > 0.0;
    }

    public static Area getArea(List<Node> polygon) {
        Path2D.Double path = new Path2D.Double();
        boolean begin = true;
        for (Node n : polygon) {
            EastNorth en = n.getEastNorth();
            if (en == null) continue;
            if (begin) {
                ((Path2D)path).moveTo(en.getX(), en.getY());
                begin = false;
                continue;
            }
            ((Path2D)path).lineTo(en.getX(), en.getY());
        }
        if (!begin) {
            path.closePath();
        }
        return new Area(path);
    }

    public static Path2D buildPath2DLatLon(List<Node> polygon, Path2D path2d) {
        Path2D path = path2d != null ? path2d : new Path2D.Double();
        boolean begin = true;
        for (Node n : polygon) {
            if (begin) {
                path.moveTo(n.lon(), n.lat());
                begin = false;
                continue;
            }
            path.lineTo(n.lon(), n.lat());
        }
        if (!begin) {
            path.closePath();
        }
        return path;
    }

    public static Area getAreaLatLon(Relation multipolygon) {
        Multipolygon mp = MultipolygonCache.getInstance().get(multipolygon);
        Path2D.Double path = new Path2D.Double();
        path.setWindingRule(0);
        for (Multipolygon.PolyData pd : mp.getCombinedPolygons()) {
            Geometry.buildPath2DLatLon(pd.getNodes(), path);
            for (Multipolygon.PolyData pdInner : pd.getInners()) {
                Geometry.buildPath2DLatLon(pdInner.getNodes(), path);
            }
        }
        return new Area(path);
    }

    public static PolygonIntersection polygonIntersection(List<Node> first, List<Node> second) {
        Area a1 = Geometry.getArea(first);
        Area a2 = Geometry.getArea(second);
        return Geometry.polygonIntersection(a1, a2);
    }

    public static PolygonIntersection polygonIntersection(Area a1, Area a2) {
        return Geometry.polygonIntersection(a1, a2, 1.0);
    }

    public static PolygonIntersection polygonIntersection(Area a1, Area a2, double eps) {
        Area inter = new Area(a1);
        inter.intersect(a2);
        Rectangle bounds = inter.getBounds();
        if (inter.isEmpty() || bounds.getHeight() * bounds.getWidth() <= eps) {
            return PolygonIntersection.OUTSIDE;
        }
        if (a2.getBounds2D().contains(a1.getBounds2D()) && inter.equals(a1)) {
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (a1.getBounds2D().contains(a2.getBounds2D()) && inter.equals(a2)) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node point, List<Node> polygonNodes) {
        if (polygonNodes.size() < 2) {
            return false;
        }
        Node oldPoint = polygonNodes.get(polygonNodes.size() - 1);
        if (!oldPoint.isLatLonKnown()) {
            return false;
        }
        boolean inside = false;
        for (Node newPoint : polygonNodes) {
            Node p2;
            Node p1;
            if (newPoint.equals(oldPoint)) continue;
            if (!newPoint.isLatLonKnown()) {
                return false;
            }
            if (newPoint.getEastNorth().getY() > oldPoint.getEastNorth().getY()) {
                p1 = oldPoint;
                p2 = newPoint;
            } else {
                p1 = newPoint;
                p2 = oldPoint;
            }
            EastNorth pEN = point.getEastNorth();
            EastNorth opEN = oldPoint.getEastNorth();
            EastNorth npEN = newPoint.getEastNorth();
            EastNorth p1EN = p1.getEastNorth();
            EastNorth p2EN = p2.getEastNorth();
            if (pEN != null && opEN != null && npEN != null && p1EN != null && p2EN != null && npEN.getY() < pEN.getY() == pEN.getY() <= opEN.getY() && (pEN.getX() - p1EN.getX()) * (p2EN.getY() - p1EN.getY()) < (p2EN.getX() - p1EN.getX()) * (pEN.getY() - p1EN.getY())) {
                inside = !inside;
            }
            oldPoint = newPoint;
        }
        return inside;
    }

    public static double closedWayArea(Way way) {
        return Geometry.getAreaAndPerimeter(way.getNodes(), Projections.getProjectionByCode("EPSG:54008")).getArea();
    }

    public static double multipolygonArea(Relation multipolygon) {
        double area = 0.0;
        Multipolygon mp = MultipolygonCache.getInstance().get(multipolygon);
        for (Multipolygon.PolyData pd : mp.getCombinedPolygons()) {
            area += pd.getAreaAndPerimeter(Projections.getProjectionByCode("EPSG:54008")).getArea();
        }
        return area;
    }

    public static Double computeArea(OsmPrimitive osm) {
        if (osm instanceof Way && ((Way)osm).isClosed()) {
            return Geometry.closedWayArea((Way)osm);
        }
        if (osm instanceof Relation && ((Relation)osm).isMultipolygon() && !((Relation)osm).hasIncompleteMembers()) {
            return Geometry.multipolygonArea((Relation)osm);
        }
        return null;
    }

    public static boolean isClockwise(Way w) {
        return Geometry.isClockwise(w.getNodes());
    }

    public static boolean isClockwise(List<Node> nodes) {
        int nodesCount = nodes.size();
        if (nodesCount < 3 || nodes.get(0) != nodes.get(nodesCount - 1)) {
            throw new IllegalArgumentException("Way must be closed to check orientation.");
        }
        double area2 = 0.0;
        for (int node = 1; node <= nodesCount; ++node) {
            Node coorPrev = nodes.get(node - 1);
            Node coorCurr = nodes.get(node % nodesCount);
            area2 += coorPrev.lon() * coorCurr.lat();
            area2 -= coorCurr.lon() * coorPrev.lat();
        }
        return area2 < 0.0;
    }

    public static double getSegmentAngle(EastNorth p1, EastNorth p2) {
        CheckParameterUtil.ensure(p1, "p1", EastNorth::isValid);
        CheckParameterUtil.ensure(p2, "p2", EastNorth::isValid);
        return Math.atan2(p2.north() - p1.north(), p2.east() - p1.east());
    }

    public static double getCornerAngle(EastNorth p1, EastNorth p2, EastNorth p3) {
        CheckParameterUtil.ensure(p1, "p1", EastNorth::isValid);
        CheckParameterUtil.ensure(p2, "p2", EastNorth::isValid);
        CheckParameterUtil.ensure(p3, "p3", EastNorth::isValid);
        Double result = Geometry.getSegmentAngle(p2, p1) - Geometry.getSegmentAngle(p2, p3);
        if (result <= -Math.PI) {
            result = result + Math.PI * 2;
        }
        if (result > Math.PI) {
            result = result - Math.PI * 2;
        }
        return result;
    }

    public static EastNorth getCentroid(List<Node> nodes) {
        BigDecimal area = BigDecimal.ZERO;
        BigDecimal north = BigDecimal.ZERO;
        BigDecimal east = BigDecimal.ZERO;
        for (int i = 0; i < nodes.size(); ++i) {
            EastNorth n0 = nodes.get(i).getEastNorth();
            EastNorth n1 = nodes.get((i + 1) % nodes.size()).getEastNorth();
            if (n0 == null || n1 == null || !n0.isValid() || !n1.isValid()) continue;
            BigDecimal x0 = BigDecimal.valueOf(n0.east());
            BigDecimal y0 = BigDecimal.valueOf(n0.north());
            BigDecimal x1 = BigDecimal.valueOf(n1.east());
            BigDecimal y1 = BigDecimal.valueOf(n1.north());
            BigDecimal k = x0.multiply(y1, MathContext.DECIMAL128).subtract(y0.multiply(x1, MathContext.DECIMAL128));
            area = area.add(k, MathContext.DECIMAL128);
            east = east.add(k.multiply(x0.add(x1, MathContext.DECIMAL128), MathContext.DECIMAL128));
            north = north.add(k.multiply(y0.add(y1, MathContext.DECIMAL128), MathContext.DECIMAL128));
        }
        BigDecimal d = new BigDecimal(3, MathContext.DECIMAL128);
        if ((area = area.multiply(d, MathContext.DECIMAL128)).compareTo(BigDecimal.ZERO) != 0) {
            north = north.divide(area, MathContext.DECIMAL128);
            east = east.divide(area, MathContext.DECIMAL128);
        }
        return new EastNorth(east.doubleValue(), north.doubleValue());
    }

    public static EastNorth getCenter(List<Node> nodes) {
        int nc = nodes.size();
        if (nc < 3) {
            return null;
        }
        double[] a = new double[nc];
        double[] b = new double[nc];
        double[] c = new double[nc];
        for (int i = 0; i < nc; ++i) {
            EastNorth pt1 = nodes.get(i).getEastNorth();
            EastNorth pt2 = nodes.get((i + 1) % nc).getEastNorth();
            a[i] = pt1.east() - pt2.east();
            b[i] = pt1.north() - pt2.north();
            double d = Math.sqrt(a[i] * a[i] + b[i] * b[i]);
            if (d == 0.0) {
                return null;
            }
            int n = i;
            a[n] = a[n] / d;
            int n2 = i;
            b[n2] = b[n2] / d;
            double xC = (pt1.east() + pt2.east()) / 2.0;
            double yC = (pt1.north() + pt2.north()) / 2.0;
            c[i] = -(a[i] * xC + b[i] * yC);
        }
        double a11 = 0.0;
        double a12 = 0.0;
        double a22 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < nc; ++i) {
            a11 += a[i] * a[i];
            a12 += a[i] * b[i];
            a22 += b[i] * b[i];
            b1 -= a[i] * c[i];
            b2 -= b[i] * c[i];
        }
        double det = a11 * a22 - a12 * a12;
        if (Math.abs(det) < 1.0E-5) {
            return null;
        }
        double inv11 = a22 / det;
        double inv12 = -a12 / det;
        double inv22 = a11 / det;
        double xC = inv11 * b1 + inv12 * b2;
        double yC = inv12 * b1 + inv22 * b2;
        return new EastNorth(xC, yC);
    }

    public static boolean isNodeInsideMultiPolygon(Node node, Relation multiPolygon, Predicate<Way> isOuterWayAMatch) {
        return Geometry.isPolygonInsideMultiPolygon(Collections.singletonList(node), multiPolygon, isOuterWayAMatch);
    }

    public static boolean isPolygonInsideMultiPolygon(List<Node> nodes, Relation multiPolygon, Predicate<Way> isOuterWayAMatch) {
        Pair<List<MultipolygonBuilder.JoinedPolygon>, List<MultipolygonBuilder.JoinedPolygon>> outerInner;
        try {
            outerInner = MultipolygonBuilder.joinWays(multiPolygon);
        }
        catch (MultipolygonBuilder.JoinedPolygonCreationException ex) {
            Logging.trace(ex);
            Logging.debug("Invalid multipolygon " + multiPolygon);
            return false;
        }
        for (MultipolygonBuilder.JoinedPolygon out : (List)outerInner.a) {
            if (!(nodes.size() == 1 ? Geometry.nodeInsidePolygon(nodes.get(0), out.getNodes()) : EnumSet.of(PolygonIntersection.FIRST_INSIDE_SECOND, PolygonIntersection.CROSSING).contains((Object)Geometry.polygonIntersection(nodes, out.getNodes())))) continue;
            boolean insideInner = false;
            for (MultipolygonBuilder.JoinedPolygon in : (List)outerInner.b) {
                if (Geometry.polygonIntersection(in.getNodes(), out.getNodes()) != PolygonIntersection.FIRST_INSIDE_SECOND || !(nodes.size() == 1 ? Geometry.nodeInsidePolygon(nodes.get(0), in.getNodes()) : Geometry.polygonIntersection(nodes, in.getNodes()) == PolygonIntersection.FIRST_INSIDE_SECOND)) continue;
                insideInner = true;
                break;
            }
            if (insideInner || isOuterWayAMatch != null && !isOuterWayAMatch.test(out.ways.get(0))) continue;
            return true;
        }
        return false;
    }

    public static AreaAndPerimeter getAreaAndPerimeter(List<Node> nodes) {
        return Geometry.getAreaAndPerimeter(nodes, null);
    }

    public static AreaAndPerimeter getAreaAndPerimeter(List<Node> nodes, Projection projection) {
        Projection useProjection;
        CheckParameterUtil.ensureParameterNotNull(nodes, "nodes");
        double area = 0.0;
        double perimeter = 0.0;
        Projection projection2 = useProjection = projection == null ? Main.getProjection() : projection;
        if (!nodes.isEmpty()) {
            boolean closed = nodes.get(0) == nodes.get(nodes.size() - 1);
            int numSegments = closed ? nodes.size() - 1 : nodes.size();
            EastNorth p1 = nodes.get(0).getEastNorth(useProjection);
            for (int i = 1; i <= numSegments; ++i) {
                Node node = nodes.get(i == numSegments ? 0 : i);
                EastNorth p2 = node.getEastNorth(useProjection);
                if (p1 != null && p2 != null) {
                    area += p1.east() * p2.north() - p2.east() * p1.north();
                    perimeter += p1.distance(p2);
                }
                p1 = p2;
            }
        }
        return new AreaAndPerimeter(Math.abs(area) / 2.0, perimeter);
    }

    public static class AreaAndPerimeter {
        private final double area;
        private final double perimeter;

        public AreaAndPerimeter(double area, double perimeter) {
            this.area = area;
            this.perimeter = perimeter;
        }

        public double getArea() {
            return this.area;
        }

        public double getPerimeter() {
            return this.perimeter;
        }
    }

    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

